/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Scanner;

public class ConsoleHook {
    static final String DEBUG_FILE_NAME = "debug.properties";
    static final String DEBUG_BKFILE_NAME = "debug.properties.bak";
    static final String DEBUG_TMPFILE_NAME = "debug.properties.tmp";
    static final String LOCAL_PERMISSION = "allowed=localhost";
    static final String PROP_DEBUG_SERVER = "debug.server";
    static final String CLI_PROMPT = "% ";
    static final int SOCKET_TIMEOUT = 60000;
    private static PrintStream output = System.out;
    private File debugFile = null;
    private File debugBkFile = null;
    private boolean hasBkFile = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableLocalDebug() {
        this.debugFile = new File(ClientCache.getInstallLocation() + DEBUG_FILE_NAME);
        if (this.debugFile.exists()) {
            this.debugBkFile = new File(ClientCache.getInstallLocation() + DEBUG_BKFILE_NAME);
            this.debugFile.renameTo(this.debugBkFile);
            this.hasBkFile = true;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.debugFile));
            writer.write(LOCAL_PERMISSION);
        }
        catch (IOException ex) {
            ex.printStackTrace(output);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void rollbackDebug() {
        if (this.hasBkFile && this.debugBkFile.exists()) {
            this.debugFile.delete();
            this.debugBkFile.renameTo(this.debugFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCliCmd(String cmd, int socketTimeout) {
        Socket socket = null;
        BufferedReader reader = null;
        PrintStream writer = null;
        try {
            GenUtil.loadServerProperties(null);
            socket = new Socket("localhost", (int)Integer.getInteger(PROP_DEBUG_SERVER, 9197));
            socket.setSoTimeout(socketTimeout);
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            writer = new PrintStream(socket.getOutputStream(), true);
            writer.println(cmd);
            writer.println("\n");
            String readLine = null;
            while (!Thread.interrupted()) {
                try {
                    readLine = reader.readLine();
                }
                catch (SocketTimeoutException ex) {
                    output.print("Hook socket timed out");
                    break;
                }
                output.println(readLine);
                if (!readLine.equals(CLI_PROMPT) && readLine.indexOf("Done") < 0 && readLine.indexOf("Exception") < 0 && readLine.indexOf("ERROR") < 0) continue;
                break;
            }
        }
        catch (Exception ex) {
            output.println("Encountered exception:" + ex.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(output);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(output);
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(output);
                }
            }
        }
    }

    public static void main(String[] params) {
        if (params.length == 0) {
            output.println("No command entered, exit");
            System.exit(0);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : params) {
            sb.append(s).append(' ');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        ConsoleHook console = new ConsoleHook();
        output.println("Execute command:" + sb.toString());
        console.enableLocalDebug();
        console.executeCliCmd(sb.toString(), 60000);
        console.rollbackDebug();
        Scanner in = new Scanner(System.in);
        while (true) {
            System.out.println("\nPress Enter to exit");
            String answer = in.nextLine();
            if (answer == null) continue;
            System.exit(0);
        }
    }
}

