/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util.fcoe;

import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigCommandsIf;
import com.cisco.dcbu.lib.util.fcoe.MDSFCoEConfigurationCommands;
import com.cisco.dcbu.lib.util.fcoe.N5KFCoEConfigurationCommands;
import com.cisco.dcbu.lib.util.fcoe.N7KFCoEConfigurationCommands;
import javax.swing.JFrame;

public class FCoEConfigurationCommandsFactory {
    private static FCoEConfigurationCommandsFactory _instance;

    private FCoEConfigurationCommandsFactory() {
    }

    public static synchronized FCoEConfigurationCommandsFactory getInstance() {
        if (_instance == null) {
            _instance = new FCoEConfigurationCommandsFactory();
        }
        return _instance;
    }

    public FCoEConfigCommandsIf getFCoEConfigurationCommands(JFrame frame, SnmpPeer selectedPeer, SwitchAttrIf selectedSwitch) {
        if (selectedSwitch.isNuovaFamily()) {
            return new N5KFCoEConfigurationCommands(frame, selectedPeer, selectedSwitch);
        }
        if (selectedSwitch.isN7K()) {
            return new N7KFCoEConfigurationCommands(frame, selectedPeer, selectedSwitch);
        }
        if (selectedSwitch.isMDS()) {
            return new MDSFCoEConfigurationCommands(frame, selectedPeer, selectedSwitch);
        }
        return new N5KFCoEConfigurationCommands(frame, selectedPeer, selectedSwitch);
    }
}

