/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client;

import com.cisco.dcbu.sm.client.FMClientInterceptor;
import com.cisco.dcbu.sm.client.ReferenceIf;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import com.cisco.dcbu.sm.common.rif.EMRif;
import com.cisco.dcbu.sm.common.rif.ESPRif;
import com.cisco.dcbu.sm.common.rif.FCoEConfigurationRif;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.FlexAtahRif;
import com.cisco.dcbu.sm.common.rif.IOARif;
import com.cisco.dcbu.sm.common.rif.IndexerRif;
import com.cisco.dcbu.sm.common.rif.InventoryServiceRif;
import com.cisco.dcbu.sm.common.rif.IscRif;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.NPVRif;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.rif.PortSecurityRif;
import com.cisco.dcbu.sm.common.rif.SchedulerRif;
import com.cisco.dcbu.sm.common.rif.SecureEraseRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.rif.SuperSessionRif;
import com.cisco.dcbu.sm.common.rif.TopologyManager;
import com.cisco.dcbu.sm.common.rif.TopologyRemote;
import com.cisco.dcbu.sm.common.rif.WebAnalysisRif;
import com.cisco.dcbu.sm.common.rif.WebZoneRif;
import com.cisco.dcbu.sm.common.rif.facade.AnalysisRif;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;

class EjbReference
implements ReferenceIf {
    private static EjbReference _Instance = null;
    String _server;
    int _port;
    boolean _useSSL;
    InitialContext _context;
    private FMServerRif _FmServerRif;
    private SessionRif _sessionRif;
    private DDMServerRif _ddmServerRif;
    private SecureEraseRif _secureEraseRif;
    private InventoryServiceRif _inventoryRif;
    private ModelFacadeRif _modelFacadeRif;
    private TopologyRemote _topologyRif;
    private SchedulerRif _SchedulerRif;
    private IscRif _IscRif;
    private TopologyManager _TopologyMgrRif;
    private PMRif _pmRif;
    private EMRif _emRif;
    private NPVRif _npvRif;
    private FlexAtahRif _flexAtahRif;
    private PortSecurityRif _psRif;
    private FCoEConfigurationRif _fcoeRif;
    private WebAnalysisRif _webRif;
    private WebZoneRif _webZoneRif;
    private IndexerRif _IndexerRif;
    private IOARif _ioaRif;
    private ESPRif _espRif;
    private AnalysisRif _analysisRif;
    static Logger _Logger = Logger.getLogger(EjbReference.class);

    static EjbReference getInstance(String server, int port, boolean useSSL) throws RemoteException {
        if (_Instance == null || !EjbReference._Instance._server.equals(server) || EjbReference._Instance._port != port || EjbReference._Instance._useSSL != useSSL) {
            _Instance = new EjbReference(server, port, useSSL);
        }
        return _Instance;
    }

    static EjbReference getNewInstance(String server, int port, boolean useSSL) throws RemoteException {
        _Instance = new EjbReference(server, port, useSSL);
        return _Instance;
    }

    private EjbReference(String server, int port, boolean useSSL) throws RemoteException {
        this._server = server;
        this._port = port;
        this._useSSL = useSSL;
        this._context = this.initContext(this._server);
        EJBClientContext.getCurrent().registerInterceptor(1, (EJBClientInterceptor)new FMClientInterceptor());
    }

    private InitialContext initContext(String server) throws RemoteException {
        try {
            Properties ejbclientProperties = new Properties();
            if (this._useSSL) {
                ejbclientProperties.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "true");
            } else {
                ejbclientProperties.put("remote.connectionprovider.create.options.org.xnio.Options.SSL_ENABLED", "false");
            }
            ejbclientProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
            ejbclientProperties.put("remote.connections", "default");
            ejbclientProperties.put("remote.connection.default.host", server);
            ejbclientProperties.put("remote.connection.default.port", "" + this._port);
            ejbclientProperties.put("remote.connection.default.username", "admin");
            ejbclientProperties.put("remote.connection.default.password", "nbv_12345");
            PropertiesBasedEJBClientConfiguration cc = new PropertiesBasedEJBClientConfiguration(ejbclientProperties);
            ConfigBasedEJBClientContextSelector selector = new ConfigBasedEJBClientContextSelector((EJBClientConfiguration)cc);
            EJBClientContext.setSelector((ContextSelector)selector);
            InitialContext ret = new InitialContext(ejbclientProperties);
            return ret;
        }
        catch (NamingException ex) {
            _Logger.info((Object)ex.getMessage());
            ex.printStackTrace();
            throw new RemoteException("can not get initial context from:" + this._server, ex);
        }
    }

    private String getProtocolString() {
        String ret = this._useSSL ? "ssl" : "remote";
        _Logger.debug((Object)("jndi lookup postfix:" + ret));
        return ret;
    }

    @Override
    public FMServerRif getFMServer() throws Exception {
        try {
            this._FmServerRif = null;
            this._FmServerRif = (FMServerRif)this._context.lookup("ejb:dcm/dcm/FMServerBean!" + FMServerRif.class.getName());
            return this._FmServerRif;
        }
        catch (Throwable th) {
            _Logger.info((Object)"try second lookup");
            _Logger.info((Object)th.getMessage());
            th.printStackTrace();
            this._FmServerRif = (FMServerRif)this._context.lookup("ejb:dcm/dcm/FMServerBean!" + FMServerRif.class.getName());
            return this._FmServerRif;
        }
    }

    @Override
    public FMServerRif pingFMServer() throws Exception {
        this._FmServerRif = null;
        try {
            this._FmServerRif = (FMServerRif)this._context.lookup("ejb:dcm/dcm/FMServerBean!" + FMServerRif.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._FmServerRif;
    }

    @Override
    public ModelFacadeRif getModelFacade() throws Exception {
        if (this._modelFacadeRif == null) {
            this._modelFacadeRif = (ModelFacadeRif)this._context.lookup("ejb:dcm/dcm/ModelFacadeBean!" + ModelFacadeRif.class.getName());
        }
        return this._modelFacadeRif;
    }

    @Override
    public TopologyRemote getTopology() throws Exception {
        if (this._topologyRif == null) {
            this._topologyRif = (TopologyRemote)this._context.lookup("ejb:dcm/dcm/TopologyBean!" + TopologyRemote.class.getName());
        }
        return this._topologyRif;
    }

    @Override
    public DDMServerRif getDDMServer() throws Exception {
        if (this._ddmServerRif == null) {
            this._ddmServerRif = (DDMServerRif)this._context.lookup("ejb:dcm/dcm/DDMServerBean!" + DDMServerRif.class.getName());
        }
        return this._ddmServerRif;
    }

    @Override
    public SecureEraseRif getSecureEraseService() throws Exception {
        if (this._secureEraseRif == null) {
            this._secureEraseRif = (SecureEraseRif)this._context.lookup("ejb:dcm/dcm/SecureEraseBean!" + SecureEraseRif.class.getName());
        }
        return this._secureEraseRif;
    }

    @Override
    public InventoryServiceRif getInventoryService() throws Exception {
        if (this._inventoryRif == null) {
            this._inventoryRif = (InventoryServiceRif)this._context.lookup("ejb:dcm/dcm/InventoryServiceBean!" + InventoryServiceRif.class.getName());
        }
        return this._inventoryRif;
    }

    @Override
    public EMRif getEM() throws Exception {
        if (this._emRif == null) {
            this._emRif = (EMRif)this._context.lookup("ejb:dcm/dcm/EMBean!" + EMRif.class.getName());
        }
        return this._emRif;
    }

    @Override
    public PMRif getPM() throws Exception {
        if (this._pmRif == null) {
            this._pmRif = (PMRif)this._context.lookup("ejb:dcm/dcm/PMBean!" + PMRif.class.getName());
        }
        return this._pmRif;
    }

    @Override
    public IOARif getIOA() throws Exception {
        if (this._ioaRif == null) {
            this._ioaRif = (IOARif)this._context.lookup("ejb:dcm/dcm/IOABean!" + IOARif.class.getName());
        }
        return this._ioaRif;
    }

    @Override
    public SchedulerRif getScheduler() throws Exception {
        if (this._SchedulerRif == null) {
            this._SchedulerRif = (SchedulerRif)this._context.lookup("ejb:dcm/dcm/SchedulerManagerBean!" + SchedulerRif.class.getName());
        }
        return this._SchedulerRif;
    }

    @Override
    public IscRif getIsc() throws Exception {
        if (this._IscRif == null) {
            this._IscRif = (IscRif)this._context.lookup("ejb:dcm/dcm/IscBean!" + IscRif.class.getName());
        }
        return this._IscRif;
    }

    @Override
    public TopologyManager getTopologyMgr() throws Exception {
        if (this._TopologyMgrRif == null) {
            this._TopologyMgrRif = (TopologyManager)this._context.lookup("ejb:dcm/dcm/TopologyBean!" + TopologyManager.class.getName());
        }
        return this._TopologyMgrRif;
    }

    @Override
    public NPVRif getNPV() throws Exception {
        if (this._npvRif == null) {
            this._npvRif = (NPVRif)this._context.lookup("ejb:dcm/dcm/NPVBean!" + NPVRif.class.getName());
        }
        return this._npvRif;
    }

    @Override
    public FlexAtahRif getFlexAtah() throws Exception {
        if (this._flexAtahRif == null) {
            this._flexAtahRif = (FlexAtahRif)this._context.lookup("ejb:dcm/dcm/FlexAtahBean!" + FlexAtahRif.class.getName());
        }
        return this._flexAtahRif;
    }

    @Override
    public ESPRif getESP() throws Exception {
        if (this._espRif == null) {
            this._espRif = (ESPRif)this._context.lookup("ejb:dcm/dcm/ESPBean!" + ESPRif.class.getName());
        }
        return this._espRif;
    }

    @Override
    public SessionRif getSession() throws Exception {
        if (this._sessionRif == null) {
            this._sessionRif = (SessionRif)this._context.lookup("ejb:dcm/dcm/FMSuperSessionBean!" + SuperSessionRif.class.getName());
        }
        return this._sessionRif;
    }

    @Override
    public PortSecurityRif getPortSecurity() throws Exception {
        if (this._psRif == null) {
            this._psRif = (PortSecurityRif)this._context.lookup("ejb:dcm/dcm/PortSecurityBean!" + PortSecurityRif.class.getName());
        }
        return this._psRif;
    }

    @Override
    public FCoEConfigurationRif getFCoEConfiguration() throws Exception {
        if (this._fcoeRif == null) {
            this._fcoeRif = (FCoEConfigurationRif)this._context.lookup("ejb:dcm/dcm/FCoEConfigurationBean!" + FCoEConfigurationRif.class.getName());
        }
        return this._fcoeRif;
    }

    @Override
    public WebAnalysisRif getWebAnalysis() throws Exception {
        if (this._webRif == null) {
            this._webRif = (WebAnalysisRif)this._context.lookup("ejb:dcm/dcm/WebAnalysisBean!" + WebAnalysisRif.class.getName());
        }
        return this._webRif;
    }

    @Override
    public WebZoneRif getWebZone() throws Exception {
        if (this._webZoneRif == null) {
            this._webZoneRif = (WebZoneRif)this._context.lookup("dcm/WebZoneBean/" + this.getProtocolString());
        }
        return this._webZoneRif;
    }

    @Override
    public AnalysisRif getAnalysis() throws Exception {
        if (this._analysisRif == null) {
            this._analysisRif = (AnalysisRif)this._context.lookup("ejb:dcm/dcm/AnalysisBean!" + AnalysisRif.class.getName());
        }
        return this._analysisRif;
    }

    @Override
    public Object getRemoteService(String bindAddr, String facilityName) throws Exception {
        Object ret = null;
        InitialContext context = this.initContext(bindAddr);
        EJBClientContext.getCurrent().registerInterceptor(1, (EJBClientInterceptor)new FMClientInterceptor());
        ret = context.lookup("ejb:dcm/" + facilityName + "/" + this.getProtocolString());
        return ret;
    }

    @Override
    public Object getRemoteService(String bindAddr, String facilityName, String interfaceName) throws Exception {
        Object ret = null;
        InitialContext context = this.initContext(bindAddr);
        EJBClientContext.getCurrent().registerInterceptor(1, (EJBClientInterceptor)new FMClientInterceptor());
        ret = context.lookup("ejb:dcm/dcm/" + facilityName + "!" + interfaceName);
        return ret;
    }

    @Override
    public IndexerRif getIndexer() throws Exception {
        if (this._IndexerRif == null) {
            this._IndexerRif = (IndexerRif)this._context.lookup("ejb:dcm/dcm/IndexerMBean!" + IndexerRif.class.getName());
        }
        return this._IndexerRif;
    }
}

