/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client;

import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.SyncedBoolean;
import com.cisco.dcbu.sm.client.AdminProxyInvocationHandler;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.ProxyInvocationHandler;
import com.cisco.dcbu.sm.client.ReferenceFactory;
import com.cisco.dcbu.sm.client.ReferenceIf;
import com.cisco.dcbu.sm.client.SM;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.common.event.ConnectionListener;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import com.cisco.dcbu.sm.common.rif.ESPRif;
import com.cisco.dcbu.sm.common.rif.FCoEConfigurationRif;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.FlexAtahRif;
import com.cisco.dcbu.sm.common.rif.IOARif;
import com.cisco.dcbu.sm.common.rif.InventoryServiceRif;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.NPVRif;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.rif.PortSecurityRif;
import com.cisco.dcbu.sm.common.rif.SecureEraseRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.rif.SuperSessionRif;
import com.cisco.dcbu.sm.common.rif.TopologyRemote;
import com.cisco.dcbu.sm.common.rif.WebAnalysisRif;
import com.cisco.dcbu.sm.common.rif.facade.AnalysisRif;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ServerConnection
extends TimerTask
implements ConnectionListener {
    private static final int PING_INTERVAL = 30000;
    private static ServerConnection _Instance = new ServerConnection();
    private static Logger _Logger = Logger.getLogger(ServerConnection.class);
    private FMServerRif _fmServerRif = null;
    private ReferenceIf _rif = null;
    private String _server;
    private int _port;
    private String _username;
    private String _password;
    private boolean _useSSL = false;
    private ProxyInvocationHandler _sessionHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _modelFacadeHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _inventoryHandler = new ProxyInvocationHandler(this);
    private AdminProxyInvocationHandler _ddmServerHandler = new AdminProxyInvocationHandler(this);
    private AdminProxyInvocationHandler _secureEraseHandler = new AdminProxyInvocationHandler(this);
    private ProxyInvocationHandler _topologyHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _npvHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _flexAtahHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _psHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _fcoeHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _webHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _pmHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _ioaHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _espHandler = new ProxyInvocationHandler(this);
    private ProxyInvocationHandler _analysisHandler = new ProxyInvocationHandler(this);
    private SessionRif _sessionProxy = null;
    private ModelFacadeRif _modelFacadeProxy = null;
    private InventoryServiceRif _inventoryProxy = null;
    private DDMServerRif _ddmServerProxy = null;
    private SecureEraseRif _secureEraseProxy = null;
    private TopologyRemote _topologyProxy = null;
    private NPVRif _npvProxy = null;
    private FlexAtahRif _flexAtahProxy = null;
    private SyncedBoolean _connecting = new SyncedBoolean(false);
    private PortSecurityRif _psProxy = null;
    private FCoEConfigurationRif _fcoeProxy = null;
    private WebAnalysisRif _webProxy = null;
    private PMRif _pmProxy = null;
    private IOARif _ioaProxy = null;
    private ESPRif _espProxy = null;
    private AnalysisRif _analysisProxy = null;
    private Timer _timer = null;
    private boolean _standAlone = false;
    private String _sessionId;
    private boolean _usePassphrase = false;

    private ServerConnection() {
        String isStandAlone = System.getProperty("fm.standalone", "false");
        this._standAlone = Boolean.parseBoolean(isStandAlone);
    }

    public static ServerConnection getInstance() {
        return _Instance;
    }

    public FMServerRif getFMServerRif() {
        return this._fmServerRif;
    }

    public String getServerAddress() {
        return this._server;
    }

    public int getServerPort() {
        return this._port;
    }

    public void reset(String ip) throws Exception {
        System.setProperty("fm.sessionid", "-1");
        this.closeConnection();
        if (this.login(ip, this._port, this._username, ClientController.decrypt(this._password).toCharArray(), this._useSSL) != null) {
            System.setProperty("fm.sessionid", this._sessionId);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrowserFrame.getInstance().updateTitle();
                    }
                    catch (Exception ex) {
                        _Logger.error((Object)"updateTitle failed ", (Throwable)ex);
                    }
                }
            });
        }
    }

    public FMServerRif login(String server, int port, String username, char[] password, boolean useSSL) throws Exception {
        if (server == null) {
            throw new Exception("DCNM-SAN server not set");
        }
        this._rif = ReferenceFactory.getInstance(server, port, useSSL);
        this._fmServerRif = this._rif.getFMServer();
        long fStart = System.currentTimeMillis();
        String serverVersion = this._fmServerRif.checkCompatibility("6.3(1)");
        if (_Logger.isInfoEnabled()) {
            _Logger.info((Object)("time in ServerConnection.login() method \"checkCompatibility()\"- " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        if (serverVersion != null && !"6.3(1)".contains("dev") && !"6.3(1)".contains("DEV")) {
            this._fmServerRif = null;
            throw new Exception("This DCNM-SAN client version 6.3(1) is not compatible with server version " + serverVersion + "\nPlease use client version " + serverVersion + "\n(You can download client from http://" + server + ")");
        }
        this._server = server;
        this._port = port;
        this._username = username;
        this._password = ClientController.encrypt(String.valueOf(password));
        fStart = System.currentTimeMillis();
        this.loginSession();
        if (_Logger.isInfoEnabled()) {
            _Logger.info((Object)("time in ServerConnection.loginSession() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        return this._fmServerRif;
    }

    public FMServerRif login(String server, int port, String passphrase, boolean useSSL) throws Exception {
        if (server == null) {
            throw new Exception("DCNM-SAN server not set");
        }
        this._rif = ReferenceFactory.getInstance(server, port, useSSL);
        this._fmServerRif = this._rif.getFMServer();
        long fStart = System.currentTimeMillis();
        String serverVersion = this._fmServerRif.checkCompatibility("6.3(1)");
        if (_Logger.isInfoEnabled()) {
            _Logger.info((Object)("time in ServerConnection.login(passphrase) method \"checkCompatibility()\"- " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        if (serverVersion != null) {
            // empty if block
        }
        this._server = server;
        this._port = port;
        this._username = passphrase;
        this._usePassphrase = true;
        fStart = System.currentTimeMillis();
        this.loginSession();
        if (_Logger.isInfoEnabled()) {
            _Logger.info((Object)("time in ServerConnection.loginSession() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        return this._fmServerRif;
    }

    private void loginSession() throws Exception {
        if (this._fmServerRif == null) {
            _Logger.error((Object)"Ignore login: server is down.");
            return;
        }
        if (this._sessionHandler == null) {
            this._sessionHandler = new ProxyInvocationHandler(this);
        }
        if (this._modelFacadeHandler == null) {
            this._modelFacadeHandler = new ProxyInvocationHandler(this);
        }
        if (this._inventoryHandler == null) {
            this._inventoryHandler = new ProxyInvocationHandler(this);
        }
        if (this._ddmServerHandler == null) {
            this._ddmServerHandler = new AdminProxyInvocationHandler(this);
        }
        if (this._secureEraseHandler == null) {
            this._secureEraseHandler = new AdminProxyInvocationHandler(this);
        }
        if (this._topologyHandler == null) {
            this._topologyHandler = new ProxyInvocationHandler(this);
        }
        if (this._npvHandler == null) {
            this._npvHandler = new ProxyInvocationHandler(this);
        }
        if (this._flexAtahHandler == null) {
            this._flexAtahHandler = new ProxyInvocationHandler(this);
        }
        if (this._psHandler == null) {
            this._psHandler = new ProxyInvocationHandler(this);
        }
        if (this._fcoeHandler == null) {
            this._fcoeHandler = new ProxyInvocationHandler(this);
        }
        if (this._webHandler == null) {
            this._webHandler = new ProxyInvocationHandler(this);
        }
        if (this._pmHandler == null) {
            this._pmHandler = new ProxyInvocationHandler(this);
        }
        if (this._ioaHandler == null) {
            this._ioaHandler = new ProxyInvocationHandler(this);
        }
        if (this._espHandler == null) {
            this._espHandler = new ProxyInvocationHandler(this);
        }
        if (this._analysisHandler == null) {
            this._analysisHandler = new ProxyInvocationHandler(this);
        }
        this._sessionHandler.setTargetObj(null);
        this._modelFacadeHandler.setTargetObj(null);
        this._inventoryHandler.setTargetObj(null);
        this._topologyHandler.setTargetObj(null);
        this._npvHandler.setTargetObj(null);
        this._flexAtahHandler.setTargetObj(null);
        this._psHandler.setTargetObj(null);
        this._fcoeHandler.setTargetObj(null);
        this._webHandler.setTargetObj(null);
        this._pmHandler.setTargetObj(null);
        this._ioaHandler.setTargetObj(null);
        this._espHandler.setTargetObj(null);
        this._analysisHandler.setTargetObj(null);
        SessionRif sessionRif = null;
        this._sessionId = null;
        long fStart = System.currentTimeMillis();
        sessionRif = this.attemptLogin();
        if (!this._standAlone && this._timer == null) {
            this._timer = new Timer("ClientPing");
            this._timer.schedule((TimerTask)this, 30000L, 30000L);
        }
        if (_Logger.isInfoEnabled()) {
            _Logger.info((Object)("time in ServerConnection.attemptLogin() method - " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        fStart = System.currentTimeMillis();
        ModelFacadeRif modelFacadeRif = this._rif.getModelFacade();
        if (SM._FmStandalone) {
            modelFacadeRif.init(sessionRif);
        }
        InventoryServiceRif inventoryRif = this._rif.getInventoryService();
        DDMServerRif ddmServerRif = this._rif.getDDMServer();
        ddmServerRif.init(sessionRif);
        SecureEraseRif secureEraseRif = this._rif.getSecureEraseService();
        secureEraseRif.init(sessionRif);
        TopologyRemote topologyRif = this._rif.getTopology();
        NPVRif npvRif = this._rif.getNPV();
        FlexAtahRif flexAtahRif = this._rif.getFlexAtah();
        PortSecurityRif psRif = this._rif.getPortSecurity();
        FCoEConfigurationRif fcoeRif = this._rif.getFCoEConfiguration();
        fcoeRif.init(sessionRif);
        WebAnalysisRif webRif = this._rif.getWebAnalysis();
        PMRif pmRif = this._rif.getPM();
        IOARif ioaRif = this._rif.getIOA();
        ESPRif espRif = this._rif.getESP();
        espRif.init(sessionRif);
        AnalysisRif analysisRif = this._rif.getAnalysis();
        if (_Logger.isInfoEnabled()) {
            _Logger.info((Object)("time in ServerConnection.loginSession() method (get RIF objects)- " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        fStart = System.currentTimeMillis();
        this._sessionHandler.setTargetObj(sessionRif);
        this._modelFacadeHandler.setTargetObj(modelFacadeRif);
        this._inventoryHandler.setTargetObj(inventoryRif);
        this._ddmServerHandler.setTargetObj(ddmServerRif);
        this._ddmServerHandler.setAdminRole(sessionRif.isAdmin());
        this._secureEraseHandler.setTargetObj(secureEraseRif);
        this._secureEraseHandler.setAdminRole(sessionRif.isAdmin());
        this._topologyHandler.setTargetObj(topologyRif);
        this._npvHandler.setTargetObj(npvRif);
        this._flexAtahHandler.setTargetObj(flexAtahRif);
        this._psHandler.setTargetObj(psRif);
        this._fcoeHandler.setTargetObj(fcoeRif);
        this._webHandler.setTargetObj(webRif);
        this._pmHandler.setTargetObj(pmRif);
        this._ioaHandler.setTargetObj(ioaRif);
        this._espHandler.setTargetObj(espRif);
        this._analysisHandler.setTargetObj(analysisRif);
        if (_Logger.isInfoEnabled()) {
            _Logger.info((Object)("time in ServerConnection.loginSession() method (set handler objects)- " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
        }
        if (this._sessionProxy == null) {
            this._sessionProxy = sessionRif instanceof SuperSessionRif ? (SuperSessionRif)Proxy.newProxyInstance(SuperSessionRif.class.getClassLoader(), new Class[]{SuperSessionRif.class}, (InvocationHandler)this._sessionHandler) : (SessionRif)Proxy.newProxyInstance(SessionRif.class.getClassLoader(), new Class[]{SessionRif.class}, (InvocationHandler)this._sessionHandler);
        }
        if (this._modelFacadeProxy == null) {
            this._modelFacadeProxy = (ModelFacadeRif)Proxy.newProxyInstance(ModelFacadeRif.class.getClassLoader(), new Class[]{ModelFacadeRif.class}, (InvocationHandler)this._modelFacadeHandler);
        }
        if (this._inventoryProxy == null) {
            this._inventoryProxy = (InventoryServiceRif)Proxy.newProxyInstance(InventoryServiceRif.class.getClassLoader(), new Class[]{InventoryServiceRif.class}, (InvocationHandler)this._inventoryHandler);
        }
        if (this._ddmServerProxy == null) {
            this._ddmServerProxy = (DDMServerRif)Proxy.newProxyInstance(DDMServerRif.class.getClassLoader(), new Class[]{DDMServerRif.class}, (InvocationHandler)this._ddmServerHandler);
        }
        if (this._secureEraseProxy == null) {
            this._secureEraseProxy = (SecureEraseRif)Proxy.newProxyInstance(SecureEraseRif.class.getClassLoader(), new Class[]{SecureEraseRif.class}, (InvocationHandler)this._secureEraseHandler);
        }
        if (this._topologyProxy == null) {
            this._topologyProxy = (TopologyRemote)Proxy.newProxyInstance(TopologyRemote.class.getClassLoader(), new Class[]{TopologyRemote.class}, (InvocationHandler)this._topologyHandler);
        }
        if (this._npvProxy == null) {
            this._npvProxy = (NPVRif)Proxy.newProxyInstance(NPVRif.class.getClassLoader(), new Class[]{NPVRif.class}, (InvocationHandler)this._npvHandler);
        }
        if (this._flexAtahProxy == null) {
            this._flexAtahProxy = (FlexAtahRif)Proxy.newProxyInstance(FlexAtahRif.class.getClassLoader(), new Class[]{FlexAtahRif.class}, (InvocationHandler)this._flexAtahHandler);
        }
        if (this._psProxy == null) {
            this._psProxy = (PortSecurityRif)Proxy.newProxyInstance(PortSecurityRif.class.getClassLoader(), new Class[]{PortSecurityRif.class}, (InvocationHandler)this._psHandler);
        }
        if (this._fcoeProxy == null) {
            this._fcoeProxy = (FCoEConfigurationRif)Proxy.newProxyInstance(FCoEConfigurationRif.class.getClassLoader(), new Class[]{FCoEConfigurationRif.class}, (InvocationHandler)this._fcoeHandler);
        }
        if (this._webProxy == null) {
            this._webProxy = (WebAnalysisRif)Proxy.newProxyInstance(WebAnalysisRif.class.getClassLoader(), new Class[]{WebAnalysisRif.class}, (InvocationHandler)this._webHandler);
        }
        if (this._pmProxy == null) {
            this._pmProxy = (PMRif)Proxy.newProxyInstance(PMRif.class.getClassLoader(), new Class[]{PMRif.class}, (InvocationHandler)this._pmHandler);
        }
        if (this._ioaProxy == null) {
            this._ioaProxy = (IOARif)Proxy.newProxyInstance(IOARif.class.getClassLoader(), new Class[]{IOARif.class}, (InvocationHandler)this._ioaHandler);
        }
        if (this._espProxy == null) {
            this._espProxy = (ESPRif)Proxy.newProxyInstance(ESPRif.class.getClassLoader(), new Class[]{ESPRif.class}, (InvocationHandler)this._espHandler);
        }
        if (this._analysisProxy == null) {
            this._analysisProxy = (AnalysisRif)Proxy.newProxyInstance(AnalysisRif.class.getClassLoader(), new Class[]{AnalysisRif.class}, (InvocationHandler)this._analysisHandler);
        }
    }

    private SessionRif attemptLogin() throws RemoteException, Exception {
        SessionRif sessionRif;
        if (SM._FmStandalone) {
            sessionRif = this._fmServerRif.standAloneLogin(this._username, this._password);
            this._sessionId = sessionRif.getLoginSessionId();
        } else {
            long fStart = System.currentTimeMillis();
            if (this._usePassphrase) {
                this._sessionId = this._fmServerRif.passphraseLogin(this._username, NetUtil.getLocalAddress().getHostAddress());
                if (_Logger.isInfoEnabled()) {
                    _Logger.info((Object)("time in ServerConnection.attemptLogin() method \"fmServerRif.passphraseLogin()\"- " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
                }
            } else {
                this._sessionId = this._fmServerRif.login(this._username, this._password, NetUtil.getLocalAddress().getHostAddress());
                if (_Logger.isInfoEnabled()) {
                    _Logger.info((Object)("time in ServerConnection.attemptLogin() method \"fmServerRif.login()\"- " + new StringBuffer().append(System.currentTimeMillis() - fStart).append(" ms")));
                }
            }
            sessionRif = this._rif.getSession();
        }
        System.setProperty("fm.sessionid", this._sessionId);
        return sessionRif;
    }

    public boolean isServerAlive() {
        return true;
    }

    public boolean isServerAlive(FMServerRif fmServerRif) {
        if (fmServerRif != null) {
            try {
                fmServerRif.whereami();
                return true;
            }
            catch (Exception ex) {
                _Logger.error((Object)("whereami " + fmServerRif), (Throwable)ex);
            }
        }
        return false;
    }

    public String whereami() throws Exception {
        if (this._fmServerRif != null) {
            return this._rif == null ? this._fmServerRif.whereami() : this._fmServerRif.whereami(Integer.valueOf(this._sessionId));
        }
        throw new Exception("Server is not connected.");
    }

    public boolean isSessionAlive() {
        if (this._sessionHandler != null) {
            return this._sessionHandler.setTargetObj() != null;
        }
        return false;
    }

    public SessionRif getSessionRif() {
        return this._sessionProxy;
    }

    public ModelFacadeRif getModelFacadeRif() {
        return this._modelFacadeProxy;
    }

    public InventoryServiceRif getInventoryServiceRif() {
        return this._inventoryProxy;
    }

    public DDMServerRif getDDMServerRif() {
        return this._ddmServerProxy;
    }

    public SecureEraseRif getSecureEraseRif() {
        return this._secureEraseProxy;
    }

    public PortSecurityRif getPortSecurityRif() {
        return this._psProxy;
    }

    public FCoEConfigurationRif getFCoEConfigurationRif() {
        return this._fcoeProxy;
    }

    public WebAnalysisRif getWebAnalysisRif() {
        return this._webProxy;
    }

    public PMRif getPMRif() {
        return this._pmProxy;
    }

    public IOARif getIOARif() {
        return this._ioaProxy;
    }

    public TopologyRemote getTopologyServer() {
        return this._topologyProxy;
    }

    public NPVRif getNPVRif() {
        return this._npvProxy;
    }

    public FlexAtahRif getFlexAtahRif() {
        return this._flexAtahProxy;
    }

    public ESPRif getESPRif() {
        return this._espProxy;
    }

    public AnalysisRif getAnalysisRif() {
        return this._analysisProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void targetObjectLost() {
        SyncedBoolean syncedBoolean = this._connecting;
        synchronized (syncedBoolean) {
            if (this._connecting.get()) {
                return;
            }
            this._connecting.set(true);
        }
        _Logger.error((Object)"Session Connection Lost. Login again.");
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ServerConnection.this._sessionProxy != null) {
                    try {
                        ServerConnection.this._sessionProxy.logoff();
                    }
                    catch (Exception ex) {
                    }
                    finally {
                        System.setProperty("fm.sessionid", "-1");
                    }
                }
                try {
                    ServerConnection.this.loginSession();
                    ServerConnection.this._connecting.set(false);
                }
                catch (Exception ex) {
                    _Logger.error((Object)("Reconnect to " + ServerConnection.this._fmServerRif + " failed"), (Throwable)ex);
                }
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionDown() {
        ServerConnection serverConnection = this;
        synchronized (serverConnection) {
            if (this._fmServerRif == null) {
                return;
            }
            this._sessionProxy = null;
            this._fmServerRif = null;
            this.closeConnection();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClientController.getInstance().serverDown();
                }
            });
        }
    }

    public void closeConnection() {
        _Logger.info((Object)"closeServerConnection");
        if (this._sessionProxy != null) {
            try {
                this._sessionProxy.logoff();
            }
            catch (Exception ex) {
                _Logger.error((Object)"logoff Session", (Throwable)ex);
            }
        }
        if (this._sessionHandler != null) {
            this._sessionHandler.setTargetObj(null);
            this._sessionHandler = null;
        }
        if (this._modelFacadeHandler != null) {
            this._modelFacadeHandler.setTargetObj(null);
            this._modelFacadeHandler = null;
        }
        if (this._inventoryHandler != null) {
            this._inventoryHandler.setTargetObj(null);
            this._inventoryHandler = null;
        }
        if (this._topologyHandler != null) {
            this._topologyHandler.setTargetObj(null);
            this._topologyHandler = null;
        }
        if (this._npvHandler != null) {
            this._npvHandler.setTargetObj(null);
            this._npvHandler = null;
        }
        if (this._flexAtahHandler != null) {
            this._flexAtahHandler.setTargetObj(null);
            this._flexAtahHandler = null;
        }
        if (this._psHandler != null) {
            this._psHandler.setTargetObj(null);
            this._psHandler = null;
        }
        if (this._fcoeHandler != null) {
            this._fcoeHandler.setTargetObj(null);
            this._fcoeHandler = null;
        }
        if (this._webHandler != null) {
            this._webHandler.setTargetObj(null);
            this._webHandler = null;
        }
        if (this._pmHandler != null) {
            this._pmHandler.setTargetObj(null);
            this._pmHandler = null;
        }
        if (this._ioaHandler != null) {
            this._ioaHandler.setTargetObj(null);
            this._ioaHandler = null;
        }
        if (this._espHandler != null) {
            this._espHandler.setTargetObj(null);
            this._espHandler = null;
        }
        if (this._analysisHandler != null) {
            this._analysisHandler.setTargetObj(null);
            this._analysisHandler = null;
        }
        this._fmServerRif = null;
        this._ddmServerHandler = null;
        this._sessionProxy = null;
        this._modelFacadeProxy = null;
        this._inventoryProxy = null;
        this._npvHandler = null;
        this._flexAtahHandler = null;
        this._flexAtahProxy = null;
        this._npvProxy = null;
        this._psHandler = null;
        this._fcoeHandler = null;
        this._psProxy = null;
        this._fcoeProxy = null;
        this._ddmServerProxy = null;
        this._webProxy = null;
        this._pmProxy = null;
        this._ioaProxy = null;
        this._topologyProxy = null;
        this._espProxy = null;
        this._analysisProxy = null;
    }

    public boolean getUseSSL() {
        return this._useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this._useSSL = useSSL;
    }

    @Override
    public void run() {
        try {
            if (this._fmServerRif != null && this._rif != null) {
                this._fmServerRif.whereami(this._rif.getSession().getDetails()._sessionId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Object getRemoteService(String ip, String facilityName) throws Exception {
        return this._rif.getRemoteService(ip, facilityName);
    }

    public Object getRemoteService(String ip, String facilityName, String interfaceName) throws Exception {
        return this._rif.getRemoteService(ip, facilityName, interfaceName);
    }
}

