/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.aaa;

import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.aaa.AAAModel;
import com.cisco.dcbu.sm.client.aaa.AAASearchMap;
import com.cisco.dcbu.sm.client.aaa.AAAServer;
import com.cisco.dcbu.sm.client.aaa.AAAServerGroup;
import com.cisco.dcbu.sm.client.model.Switch;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AAAManager {
    static final int TACACS_FEATURE_ID = 6;
    static final int LDAP_FEATURE_ID = 92;
    static final int TACACS_PORT = 49;
    static final int RADIUS_AUTHPORT = 1812;
    static final int LDAP_AUTHPORT = 389;
    static final int ACCT_PORT = 1813;
    static final int[] RADIUS_INDEX = new int[]{6, 114, 97, 100, 105, 117, 115};
    static final int[] TACACS_INDEX = new int[]{6, 116, 97, 99, 97, 99, 115};
    static final int PRIMARY_SERVER_INDEX = 64;
    static final int SECONDARY_SERVER_INDEX = 63;
    static final int[] SERVERGROUP_INDEX = new int[]{100, 99, 98};
    static final String[] SERVERGROUP_NAME = new String[]{"FM_TACACSServerGroup", "FM_RADIUSServerGroup", "FM_LDAPServerGroup"};
    static final String MAPNAME = "FM_LDAPSearchMap";
    private static AAAManager _instance;
    private AAAServer _primaryServer = null;
    private AAAServer _secondaryServer = null;
    private String[] _defaultPrimaryServerAddr = new String[4];
    private String[] _defaultSecondaryServerAddr = new String[4];
    private AAAServerGroup _group;
    private AAASearchMap _searchMap;
    private List<Switch> _switches;
    private PROTOCOL _protocol = PROTOCOL.TACACS;
    Map<SnmpPeer, FeatureState> _featureState = null;
    Map<SnmpPeer, CFSState> _cfsStates = null;
    private List<SnmpPeer> _TACACSfeatureDisabled = new HashedArrayList<SnmpPeer>();
    private List<SnmpPeer> _LDAPfeatureDisabled = new HashedArrayList<SnmpPeer>();
    static final int CFS_UNKNOWN = 1;
    static final int CFS_ENABLED = 2;
    static final int CFS_DISABLED = 3;
    static final int CFS_GLOBAL_ENABLED = 1;
    static final int CFS_GLOBAL_DISABLED = 2;
    private Map<SnmpPeer, AAAModel> aaaModel = null;

    private AAAManager() {
        this.initialize();
    }

    public static AAAManager getInstance() {
        if (_instance == null) {
            _instance = new AAAManager();
        }
        return _instance;
    }

    private void initialize() {
        this.aaaModel = new HashMap<SnmpPeer, AAAModel>();
        Switch[] swList = ClientController.getInstance().getSelectedDomain().getSwitches();
        SnmpPeer[] peers = AAAManager.getPeers(Arrays.asList(swList));
        Map<Object, Object> cfsMap = new HashMap();
        Map<Object, Object> featureMap = new HashMap();
        try {
            cfsMap = this.getFeatureCFSState(Arrays.asList(peers));
            featureMap = this.getFeatureControlState(Arrays.asList(peers));
        }
        catch (SnmpException e) {
            DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
            this.dispose();
        }
        for (Switch sw : swList) {
            SnmpPeer peer;
            if (!sw.isMDS() || !sw.isManageable() || (peer = sw.getPeer()) == null) continue;
            CFSState cfsState = (CFSState)cfsMap.get(peer);
            FeatureState featureState = (FeatureState)featureMap.get(peer);
            boolean tacacsConfig = this.serverExists(sw, PROTOCOL.TACACS, true) || this.serverExists(sw, PROTOCOL.TACACS, false) || this.serverGroupExists(sw, PROTOCOL.TACACS) == PROTOCOL.TACACS.ordinal();
            boolean radiusConfig = this.serverExists(sw, PROTOCOL.RADIUS, true) || this.serverExists(sw, PROTOCOL.RADIUS, false) || this.serverGroupExists(sw, PROTOCOL.RADIUS) == PROTOCOL.RADIUS.ordinal();
            boolean ldapConfig = this.serverExists(sw, PROTOCOL.LDAP, true) || this.serverExists(sw, PROTOCOL.LDAP, false) || this.serverGroupExists(sw, PROTOCOL.LDAP) == PROTOCOL.LDAP.ordinal();
            AAAModel model = new AAAModel(sw, cfsState, featureState, new ConfigState(tacacsConfig, radiusConfig, ldapConfig));
            this.aaaModel.put(sw.getPeer(), model);
        }
    }

    public int[] getIndex() {
        if (this._protocol == PROTOCOL.TACACS) {
            return TACACS_INDEX;
        }
        if (this._protocol == PROTOCOL.RADIUS) {
            return RADIUS_INDEX;
        }
        return new int[0];
    }

    AAAModel getAAAModel(SnmpPeer peer) {
        this.getAAAModel();
        return this.aaaModel.get(peer);
    }

    AAAServerGroup createDefaultServerGroup() {
        int p = this._protocol.ordinal();
        this._group = new AAAServerGroup(SERVERGROUP_INDEX[p - 1], SERVERGROUP_NAME[p - 1], p, new SnmpLongList("64"));
        return this._group;
    }

    Map<SnmpPeer, CFSState> getFeatureCFSState(List<SnmpPeer> peers) throws SnmpException {
        if (this._cfsStates == null) {
            SnmpPDU[] pdus;
            this._cfsStates = new HashMap<SnmpPeer, CFSState>();
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("cfsDistCtrl").getOid(), new int[]{0});
            vbl.add(MibNode.get("cfsFeatureOpStatus").getOid(), TACACS_INDEX);
            vbl.add(MibNode.get("cfsFeatureOpStatus").getOid(), RADIUS_INDEX);
            for (SnmpPDU pdu : pdus = new SnmpAggregrate().get(peers.toArray(new SnmpPeer[0]), vbl)) {
                if (pdu.getError() != 0) {
                    DefaultLogger._ExLogger.warn((Object)(pdu.getAddress().getHostName() + ": " + SnmpException.toError(pdu.getError())));
                    continue;
                }
                VarBindList response = pdu.getVariables();
                if (response == null) continue;
                CFSState cfs = new CFSState(response.intValue(0), response.intValue(1), response.intValue(2));
                this._cfsStates.put(pdu.getPeer(), cfs);
            }
        }
        return this._cfsStates;
    }

    Map<SnmpPeer, FeatureState> getFeatureControlState(List<SnmpPeer> peers) throws SnmpException {
        if (this._featureState == null) {
            SnmpPDU[] pdus;
            this._featureState = new HashMap<SnmpPeer, FeatureState>();
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("cfcFeatureCtrlOpStatus").getOid(), new int[]{6});
            vbl.add(MibNode.get("cfcFeatureCtrlOpStatus").getOid(), new int[]{92});
            for (SnmpPDU pdu : pdus = new SnmpAggregrate().get(peers.toArray(new SnmpPeer[0]), vbl)) {
                if (pdu.getError() != 0) {
                    DefaultLogger._ExLogger.warn((Object)(pdu.getAddress().getHostName() + ": " + SnmpException.toError(pdu.getError())));
                    continue;
                }
                VarBindList response = pdu.getVariables();
                if (response == null) continue;
                FeatureState feature = new FeatureState(response.intValue(0), response.intValue(1));
                if (response.intValue(0) != 2) {
                    this._TACACSfeatureDisabled.add(pdu.getPeer());
                }
                if (response.intValue(1) == 2) continue;
                this._LDAPfeatureDisabled.add(pdu.getPeer());
            }
        }
        return this._featureState;
    }

    public Map<SnmpPeer, SnmpException> enableFeatureControl(List<Switch> switches) throws SnmpException {
        final HashMap<SnmpPeer, SnmpException> errors = new HashMap<SnmpPeer, SnmpException>();
        if (this.isRADIUS()) {
            return errors;
        }
        HashedArrayList<SnmpPeer> peers = new HashedArrayList<SnmpPeer>();
        for (Switch sw : switches) {
            if ((!this.isTACACS() || !this._TACACSfeatureDisabled.contains(sw.getPeer())) && (!this.isLDAP() || !this._LDAPfeatureDisabled.contains(sw.getPeer()))) continue;
            peers.add(sw.getPeer());
        }
        if (peers.size() == 0) {
            return errors;
        }
        VarBindList vbl = new VarBindList();
        int[] nArray = new int[1];
        nArray[0] = this.isTACACS() ? 6 : 92;
        vbl.add(MibNode.get("cfcFeatureCtrlAction").getOid(), nArray, (SnmpVar)new SnmpInt(2));
        int success = new SnmpAggregrate().set(peers.toArray(new SnmpPeer[0]), vbl, (Object)vbl, new SnmpAggregrateIf(){

            @Override
            public void snmpAggregrate(SnmpPDU pdu, String err) {
                if (err != null && err.length() != 0) {
                    errors.put(pdu.getPeer(), new SnmpException(pdu.getAddress().getHostName() + ": " + SnmpException.toError(pdu.getError())));
                }
            }
        }, false);
        return errors;
    }

    static SnmpPeer[] getPeers(List<Switch> switches) {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        SnmpPeer peer = null;
        for (Switch s : switches) {
            if (!s.isMDS() || !s.isManageable() || (peer = s.getSnmpPeer()) == null) continue;
            peers.add(s.getSnmpPeer());
        }
        return peers.toArray(new SnmpPeer[0]);
    }

    Map<SnmpPeer, SnmpException> createAAAserver(List<SnmpPeer> peers, AAAServer server) throws SnmpException {
        final HashMap<SnmpPeer, SnmpException> errors = new HashMap<SnmpPeer, SnmpException>();
        VarBindList vbl = new VarBindList();
        int[] index = new int[]{this.getProtocol().ordinal(), server.index};
        vbl.add(MibNode.get("casConfigRowStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
        vbl.add(MibNode.get("cAAAServerAddrType").getOid(), index, server.addrType);
        vbl.add(MibNode.get("cAAAServerAddr").getOid(), index, server.address);
        if (AAAManager.getInstance().isLDAP()) {
            vbl.add(MibNode.get("cAAAServerRootDNPasswordEncrType").getOid(), index, server.keyType);
        } else {
            vbl.add(MibNode.get("cAAAServerKeyEncrType").getOid(), index, server.keyType);
            vbl.add(MibNode.get("casKey").getOid(), index, (SnmpVar)new SnmpString(new String(server.key)));
        }
        vbl.add(MibNode.get("casAuthenPort").getOid(), index, (SnmpVar)new SnmpInt(this.getAuthPort()));
        vbl.add(MibNode.get("casAcctPort").getOid(), index, (SnmpVar)new SnmpInt(this.getAcctPort()));
        if (this.isLDAP()) {
            vbl.add(MibNode.get("cAAAServerRootDN").getOid(), index, server.rootDN);
            vbl.add(MibNode.get("cAAAServerRootDNPassword").getOid(), index, (SnmpVar)new SnmpString(new String(server.rootDNPassword)));
        }
        int success = new SnmpAggregrate().set(peers.toArray(new SnmpPeer[0]), vbl, (Object)vbl, new SnmpAggregrateIf(){

            @Override
            public void snmpAggregrate(SnmpPDU pdu, String err) {
                if (err != null && err.length() != 0) {
                    errors.put(pdu.getPeer(), new SnmpException(err));
                }
            }
        }, false);
        return errors;
    }

    Map<SnmpPeer, SnmpException> createAAAserverGroup(List<SnmpPeer> peers, AAAServerGroup group) throws SnmpException {
        final HashMap<SnmpPeer, SnmpException> errors = new HashMap<SnmpPeer, SnmpException>();
        VarBindList vbl = new VarBindList();
        int[] index = new int[]{group.index};
        vbl.add(MibNode.get("cAAASvrGrpConfigRowStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
        vbl.add(MibNode.get("cAAASvrGrpProtocol").getOid(), index, (SnmpVar)new SnmpInt(this.getProtocol().ordinal()));
        vbl.add(MibNode.get("cAAASvrGrpName").getOid(), index, (SnmpVar)new SnmpString(group.name));
        if (this.isLDAP()) {
            vbl.add(MibNode.get("cAAASvrGrpLDAPSearchMapName").getOid(), index, (SnmpVar)new SnmpString(MAPNAME));
            vbl.add(MibNode.get("cAAASvrGrpLDAPAuthMechanism").getOid(), index, (SnmpVar)new SnmpInt(1));
        }
        String serverIdList = this._primaryServer.index + (this._secondaryServer == null ? "" : ", " + this._secondaryServer.index);
        vbl.add(MibNode.get("cAAAServerList").getOid(), index, (SnmpVar)new SnmpLongList(serverIdList));
        int success = new SnmpAggregrate().set(peers.toArray(new SnmpPeer[0]), vbl, (Object)vbl, new SnmpAggregrateIf(){

            @Override
            public void snmpAggregrate(SnmpPDU pdu, String err) {
                if (err != null && err.length() != 0) {
                    errors.put(pdu.getPeer(), new SnmpException(err));
                }
            }
        }, false);
        return errors;
    }

    Map<SnmpPeer, SnmpException> createAAASearchMap(List<SnmpPeer> peers, AAASearchMap searchMap) throws SnmpException {
        SnmpPDU[] getSearchMap;
        final HashMap<SnmpPeer, SnmpException> errors = new HashMap<SnmpPeer, SnmpException>();
        ArrayList<SnmpPeer> mapDoesNotExistPeers = new ArrayList<SnmpPeer>();
        ArrayList<SnmpPeer> mapExistsPeers = new ArrayList<SnmpPeer>();
        VarBindList getVbl = new VarBindList();
        int type = searchMap.type;
        int[] index = new int[]{16, 70, 77, 95, 76, 68, 65, 80, 83, 101, 97, 114, 99, 104, 77, 97, 112, type};
        getVbl.add(MibNode.get("cAAASvrExtLDAPSearchMapBaseDN").getOid(), index, searchMap.baseDN);
        for (SnmpPDU resultPDU : getSearchMap = new SnmpAggregrate().get(peers.toArray(new SnmpPeer[0]), getVbl)) {
            if (resultPDU.getVar(0).isNullType()) {
                mapDoesNotExistPeers.add(resultPDU.getPeer());
                continue;
            }
            mapExistsPeers.add(resultPDU.getPeer());
        }
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cAAASvrExtLDAPSearchMapBaseDN").getOid(), index, searchMap.baseDN);
        vbl.add(MibNode.get("cAAASvrExtLDAPSearchMapFilter").getOid(), index, searchMap.filter);
        vbl.add(MibNode.get("cAAASvrExtLDAPSearchMapAttribute").getOid(), index, searchMap.attribute);
        if (mapExistsPeers.size() > 0) {
            int setSuccess = new SnmpAggregrate().set(mapExistsPeers.toArray(new SnmpPeer[0]), vbl, (Object)vbl, new SnmpAggregrateIf(){

                @Override
                public void snmpAggregrate(SnmpPDU pdu, String err) {
                    if (err != null && err.length() != 0) {
                        errors.put(pdu.getPeer(), new SnmpException(err));
                    }
                }
            }, false);
        }
        if (mapDoesNotExistPeers.size() > 0) {
            vbl.add(MibNode.get("cAAASvrExtLDAPSearchMapRowStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
            int createSuccess = new SnmpAggregrate().set(mapDoesNotExistPeers.toArray(new SnmpPeer[0]), vbl, (Object)vbl, new SnmpAggregrateIf(){

                @Override
                public void snmpAggregrate(SnmpPDU pdu, String err) {
                    if (err != null && err.length() != 0) {
                        errors.put(pdu.getPeer(), new SnmpException(err));
                    }
                }
            }, false);
        }
        return errors;
    }

    Map<SnmpPeer, SnmpException> modifyApplications(List<SnmpPeer> peers) throws SnmpException {
        final HashMap<SnmpPeer, SnmpException> errors = new HashMap<SnmpPeer, SnmpException>();
        int[] d_a_a = new int[]{1, 1, 3};
        int[] l_a_a = new int[]{2, 1, 1};
        ArrayList<SnmpPDU> reqPDUs = new ArrayList<SnmpPDU>();
        for (SnmpPeer peer : peers) {
            VarBindList v = new VarBindList();
            v.add(MibNode.get("cAAASvrGrpList").getOid(), d_a_a);
            v.add(MibNode.get("cAAASvrGrpList").getOid(), l_a_a);
            SnmpPDU getPDU = SnmpFetch.get(peer, v);
            VarBindList getVbl = getPDU.getVariables();
            SnmpString srvString1 = (SnmpString)getVbl.get(0).getVar();
            SnmpLongList srvList1 = new SnmpLongList(srvString1.getValue());
            SnmpString srvString2 = (SnmpString)getVbl.get(1).getVar();
            SnmpLongList srvList2 = new SnmpLongList(srvString2.getValue());
            SnmpLongList list1 = SnmpLongList.add(srvList1, this._group.index, false);
            SnmpLongList list2 = SnmpLongList.add(srvList2, this._group.index, false);
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("cAAASvrGrpList").getOid(), d_a_a, (SnmpVar)list1);
            vbl.add(MibNode.get("cAAASvrGrpList").getOid(), l_a_a, (SnmpVar)list2);
            reqPDUs.add(new SnmpPDU(-93, vbl));
        }
        int success = new SnmpAggregrate().set(peers.iterator(), reqPDUs.iterator(), reqPDUs, new SnmpAggregrateIf(){

            @Override
            public void snmpAggregrate(SnmpPDU pdu, String err) {
                if (err != null && err.length() != 0) {
                    errors.put(pdu.getPeer(), new SnmpException(err));
                }
            }
        }, false);
        return errors;
    }

    boolean serverExists(Switch sw, PROTOCOL protocol, boolean primary) {
        try {
            int[] index = new int[]{protocol.ordinal(), primary ? 64 : 63};
            VarBindList v = new VarBindList();
            v.add(MibNode.get("cAAAServerAddr").getOid(), index);
            SnmpPDU respPDU = SnmpFetch.get(sw.getPeer(), v);
            if (respPDU.getError() != 0) {
                return false;
            }
            if (respPDU.getVar(0) == null || respPDU.getVar(0) instanceof SnmpNull) {
                return false;
            }
            String defaultAddress = "";
            if (primary) {
                SnmpVar address = respPDU.getVar(0);
                if (address != null && !address.isNullType()) {
                    defaultAddress = SnmpIpAddress.toString(((SnmpString)address).getValue());
                }
                this._defaultPrimaryServerAddr[protocol.ordinal()] = defaultAddress;
            } else {
                SnmpVar address = respPDU.getVar(0);
                if (address != null && !address.isNullType()) {
                    defaultAddress = SnmpIpAddress.toString(((SnmpString)address).getValue());
                }
                this._defaultSecondaryServerAddr[protocol.ordinal()] = defaultAddress;
            }
            return true;
        }
        catch (SnmpException e) {
            DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    int serverGroupExists(Switch sw, PROTOCOL protocol) {
        try {
            int[] index = new int[]{SERVERGROUP_INDEX[protocol.ordinal() - 1]};
            VarBindList v = new VarBindList();
            v.add(MibNode.get("cAAASvrGrpProtocol").getOid(), index);
            SnmpPDU respPDU = SnmpFetch.get(sw.getPeer(), v);
            if (respPDU.getError() != 0) {
                return -1;
            }
            if (respPDU.getVar(0) == null || respPDU.getVar(0).isNullType()) {
                return -1;
            }
            return respPDU.getVariables().intValue(0);
        }
        catch (SnmpException e) {
            DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    Collection<AAAModel> getAAAModel() {
        if (this.aaaModel == null) {
            this.initialize();
        }
        return this.aaaModel.values();
    }

    void resetModel() {
        this.aaaModel = null;
        this._defaultPrimaryServerAddr = new String[4];
        this._defaultSecondaryServerAddr = new String[4];
    }

    public boolean isTACACS() {
        return this._protocol == PROTOCOL.TACACS;
    }

    public boolean isRADIUS() {
        return this._protocol == PROTOCOL.RADIUS;
    }

    public boolean isLDAP() {
        return this._protocol == PROTOCOL.LDAP;
    }

    public int getAuthPort() {
        if (this._protocol == PROTOCOL.TACACS) {
            return 49;
        }
        if (this._protocol == PROTOCOL.RADIUS) {
            return 1812;
        }
        if (this._protocol == PROTOCOL.LDAP) {
            return 389;
        }
        return 0;
    }

    public int getAcctPort() {
        if (this._protocol == PROTOCOL.TACACS) {
            return 49;
        }
        if (this._protocol == PROTOCOL.RADIUS || this._protocol == PROTOCOL.LDAP) {
            return 1813;
        }
        return 0;
    }

    String deleteServer(SnmpPeer peer, PROTOCOL protocol, boolean primary) {
        String error = "";
        try {
            int[] index = new int[]{protocol.ordinal(), primary ? 64 : 63};
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("casConfigRowStatus").getOid(), index, (SnmpVar)new SnmpInt(6));
            SnmpPDU respPDU = SnmpFetch.set(peer, vbl);
            if (respPDU.getError() != 0) {
                error = SnmpException.toError(respPDU.getError());
            }
        }
        catch (SnmpException e) {
            error = peer + e.getMessage();
        }
        return error;
    }

    String deleteServerGroup(SnmpPeer peer, PROTOCOL protocol) {
        String error = "";
        try {
            int[] index = new int[]{SERVERGROUP_INDEX[protocol.ordinal() - 1]};
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("cAAASvrGrpConfigRowStatus").getOid(), index, (SnmpVar)new SnmpInt(6));
            SnmpPDU respPDU = SnmpFetch.set(peer, vbl);
            if (respPDU.getError() != 0) {
                error = SnmpException.toError(respPDU.getError());
            }
        }
        catch (SnmpException e) {
            error = peer + " " + e.getMessage();
        }
        return error;
    }

    static String verifyAddress(String ipAddress, String key, String username, String password) throws Exception {
        String result = ClientController.getInstance().getServerSession().verifyAddress(ipAddress, key, username, password, AAAManager.getInstance().getAuthPort(), AAAManager.getInstance().getAcctPort(), AAAManager.getInstance().isTACACS());
        return result;
    }

    static String verifyAddress(String ipAddress) throws UnknownHostException, IOException {
        String result = "Verification successful.";
        try (Socket testSocket = null;){
            testSocket = new Socket(ipAddress, AAAManager.getInstance().getAuthPort());
        }
        return result;
    }

    public AAAServer getPrimaryServer() {
        return this._primaryServer;
    }

    public void setPrimaryServer(AAAServer server) {
        this._primaryServer = server;
    }

    public AAAServer getSecondaryServer() {
        return this._secondaryServer;
    }

    public AAASearchMap getSearchMap() {
        return this._searchMap;
    }

    public void setSecondaryServer(AAAServer server) {
        this._secondaryServer = server;
    }

    public void setSearchMap(AAASearchMap searchMap) {
        this._searchMap = searchMap;
    }

    public List<Switch> getSwitches() {
        return this._switches;
    }

    public void setSwitches(List<Switch> _switches) {
        this._switches = _switches;
    }

    public PROTOCOL getProtocol() {
        return this._protocol;
    }

    public void setProtocol(PROTOCOL protocol) {
        this._protocol = protocol;
    }

    public void dispose() {
        _instance = null;
        this._switches = null;
        this._primaryServer = null;
        this._secondaryServer = null;
        this._group = null;
        this._featureState = null;
        this._cfsStates = null;
        this._TACACSfeatureDisabled = null;
        this._LDAPfeatureDisabled = null;
    }

    public String getDefaultPrimaryServerAddr() {
        return this._defaultPrimaryServerAddr[this.getProtocol().ordinal()];
    }

    public String getDefaultSecondaryServerAddr() {
        return this._defaultSecondaryServerAddr[this.getProtocol().ordinal()];
    }

    class FeatureState {
        int tacacs;
        int ldap;

        FeatureState(int tacacsFeature, int ldapFeature) {
            this.tacacs = tacacsFeature;
            this.ldap = ldapFeature;
        }

        public String toString() {
            String status = (this.tacacs == 2 ? "TACACS " : "") + (this.ldap == 2 ? "LDAP" : "");
            return status;
        }
    }

    class ConfigState {
        boolean tacacs;
        boolean radius;
        boolean ldap;

        ConfigState(boolean tacacsConfig, boolean radiusConfig, boolean ldapConfig) {
            this.tacacs = tacacsConfig;
            this.radius = radiusConfig;
            this.ldap = ldapConfig;
        }

        public String toString() {
            String status = (this.tacacs ? "TACACS " : "") + (this.radius ? "RADIUS " : "") + (this.ldap ? "LDAP" : "");
            return status;
        }
    }

    class CFSState {
        int global;
        int tacacs;
        int radius;

        CFSState(int globalCFS, int tacacsCFS, int radiusCFS) {
            this.global = globalCFS;
            this.tacacs = tacacsCFS;
            this.radius = radiusCFS;
        }

        public String toString() {
            String cfsStatus = "Global disabled";
            if (this.global == 1) {
                cfsStatus = (this.tacacs == 2 ? "TACACS " : "") + (this.radius == 2 ? "RADIUS " : "");
            }
            return cfsStatus;
        }
    }

    public static enum PROTOCOL {
        UNKNOWN,
        TACACS,
        RADIUS,
        LDAP;

    }
}

