/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.aaa;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.aaa.AAAConfigPanel;
import com.cisco.dcbu.sm.client.aaa.AAAManager;
import com.cisco.dcbu.sm.client.aaa.AAAStatusPanel;
import com.cisco.dcbu.sm.client.aaa.AAASwitchPanel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class AAAWizard
extends JWizard {
    public static final ImageIcon AAA_ICON = Util.loadIcon("icons/aaa.png");
    static final String SWITCH_PANEL = "SwitchPanel";
    static final String CONFIG_PANEL = "ConfigPanel";
    static final String STATUS_PANEL = "StatusPanel";

    public AAAWizard(JFrame parent) throws SnmpException {
        super(parent);
        AAAManager.getInstance();
        this.setTitle("AAA Wizard" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setSize(560, 500);
        this.addPanel(SWITCH_PANEL, new AAASwitchPanel());
        this.addPanel(CONFIG_PANEL, new AAAConfigPanel());
        this.addPanel(STATUS_PANEL, new AAAStatusPanel());
        this.first();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void updateNavBtn() {
        Object[] o = (Object[])this._cards.elementAt(this._currentCardIndex);
        if (o == null || o[0] == null) {
            return;
        }
        if (o[0].equals(SWITCH_PANEL)) {
            this._nav.setButtonAttr(false, false);
            this._nav.setNextButton("Next");
        } else if (o[0].equals(CONFIG_PANEL)) {
            this._nav.setButtonAttr(true, false);
            this._nav.setNextButton("Finish");
        } else if (o[0].equals(STATUS_PANEL)) {
            this._nav.setButtonAttr(true, true);
            this._nav.getCancel().setText("Close");
            this._nav.getNextBtn().setVisible(false);
            this._nav.getBackBtn().setVisible(false);
        } else {
            this._nav.setButtonAttr(false, this._currentCardIndex == this._cards.size() - 1);
        }
    }

    @Override
    public void dispose() {
        if (this.getCurrent() != null) {
            this.getCurrent().dispose();
            AAAManager.getInstance().dispose();
        }
        super.dispose();
    }
}

