/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cat;

import com.cisco.dcbu.sm.client.cat.UniquePartition;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;

public final class Search {
    static final Comparator SORT_COMP = new Comparator(){

        public int compare(Object o1, Object o2) {
            ArrayList c1 = (ArrayList)o1;
            ArrayList c2 = (ArrayList)o2;
            return c1.size() - c2.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }
    };

    public static ArrayList search(Switch src, Switch dest, Isl[] links) {
        HashMap nbrMap = Search.buildNbrMap(links);
        return Search.search(src, dest, nbrMap);
    }

    public static HashMap buildNbrMap(Isl[] links) {
        HashMap nbrMap = new HashMap();
        for (int i = 0; i < links.length; ++i) {
            Isl link = links[i];
            Switch src = link.getSwitch1();
            Switch dest = link.getSwitch2();
            if (!nbrMap.containsKey(src)) {
                nbrMap.put(src, new ArrayList());
            }
            if (!nbrMap.containsKey(dest)) {
                nbrMap.put(dest, new ArrayList());
            }
            ArrayList nbrs = (ArrayList)nbrMap.get(src);
            nbrs.add(link);
            nbrs = (ArrayList)nbrMap.get(dest);
            nbrs.add(link);
        }
        return nbrMap;
    }

    public static HashMap buildNpvNbrMap(HashMap nbrMap, NpvLink[] links) {
        if (links != null) {
            for (int i = 0; i < links.length; ++i) {
                NpvLink link = links[i];
                Switch src = link.getCoreSwitch();
                Switch dest = link.getEdgeSwitch();
                if (!nbrMap.containsKey(src)) {
                    nbrMap.put(src, new ArrayList());
                }
                if (!nbrMap.containsKey(dest)) {
                    nbrMap.put(dest, new ArrayList());
                }
                ArrayList nbrs = (ArrayList)nbrMap.get(src);
                nbrs.add(link);
                nbrs = (ArrayList)nbrMap.get(dest);
                nbrs.add(link);
            }
        }
        return nbrMap;
    }

    public static ArrayList search(Switch src, Switch dest, HashMap nbrMap) {
        return Search.search(src, dest, nbrMap, new HashSet());
    }

    private static ArrayList search(Switch src, Switch dest, HashMap nbrMap, HashSet visited) {
        visited.add(src);
        ArrayList<ArrayList> paths = new ArrayList<ArrayList>();
        if (nbrMap.containsKey(src)) {
            ArrayList nbrs = (ArrayList)nbrMap.get(src);
            for (int i = 0; i < nbrs.size(); ++i) {
                Switch next;
                Object linkOb = nbrs.get(i);
                boolean isNpv = linkOb instanceof NpvLink;
                Switch switch_ = next = isNpv ? ((NpvLink)linkOb).getEdgeSwitch() : ((Isl)linkOb).getSwitch2();
                if (next.equals(src)) {
                    Switch switch_2 = next = isNpv ? ((NpvLink)linkOb).getCoreSwitch() : ((Isl)linkOb).getSwitch1();
                }
                if (visited.contains(next)) continue;
                if (next.equals(dest)) {
                    ArrayList path = new ArrayList();
                    path.add(linkOb);
                    paths.add(path);
                    continue;
                }
                ArrayList subPaths = Search.search(next, dest, nbrMap, visited);
                for (int j = 0; j < subPaths.size(); ++j) {
                    ArrayList subPath = (ArrayList)subPaths.get(j);
                    subPath.add(linkOb);
                    paths.add(subPath);
                }
            }
        }
        visited.remove(src);
        return paths;
    }

    public static ArrayList searchUniquePaths(Switch src, Switch dest, Isl[] links) {
        ArrayList allPaths = Search.search(src, dest, links);
        ArrayList<UniquePartition> uPaths = new ArrayList<UniquePartition>();
        for (int i = 0; i < allPaths.size(); ++i) {
            ArrayList aPath = (ArrayList)allPaths.get(i);
            if (Search.overlaps(aPath, uPaths) != null) continue;
            uPaths.add(new UniquePartition(src, dest, aPath));
        }
        return uPaths;
    }

    public static ArrayList searchUniquePaths(Switch src, Switch dest, HashMap nbrMap) {
        ArrayList allPaths = Search.search(src, dest, nbrMap);
        ArrayList<UniquePartition> uPaths = new ArrayList<UniquePartition>();
        for (int i = 0; i < allPaths.size(); ++i) {
            ArrayList aPath = (ArrayList)allPaths.get(i);
            if (Search.overlaps(aPath, uPaths) != null) continue;
            uPaths.add(new UniquePartition(src, dest, aPath));
        }
        return uPaths;
    }

    private static ArrayList overlaps(ArrayList aPath, ArrayList uPaths) {
        for (int i = 0; i < uPaths.size(); ++i) {
            UniquePartition up = (UniquePartition)uPaths.get(i);
            if (!up.addIfOverlaps(aPath)) continue;
            return up;
        }
        return null;
    }

    public static ArrayList[] sortPaths(ArrayList c) {
        ArrayList[] cs = new ArrayList[c.size()];
        if (cs.length > 0) {
            cs = c.toArray(cs);
            Arrays.sort(cs, SORT_COMP);
        }
        return cs;
    }
}

