/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cfs.ps;

import com.cisco.dcbu.lib.mds.zm.ActionEnabler;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.cfs.CfsConfigWizard;
import com.cisco.dcbu.sm.client.cfs.ps.ConfigPolicyPanel;
import com.cisco.dcbu.sm.client.cfs.ps.PSMasterSwitchPanel;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.Timer;

public class PortSecurityWizard
extends CfsConfigWizard
implements StatusIf {
    static final int POLL_INTERVAL = 3000;
    public static final String AUTOLEARN_STATE = "AUTOLEARN_STATE";
    int elapsedSecs;
    boolean isStopped;
    Timer statusTimer;
    public static final String AUTO_LEARNT = "AUTO_LEARNT";
    public static final ImageIcon PSM_ICON = Util.loadIcon("icons/portsecurity.gif");
    static final MibEnum[] PSM_ACTIVATE_RESULT_ENUM = MibNode.get("cpsmPortBindResult").getEnums();
    private Vsan _vsan;

    public PortSecurityWizard(JFrame parent, Vsan vsan) throws SnmpException {
        super(parent, "Port Security Setup Wizard (" + vsan + ")", PSM_ICON, vsan);
        this.setSize(560, 520);
        this._vsan = vsan;
        this.getNavigator().setCancelButton("Close");
    }

    Vsan getVsan() {
        return this._vsan;
    }

    public void startTimer(ActionListener actLstnr) {
        this.statusTimer = new Timer(3000, actLstnr);
        this.elapsedSecs = 0;
        this.statusTimer.start();
    }

    @Override
    protected void addPanels() throws SnmpException {
        this.addPanel("select master switch", new PSMasterSwitchPanel(this));
        this.addPanel("configure port security policy", new ConfigPolicyPanel(this));
    }

    @Override
    public void handleError(Exception[] ex) {
        this.setCursor(false);
        this.getCurrent().actionFinished(false);
        Util.errorMessage((Component)this, ActionEnabler.buildErrorMessage(ex).toString());
    }

    @Override
    public void actionFinished() {
        this.getCurrent().actionFinished(true);
        this.setCursor(false);
    }

    @Override
    public void dispose() {
        WizardPanel pnl = this.getCurrent();
        if (pnl != null) {
            pnl.dispose();
            if (this.getPanelCount() == 2) {
                ((PSMasterSwitchPanel)this.getPanelComponentAt(1)[1]).clearServerSideObjects();
                ((ConfigPolicyPanel)this.getPanelComponentAt(2)[1]).clearServerSideObjects();
            }
        }
        super.dispose();
    }

    void setCursor(boolean busy) {
        this.setCursor(Cursor.getPredefinedCursor(busy ? 3 : 0));
    }

    public Timer getStatusTimer() {
        return this.statusTimer;
    }

    public void setStatusTimer(Timer statusTimer) {
        this.statusTimer = statusTimer;
    }

    public synchronized void stopTimer() {
        if (this.statusTimer != null) {
            this.statusTimer.stop();
            this.statusTimer = null;
        }
    }
}

