/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.CliCommandHandler;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigConfigThread;
import com.cisco.dcbu.sm.client.datamig.DataMigWizard;
import com.cisco.dcbu.sm.common.rif.DDMCreationRif;
import java.awt.Cursor;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DataMigConfigPanel
extends WizardPanel {
    volatile DataMigConfigThread _cfgThread;
    boolean _finish = false;

    public DataMigConfigPanel(String name, String description, JWizard wizard, ImageIcon image) {
        super(name, description, wizard, image);
    }

    @Override
    public void doCancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        if (((DataMigWizard)this.getWizard()).isCreateJobPduSend() && !this._finish) {
            int opt = JOptionPane.showConfirmDialog(this, "Job will be deleted. Do you wish to continue?", this.getTitle(), 2);
            if (opt == 0) {
                ConfigCancelJobThread thread = new ConfigCancelJobThread(this.getWizard());
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException ex) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                this.cleanupSml();
                super.dispose();
            }
        } else {
            this.cleanupSml();
            super.dispose();
        }
    }

    void cleanupSml() {
        CliCommandHandler smlCmd2;
        CliCommandHandler smlCmd1 = (CliCommandHandler)this.getModelValue("fabrics1ZoneSml");
        if (smlCmd1 != null) {
            smlCmd1.closeVsh();
            smlCmd1.cleanup();
            this.setModelValue("fabrics1ZoneSml", null);
        }
        if ((smlCmd2 = (CliCommandHandler)this.getModelValue("fabrics2ZoneSml")) != null) {
            smlCmd2.closeVsh();
            smlCmd2.cleanup();
            this.setModelValue("fabrics2ZoneSml", null);
        }
    }

    protected void goNext() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataMigConfigPanel.this.continueToNext();
            }
        });
    }

    @Override
    public void doPrevious() {
        this.getWizard().removeAllPanelAfterCurrent();
        this.getWizard().getCurrent().setDataValid(false);
        super.doPrevious();
    }

    private void continueToNext() {
        super.doNext();
    }

    class ConfigCancelJobThread
    extends DataMigConfigThread {
        public ConfigCancelJobThread(JWizard wizard) {
            super(wizard);
        }

        @Override
        public void run() {
            if (DataMigConfigPanel.this._cfgThread != null) {
                DataMigConfigPanel.this._cfgThread = null;
            }
            DDMCreationRif dmCreateRif = (DDMCreationRif)DataMigConfigPanel.this.getModelValue("CreateRif");
            this._wizard.setCursor(Cursor.getPredefinedCursor(3));
            if (((DataMigWizard)DataMigConfigPanel.this.getWizard()).isCreateJobPduSend()) {
                block6: {
                    try {
                        this.setupConfigStatus(true, false, null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DataMigConfigPanel.this.getWizard().setStatus("Deleting the Job...");
                            }
                        });
                        if (dmCreateRif != null) {
                            dmCreateRif.cutOff();
                        }
                        this.setupConfigStatus(false, false, null);
                        if (this._wizard != null && this._wizard.getNavigator() != null) {
                            this._wizard.getNavigator().getCancel().setEnabled(false);
                        }
                    }
                    catch (Exception ex) {
                        this.setupConfigStatus(false, false, ex);
                        this._wizard.setCursor(Cursor.getPredefinedCursor(3));
                        if (this._wizard == null) break block6;
                        Runnable retryThread = new Runnable(){

                            @Override
                            public void run() {
                                int opt = JOptionPane.showConfirmDialog(ConfigCancelJobThread.this._wizard, "Job could not be deleted. Do you wish to retry?", DataMigConfigPanel.this.getTitle(), 0);
                                if (opt != 0) {
                                    DDMCreationRif dmCreateRif = (DDMCreationRif)DataMigConfigPanel.this.getModelValue("CreateRif");
                                    if (dmCreateRif != null) {
                                        try {
                                            dmCreateRif.destroy();
                                        }
                                        catch (RemoteException e) {
                                            DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
                                        }
                                    }
                                    ConfigCancelJobThread.this._wizard.setCursor(Cursor.getPredefinedCursor(0));
                                    return;
                                }
                                ConfigCancelJobThread thread = new ConfigCancelJobThread(DataMigConfigPanel.this.getWizard());
                                thread.start();
                                try {
                                    thread.join();
                                }
                                catch (InterruptedException ex) {
                                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                                }
                            }
                        };
                        SwingUtilities.invokeLater(retryThread);
                    }
                }
                this._wizard.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

