/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.datamig.DataMigJobPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigMisMatchNumLunPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigNonAslLunMap;
import com.cisco.dcbu.sm.client.datamig.DataMigSessionPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigSwitchPanel;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.ddm.DDMLunITL;
import com.cisco.dcbu.sm.common.model.ddm.DDMSwitch;
import com.cisco.dcbu.sm.common.rif.DDMCreationRif;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class DataMigWizard
extends JWizard {
    DDMServerRif _ddmServerRif = ClientController.getInstance().getDDMServerRif();
    int _step = 1;
    public static final int NON_ASL_STEP_START_SERVER = 2;
    public static final int NON_ASL_STEP_START_STORAGE = 4;
    public static final String PANEL_NAME_JOB = "job";
    public static final String PANEL_NAME_SSM = "ssm";
    public static final String PANEL_NAME_DPPVI = "dppvi";
    public static final String PANEL_NAME_SERVERPORT = "serverPorts";
    public static final String PANEL_NAME_PATH = "path";
    public static final String PANEL_NAME_ZONE = "zone";
    public static final String PANEL_NAME_SESSION = "session";
    public static final String PANEL_NAME_NONASL_ES = "nonasl-ES";
    public static final String PANEL_NAME_NONASL_NS = "nonasl-NS";
    public static final String PANEL_NAME_DATAMOVERSSM = "dataMoverSSM";
    public static final String SERVER_RIF = "ServerRif";
    public static final String CREATE_RIF = "CreateRif";
    public static final String DM_TYPE = "dmType";
    public static final String JOB_DATA = "jobData";
    public static final String JOB_NAME = "jobName";
    public static final String SERVER = "server";
    public static final String SERVER_PORTS = "serverPorts";
    public static final String OLD_STORAGE = "oldStorage";
    public static final String OLD_STORAGE_PORTS = "oldStoragePorts";
    public static final String NEW_STORAGE = "newStorage";
    public static final String NEW_STORAGE_PORTS = "newStoragePorts";
    public static final String JOB_TYPE = "type";
    public static final String RATE = "rate";
    public static final String SW_1 = "sw1";
    public static final String SW_2 = "sw2";
    public static final String SOURCE_LUNS = "sourceLun";
    public static final String DEST_LUNS = "destLun";
    public static final String SOURCE_LUN_MISMATCH = "sourceLunMisMatch";
    public static final String DEST_LUN_MISMATCH = "destLunMisMatch";
    public static final String SOURCE_PATH_PRI = "sourcePathPri";
    public static final String DEST_PATH_PRI = "destPathPri";
    public static final String SOURCE_PATH_SEC = "sourcePathSec";
    public static final String DEST_PATH_SEC = "destPathSec";
    public static final String DUAL_FABRIC = "dualFabric";
    public static final String JOB_DATE = "jobDate";
    public static final String JOB_SCH_ACTION = "jobScheduleAction";
    public static final String SOURCE_ASL = "sourceAsl";
    public static final String DESTINATION_ASL = "destAsl";
    public static final String ZONE_CREATE_STATE = "zoneCreateState";
    public static final String FABRICS_CONNECTED = "fabricsConnected";
    public static final String MIGRATION_FABRIC = "migrationFabric";
    public static final String PRODUCTION_FABRIC = "productionFabric";
    public static final String FABRIC_1_DMM_SWS = "fabrics1DMMSwitch";
    public static final String FABRIC_2_DMM_SWS = "fabrics2DMMSwitch";
    public static final String DATA_MOVER_SWS = "DataMoverSwitch";
    public static final String DISPLAY_MANUAL_MULTI_PATH = "displayManualMultiPath";
    public static final String SINGLE_FABRIC_MULTI_VSAN = "singleFabricMultiVsan";
    public static final String SINGLE_FABRIC_MULTI_VSAN_HOST_STORAGE_VSAN = "singleFabricMultiVsanHostStorageVsans";
    public static final String SINGLE_FAB_MULTI_VSAN_TABLE1_SELECTIONLIST = "singleFabricMultiVsanTable1RowSelectionList";
    public static final String FABRIC_1_ZONE_SML = "fabrics1ZoneSml";
    public static final String FABRIC_2_ZONE_SML = "fabrics2ZoneSml";
    public static final String FABRIC_3_ZONE_SML = "fabrics3ZoneSml";
    public static final String FABRIC_1_ZONE_NAME_FIELD_LABEL = "fabrics1ZoneNameFieldLabel";
    public static final String FABRIC_2_ZONE_NAME_FIELD_LABEL = "fabrics2ZoneNameFieldLabel";
    public static final String FABRIC_3_ZONE_NAME_FIELD_LABEL = "fabrics2ZoneNameFieldLabel";
    public static final String FABRIC_1_SHOW_ZONE_STATUS_CMD = "fabrics1ShowZoneStatusCmd";
    public static final String FABRIC_2_SHOW_ZONE_STATUS_CMD = "fabrics2ShowZoneStatusCmd";
    public static final String FABRIC_3_SHOW_ZONE_STATUS_CMD = "fabrics3ShowZoneStatusCmd";
    public static final String DUAL_SSM_SELECTED = "dualSSMSelected";
    public static final String JOB_METHOD = "jobMethod";
    public static ImageIcon _Image_Server = Util.loadIcon("icons/server_copy48.png");
    public static ImageIcon _Image_Storage = Util.loadIcon("icons/storage_copy48.png");
    public boolean _createJobPduSend = false;
    public static final String QUERY_LUNMAP_STR = "Getting Lun Map Correlation and Preparing Session input...";

    public int getNextStep() {
        return this.getCurrentCardIndex() + 1;
    }

    public DataMigWizard(JFrame parent, int migType) throws Exception {
        super(parent);
        this.setModelValue(SERVER_RIF, this._ddmServerRif);
        this.setModelValue(DM_TYPE, new Integer(migType));
        this.setTitle("Data Migration Wizard: " + (migType == -86 ? "Server-based" : "Storage-based "));
        this.setSize(750, 800);
        this.addPanel(PANEL_NAME_JOB, new DataMigJobPanel(this, migType));
        this.addPanel(PANEL_NAME_SSM, new DataMigSwitchPanel(this, migType));
        this.first();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void dispose() {
        WizardPanel panel = this.getCurrent();
        if (panel != null) {
            panel.dispose();
        }
        super.dispose();
    }

    @Override
    public void updateNavBtn() {
        Object[] o = (Object[])this._cards.elementAt(this._currentCardIndex);
        if (o[0].equals(PANEL_NAME_JOB)) {
            super.updateNavBtn();
            return;
        }
        if (o[0].equals(PANEL_NAME_SSM)) {
            this._nav.setButtonAttr(true, false);
            this._nav.setNextButton("Next");
        } else if (o[0].equals(PANEL_NAME_ZONE)) {
            this._nav.setButtonAttr(false, false);
        } else if (o[0].equals(PANEL_NAME_DPPVI)) {
            this._nav.setButtonAttr(true, false);
            this._nav.setNextButton("Create/Activate Zone");
        } else if (o[0].equals(PANEL_NAME_DATAMOVERSSM)) {
            this._nav.setButtonAttr(true, false);
            this._nav.setNextButton("Next");
        } else {
            this._nav.setButtonAttr(false, this._currentCardIndex == this._cards.size() - 1);
            if (o[0].equals(PANEL_NAME_NONASL_NS)) {
                this._nav.setNextButton("Create");
            }
            if (this._cards.elementAt(this._currentCardIndex + 1) != null) {
                Object[] o1 = (Object[])this._cards.elementAt(this._currentCardIndex + 1);
                if (o[0].equals(PANEL_NAME_NONASL_ES) && !o1[0].equals(PANEL_NAME_NONASL_NS)) {
                    this._nav.setNextButton("Create");
                }
            }
        }
    }

    public void setupSrcDestPath() throws Exception {
        DDMLunITL[] srcLuns = (DDMLunITL[])this._model.get(SOURCE_LUNS);
        DDMLunITL[] destLuns = (DDMLunITL[])this._model.get(DEST_LUNS);
        DDMLunITL matchSrcLunPri = null;
        DDMLunITL matchDestLunPri = null;
        int dmType = (Integer)this._model.get(DM_TYPE);
        for (int i = 0; i < srcLuns.length; ++i) {
            for (int j = 0; j < destLuns.length; ++j) {
                if (!destLuns[j].getInitator().getEndPortPK().equals(srcLuns[i].getInitator().getEndPortPK()) || !destLuns[j].getSwitch().equals(srcLuns[i].getSwitch()) || dmType == -69 && !destLuns[j].getInitator().isVIDPP()) continue;
                matchSrcLunPri = srcLuns[i];
                matchDestLunPri = destLuns[j];
                break;
            }
            if (matchDestLunPri != null) break;
        }
        if (matchDestLunPri == null) {
            throw new Exception("Cannot find matching Primary Destination path!");
        }
        this.setModelValue(SOURCE_PATH_PRI, matchSrcLunPri);
        this.setModelValue(DEST_PATH_PRI, matchDestLunPri);
        DDMSwitch swPri = matchSrcLunPri.getSwitch();
        DDMLunITL srcPathSec = null;
        DDMLunITL matchDestLunSec = null;
        for (int i = 0; i < srcLuns.length; ++i) {
            if (srcLuns[i].getSwitch().equals(swPri)) continue;
            for (int j = 0; j < destLuns.length; ++j) {
                if (!destLuns[j].getInitator().equals(srcLuns[i].getInitator()) || !destLuns[j].getSwitch().equals(srcLuns[i].getSwitch()) || dmType == -69 && !destLuns[j].getInitator().isVIDPP()) continue;
                srcPathSec = srcLuns[i];
                matchDestLunSec = destLuns[j];
                break;
            }
            if (matchDestLunSec != null) break;
        }
        this.setModelValue(SOURCE_PATH_SEC, srcPathSec);
        this.setModelValue(DEST_PATH_SEC, matchDestLunSec);
    }

    public void getLunMap() throws Exception {
        DDMCreationRif dmCreateRif = (DDMCreationRif)this._model.get(CREATE_RIF);
        DDMLunITL[] srcLuns = dmCreateRif.getLunMap(true);
        boolean srcAsl = false;
        if (srcLuns != null && srcLuns.length > 0) {
            srcAsl = srcLuns[0].isASLClassified();
            this.setModelValue(SOURCE_ASL, new Boolean(srcAsl));
        }
        boolean mismatchSrcLunN = false;
        DDMLunITL[] destLuns = dmCreateRif.getLunMap(false);
        boolean destAsl = false;
        if (destLuns != null && destLuns.length > 0) {
            destAsl = destLuns[0].isASLClassified();
            this.setModelValue(DESTINATION_ASL, new Boolean(destAsl));
        }
        boolean mismatchDestLunN = false;
        mismatchSrcLunN = this.isMismatchLun(srcLuns, destLuns);
        this.setModelValue(SOURCE_LUNS, srcLuns);
        this.setModelValue(DEST_LUNS, destLuns);
        int migType = (Integer)this._model.get(DM_TYPE);
        boolean showManualMutiPath = false;
        if (!this.isMethod3()) {
            showManualMutiPath = (Boolean)this._model.get(DISPLAY_MANUAL_MULTI_PATH);
        }
        if (srcAsl && destAsl) {
            this.setupSrcDestPath();
            if (mismatchSrcLunN || mismatchDestLunN || showManualMutiPath) {
                this.setModelValue(SOURCE_LUN_MISMATCH, new Boolean(mismatchSrcLunN));
                this.setModelValue(DEST_LUN_MISMATCH, new Boolean(mismatchDestLunN));
                this.addPanel(PANEL_NAME_PATH, new DataMigMisMatchNumLunPanel(this, (Integer)this._model.get(DM_TYPE), showManualMutiPath));
            }
        } else {
            if (!srcAsl && !destAsl) {
                this.addPanel(PANEL_NAME_NONASL_ES, new DataMigNonAslLunMap(this, (Integer)this._model.get(DM_TYPE), 0));
                this.addPanel(PANEL_NAME_NONASL_NS, new DataMigNonAslLunMap(this, (Integer)this._model.get(DM_TYPE), 1));
            } else if (!srcAsl) {
                this.addPanel(PANEL_NAME_NONASL_ES, new DataMigNonAslLunMap(this, (Integer)this._model.get(DM_TYPE), 0));
            } else {
                this.addPanel(PANEL_NAME_NONASL_NS, new DataMigNonAslLunMap(this, (Integer)this._model.get(DM_TYPE), 1));
            }
            if (showManualMutiPath) {
                this.addPanel(PANEL_NAME_PATH, new DataMigMisMatchNumLunPanel(this, (Integer)this._model.get(DM_TYPE), showManualMutiPath));
            }
        }
        this.addPanel(PANEL_NAME_SESSION, new DataMigSessionPanel(this, migType));
    }

    private boolean isMismatchLun(DDMLunITL[] srcLuns, DDMLunITL[] destLuns) throws Exception {
        if (srcLuns != null && destLuns != null) {
            for (DDMLunITL srcLun : srcLuns) {
                boolean r = false;
                EndPortBase initiator = srcLun.getInitator();
                for (DDMLunITL destLun : destLuns) {
                    if (!destLun.getInitator().equals(initiator)) continue;
                    r = true;
                }
                if (r) continue;
                return true;
            }
        } else {
            throw new Exception("Cannot find any paths for Existing or New Storage");
        }
        return false;
    }

    @Override
    public void addPanel(String cardName, Component panel) {
        System.out.println("To add panel " + this.getCurrentCardIndex() + panel);
        for (int i = 0; i < this.getPanelCount(); ++i) {
            Object[] p = this.getPanelComponentAt(i + 1);
            if (!p[0].equals(cardName)) continue;
            return;
        }
        System.out.println("Adding panel " + this.getCurrentCardIndex() + panel);
        super.addPanel(cardName, panel);
    }

    public boolean isMethod3() {
        return this.getModelValue(JOB_METHOD).equals((byte)-35);
    }

    public boolean isCreateJobPduSend() {
        return this._createJobPduSend;
    }

    public void setCreateJobPduSend(boolean flag) {
        this._createJobPduSend = flag;
    }
}

