/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.AliasTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class InsertAlias
extends InsertForm {
    private JComboBox _names;

    public InsertAlias(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, true);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this.setComponentVisibleAt(0, false);
        this.setComponentVisibleAt(1, false);
    }

    @Override
    protected void layoutForm() {
        JComponent[] labels = new JComponent[this._labels.length + 1];
        System.arraycopy(this._labels, 0, labels, 0, this._labels.length);
        labels[labels.length - 1] = new JLabel("Name:", 4);
        JComponent[] values = new JComponent[this._values.length + 1];
        System.arraycopy(this._values, 0, values, 0, this._values.length);
        Vsan vsan = ((AliasTableModel)this._table)._vsan == null ? ClientController.getInstance().getFabric().findVsanById(((AliasTableModel)this._table)._vsanId) : ((AliasTableModel)this._table)._vsan;
        ArrayList<EndPort> endPorts = vsan.getEndPorts(null);
        Collections.sort(endPorts);
        this._names = new JComboBox<EndPort>(endPorts.toArray(new EndPort[endPorts.size()]));
        this._names.setEditable(true);
        values[values.length - 1] = this._names;
        DialogUtil.buildPanel(this._container, labels, values);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 2) {
            return new JLabel("Alias:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected void insertAction() throws Exception {
        AliasTableModel model = (AliasTableModel)this._table;
        this.setComponentText(0, Integer.toString(model._vsanId));
        int id = model.getNextAvailableAliasIndex();
        this.setComponentText(1, Integer.toString(id));
        super.insertAction();
        Wwn wwn = ((EndPort)this._names.getSelectedItem()).getPortWwn();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        int[] index = new int[]{model._vsanId, 2, id, model.getNextAvailableMemberIndex()};
        pdu.addVar(new SnmpOID(MibNode.get("zoneMemberRowStatus").getOid(), index), new SnmpInt(4));
        pdu.addVar(new SnmpOID(MibNode.get("zoneMemberID").getOid(), index), new SnmpString(wwn.getValue()));
        pdu.addVar(new SnmpOID(MibNode.get("zoneMemberFormat").getOid(), index), new SnmpInt(1));
        model.getPeer().set(pdu);
        model.addName(wwn, id);
        BrowserFrame.getDataView().displayTable();
    }

    @Override
    protected void getSelectedPeers() throws Exception {
        AliasTableModel model = (AliasTableModel)this._table;
        this._selPeerList = new Object[]{model.getPeer()};
    }

    @Override
    protected void addPeers(SnmpPeer[] peers) throws Exception {
    }
}

