/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.jnm.VshDump;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.SnmpCfsRegion;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmCfsUtil;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;

public class SmCFSControlTableModel
extends SmTableModel
implements ActionListener,
MouseListener {
    HashMap _peers2RowInfo;
    HashMap _peers2RowsGetStatus;
    HashMap _peers2RowNoInfo;
    Array _actionChangedCells;
    Array _allChangedCells;
    protected Timer _statusTimer;
    int[][] _featureIndices;
    int _vsanId;
    HashMap _peers2indicesStep;
    HashMap _peers2CfsRegionCreation;
    boolean _hasMaster;
    boolean _usePricipalForMaster;
    boolean _masterSelected;
    String _featureName;
    static boolean isProcessMasterCol = false;
    JButton _diffBtn;
    static final int SWITCH_COL = 0;
    static final int INDEX_COL = 1;
    static final int ACTION_TYPE_COL = 2;
    static final int ACTION_VSAMID_COL = 3;
    public static final int ENABLE_ACTION_COL = 4;
    static final int OP_STATUS_COL = 5;
    static final int GLOBAL_COL = 6;
    public static final int ACTION_COL = 7;
    static final int SHOW_CONFIG_AS_COL = 8;
    static final int LAST_ACTION_STATUS_COL = 9;
    static final int ACTION_STATUS_COL = 10;
    static final int OWNER_COL = 11;
    static final int OWNER_USER_COL = 12;
    static final int MERGE_STATUS_COL = 13;
    static final int MASTER_COL = 14;
    static final int FAILURE_REASON_COL = 15;
    static final int REGION_COL = 17;
    public static final int[] _cfsFeatureOpActionOid = MibNode.get("cfsFeatureOpAction").getOid();
    static final int STATUS_POLLING_MIB_SIZE = 7;
    public static final int[] _cfsFeatureOpStatusOid = MibNode.get("cfsFeatureOpStatus").getOid();
    static final int[] _cfsMergeStatusValueOid = MibNode.get("cfsMergeStatusValue").getOid();
    static final int[] _cfsPendingConfOwnerAddrOid = MibNode.get("cfsPendingConfOwnerAddr").getOid();
    static final int[] _cfsPendingConfOwnerIDOid = MibNode.get("cfsPendingConfOwnerID").getOid();
    static final int[] _cfsDistCtrlOid = MibNode.get("cfsDistCtrl").getOid();
    static final int[] _CfsFeatureRegionId = MibNode.get("cfsFeatureRegionId").getOid();
    static final int[] _CfsFeatureRegionStatusOid = MibNode.get("cfsFeatureRegionStatus").getOid();
    static final int[] _CfsRegionStatusOid = MibNode.get("cfsRegionStatus").getOid();
    static final MibEnum[] _cfsFeatureOpShowCfgOptionEnum = MibNode.get("cfsFeatureOpShowCfgOption").getEnums();
    static final MibEnum[] _cfsFeatureOpScopeTypeEnum = MibNode.get("cfsFeatureOpScopeType").getEnums();
    static final MibEnum[] _cfsDistCtrlEnum = MibNode.get("cfsDistCtrl").getEnums();
    static final MibEnum[] _cfsMergeStatusValueEnum = MibNode.get("cfsMergeStatusValue").getEnums();
    private int[] _lastActionOid;
    private int[] _lastActionResultOid;
    private int[] _lastFailureReasonOid;
    private int[] _featureVsanIndex;
    private boolean _isCheckCommit;
    private String _checkCommitWarnMsg;
    public static final int FEATURE_ENABLED = 2;
    static final int ACTION_RESULT_INPROGRESS = 4;
    public static final int LAST_ACTION_SUCCESS = 2;
    public static final int ACTION_NOOP = 1;
    public static final int ACTION_ENABLE = 2;
    public static final int ACTION_DISABLE = 3;
    public static final int ACTION_COMMIT = 4;
    static final int SHOW_CONFIG_AS_RUNNING = 1;
    static final int SHOW_CONFIG_AS_PENDING = 2;
    static final int VSANID_TYPE = 2;
    static final int MERGE_STATUS_FAIL = 3;
    public static final int[] NTP_INDEX = new int[]{3, 110, 116, 112};
    public static final int[] DDAS_INDEX = new int[]{12, 100, 101, 118, 105, 99, 101, 45, 97, 108, 105, 97, 115};
    public static final int[] PORT_SECURITY_INDEX = new int[]{13, 112, 111, 114, 116, 45, 115, 101, 99, 117, 114, 105, 116, 121};
    public static final MibEnum[] CFSActionsEnable = new MibEnum[]{new MibEnum("noSelection", 1), new MibEnum("enable", 2), new MibEnum("disable", 3)};
    public static final MibEnum[] CFSActionsCmd = new MibEnum[]{new MibEnum("noSelection", 1), new MibEnum("commitChanges", 4), new MibEnum("abortChanges", 5), new MibEnum("clearLock", 5)};
    private String[] _custom_CLIcmd_Features = new String[]{"tacacs", "device-alias", "syslogd", "vsan"};
    private String[] _custom_CLIcmd_2x = new String[]{"tacacs+", "device-alias database", "logging", "fctimer"};
    private String[] _custom_CLIcmd = new String[]{"tacacs+", "device-alias", "logging", "fctimer"};

    public SmCFSControlTableModel(String[] featureStrings, boolean hasMaster) {
        this(featureStrings, 0, hasMaster, false);
    }

    public SmCFSControlTableModel(String[] featureStrings, int vsan, boolean hasMaster, boolean usePricipalForMaster) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        this._vsanId = vsan;
        this._hasMaster = hasMaster;
        this._usePricipalForMaster = usePricipalForMaster;
        this._featureIndices = new int[featureStrings.length][];
        for (int i = 0; i < featureStrings.length; ++i) {
            byte[] b = featureStrings[i].getBytes();
            this._featureIndices[i] = new int[b.length];
            for (int j = 0; j < b.length; ++j) {
                this._featureIndices[i][j] = b[j] & 0xFF;
            }
            if (!featureStrings[i].equals("dpvm") && !featureStrings[i].equals("device-alias")) continue;
            this._isCheckCommit = true;
            this._checkCommitWarnMsg = featureStrings[i].equals("dpvm") ? "<html>CFS DPVM database is in merge failure condition,<p>commit would overwrite other fabrics DPVM databases.<p>Are you sure you want to continue?<html>" : "<html>CFS DeviceAlias database is in merge failure condition,<p>commit would overwrite other fabrics DeviceAlias databases.<p>Are you sure you want to continue?<html>";
        }
        this._featureName = SnmpString.toString(this._featureIndices[0], 0, this._featureIndices[0].length);
        this._peers2RowInfo = new HashMap();
        this._statusTimer = new Timer(5000, this);
        this._peers2RowsGetStatus = new HashMap();
        this._peers2RowNoInfo = new HashMap();
        this._actionChangedCells = new Array();
        this._allChangedCells = new Array();
        this._peers2indicesStep = new HashMap();
        this._peers2CfsRegionCreation = new HashMap();
        if (vsan != 0) {
            SmCfsUtil.getInstance();
            nArray3 = SmCfsUtil._cfsFeatureOpExtLastActionOid;
        } else {
            SmCfsUtil.getInstance();
            nArray3 = this._lastActionOid = SmCfsUtil._cfsFeatureOpLastActionOid;
        }
        if (vsan != 0) {
            SmCfsUtil.getInstance();
            nArray2 = SmCfsUtil._cfsFeatureOpExtLastActionResultOid;
        } else {
            SmCfsUtil.getInstance();
            nArray2 = this._lastActionResultOid = SmCfsUtil._cfsFeatureOpLastActionResultOid;
        }
        if (vsan != 0) {
            SmCfsUtil.getInstance();
            nArray = SmCfsUtil._cfsFeatureOpExtLastFailureReasonOid;
        } else {
            SmCfsUtil.getInstance();
            nArray = SmCfsUtil._cfsFeatureOpLastFailureReasonOid;
        }
        this._lastFailureReasonOid = nArray;
        BrowserFrame.getTable().addMouseListener(this);
        DataView dataView = BrowserFrame.getDataView();
        JPanel newPanel = new JPanel(new FlowLayout(0, 2, 2));
        newPanel.add(dataView.getDefaultButtonPanel());
        this._diffBtn = new JButton("Pending Difference...");
        this._diffBtn.setActionCommand("diff");
        this._diffBtn.addActionListener(this);
        newPanel.add(this._diffBtn);
        dataView.replaceButtonPanel(newPanel);
        this._diffBtn.setEnabled(false);
    }

    @Override
    protected void tableSelectionChanged(boolean selected, SnmpKTable table) {
        this._diffBtn.setEnabled(table.getSelectedRowCount() == 1);
        BrowserFrame.getDataView().enableButton(12, table.getSelectedRowCount() == 1);
    }

    @Override
    protected boolean promptWarning(String message) {
        Object[] options = new String[]{"Yes", "No"};
        return JOptionPane.showOptionDialog(BrowserFrame.getDataView(), message, "Select an Option", 0, 3, null, options, "No") == 1;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        boolean[] isEditable = this.getEditable();
        isEditable[14] = true;
        isEditable[6] = false;
        this.setEditable(isEditable);
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        this._diffBtn.setEnabled(false);
        SnmpPeer[] peers = null;
        if (this._vsanId != 0) {
            ArrayList<SnmpPeer> peers2Query = new ArrayList<SnmpPeer>();
            for (int i = 0; i < invoker.length; ++i) {
                SnmpPeer peer = invoker[i].getSnmpPeer();
                ClientController.getInstance();
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                if (sw == null || !sw.isVersionGreaterThanEqual("2.1(0)")) continue;
                peers2Query.add(peer);
            }
            MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
            SnmpPeer[] allPeers = this.getWrkingPeersGeneral(mgmtDomain);
            if (allPeers != null) {
                for (int j = 0; j < allPeers.length; ++j) {
                    boolean found = false;
                    SnmpPeer a = allPeers[j];
                    for (int k = 0; k < peers2Query.size(); ++k) {
                        SnmpPeer b = (SnmpPeer)peers2Query.get(k);
                        if (!a.equals(b)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    peers2Query.add(a);
                }
            }
            peers = peers2Query.toArray(new SnmpPeer[0]);
            peers = this._featurectrlIndices != null ? this.getFeatureCtrlPeers(peers) : super.getWrkingPeers(peers);
        } else {
            peers = super.getWrkingPeers();
        }
        this._peers2RowNoInfo.clear();
        this._peers2RowInfo.clear();
        return this.getTableVars(peers);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        SnmpVar mergeVar;
        SnmpVar LastActionV = vbl.get(7).getVar();
        SnmpVar actionStatusV = vbl.get(8).getVar();
        String failureReason = vbl.stringValue(13);
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        if (!(LastActionV instanceof SnmpNull) && !(actionStatusV instanceof SnmpNull)) {
            row[10] = MibVariableFormat.cfsFeatureOpLastActionResultAdv(LastActionV, actionStatusV, failureReason);
        }
        boolean isMaster = false;
        byte[] nodeAddrByte = node.getAddress().getAddress();
        SnmpVar ownerVar = vbl.get(9).getVar();
        byte[] ownerAddrByte = null;
        if (ownerVar.getType() != 5 && SnmpString.equals(nodeAddrByte, ownerAddrByte = ((SnmpString)ownerVar).getValue())) {
            isMaster = true;
        }
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        String masterSwitch = "self";
        if (isMaster) {
            masterSwitch = sw != null && !sw.toString().equals("") ? sw.toString() : node.getAddress().toString();
        }
        row[11] = isMaster ? masterSwitch : "";
        SnmpVar ownerUserVar = vbl.get(10).getVar();
        if (ownerVar.getType() == 5 || !isMaster) {
            row[12] = "";
        }
        if ((mergeVar = vbl.get(11).getVar()).getType() == 5) {
            row[13] = "";
        } else {
            int mergeStatus = vbl.intValue(11);
            if (mergeStatus == 3) {
                row[13] = row[13] + "...";
            }
        }
        SnmpVar operStatusVar = vbl.get(3).getVar();
        if (this._hasMaster && ((SnmpInt)operStatusVar).getValue() == 2 && isMaster && !this._masterSelected) {
            row[14] = Boolean.TRUE;
            this._masterSelected = true;
        } else {
            row[14] = Boolean.FALSE;
        }
        HashMap<String, Integer> index2RowN = (HashMap<String, Integer>)this._peers2RowInfo.get(node);
        if (index2RowN == null) {
            index2RowN = new HashMap<String, Integer>();
            this._peers2RowInfo.put(node, index2RowN);
        }
        int[] indexOid = index.getValue();
        String featureName = this.getFeatureName(indexOid);
        index2RowN.put(featureName, new Integer(this._responseData.size() - 1));
        ArrayList<Integer> peer2RowN = (ArrayList<Integer>)this._peers2RowNoInfo.get(node);
        if (peer2RowN == null) {
            peer2RowN = new ArrayList<Integer>();
            this._peers2RowNoInfo.put(node, peer2RowN);
        }
        peer2RowN.add(new Integer(this._responseData.size() - 1));
        return row;
    }

    protected String getFeatureName(int[] index) {
        return SnmpString.toString(index, 1, index.length);
    }

    protected String getFeatureNameAtSwitch(SnmpPeer node) {
        return this._featureName;
    }

    @Override
    protected int[] getIndex() {
        return this.getNextFeatureIndex(0);
    }

    @Override
    public int[] getCellSetIndex(Cell cell) {
        int[] superIndex = super.getCellSetIndex(cell);
        if (this._vsanId != 0 && (cell._col == 8 || cell._col >= 11 && cell._col <= 13 || cell._col == 17)) {
            byte[] vsanB = SnmpIntList.valueOf(new int[]{this._vsanId});
            int[] vsanValIndex = SnmpString.valueOf(vsanB, true);
            int[] index = new int[superIndex.length + vsanB.length + 2];
            System.arraycopy(superIndex, 0, index, 0, superIndex.length);
            index[superIndex.length] = 2;
            System.arraycopy(vsanValIndex, 0, index, superIndex.length + 1, vsanValIndex.length);
            return index;
        }
        if (cell._col == 6) {
            return new int[]{0};
        }
        if (cell._col == 17) {
            int[] index = new int[superIndex.length + 1];
            System.arraycopy(superIndex, 0, index, 0, superIndex.length);
            index[index.length - 1] = 1;
            return index;
        }
        return superIndex;
    }

    private int[] getNextFeatureIndex(int pos) {
        int[] index = new int[this._featureIndices[pos].length + 1];
        System.arraycopy(this._featureIndices[pos], 0, index, 1, index.length - 1);
        index[0] = this._featureIndices[pos].length;
        int n = index.length - 1;
        index[n] = index[n] - 1;
        return index;
    }

    private int[] getFeatureVsanIndex() {
        if (this._vsanId == 0) {
            return this.getIndex();
        }
        int[] featureIndex = this.getIndex();
        byte[] vsanB = SnmpIntList.valueOf(new int[]{this._vsanId});
        int[] vsanValIndex = SnmpString.valueOf(vsanB, true);
        int[] index = new int[featureIndex.length + vsanB.length + 2];
        System.arraycopy(featureIndex, 0, index, 0, featureIndex.length);
        int n = featureIndex.length - 1;
        index[n] = index[n] + 1;
        index[featureIndex.length] = 2;
        System.arraycopy(vsanValIndex, 0, index, featureIndex.length + 1, vsanValIndex.length);
        int n2 = index.length - 1;
        index[n2] = index[n2] - 1;
        return index;
    }

    private int[] getRegionIndex() {
        if (this._vsanId != 0) {
            return this.getIndex();
        }
        int[] featureIndex = this.getIndex();
        int[] index = new int[featureIndex.length + 1];
        System.arraycopy(featureIndex, 0, index, 0, featureIndex.length);
        index[featureIndex.length] = 1;
        int n = index.length - 1;
        index[n] = index[n] - 1;
        return index;
    }

    @Override
    protected SnmpPDU buildGetTablePdu(SnmpPeer node, int[] index) {
        SnmpPDU pdu = new SnmpPDU(-95, new VarBindList(this._mibNodes.length));
        for (int j = this._offset; j < this._mibNodes.length; ++j) {
            if ((j >= 8 && j <= 10 || j >= 11 && j <= 13 || j == 15) && this._vsanId != 0) {
                pdu.addNull(new SnmpOID(this._mibNodes[j].getOid(), this.getFeatureVsanIndex()));
                continue;
            }
            if (j == 17) {
                pdu.addNull(new SnmpOID(this._mibNodes[j].getOid(), this.getRegionIndex()));
                continue;
            }
            pdu.addNull(new SnmpOID(this._mibNodes[j].getOid(), index));
        }
        return pdu;
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._responseData = new Array();
        if (nodes == null || nodes.length == 0) {
            return this._responseData;
        }
        this._peers2RowNoInfo.clear();
        this._peers2indicesStep.clear();
        this._peers2RowInfo.clear();
        this._masterSelected = false;
        for (int i = 0; i < nodes.length; ++i) {
            this._peers2indicesStep.put(nodes[i], new Integer(0));
        }
        if (this._vsanId != 0) {
            this._mibNodes[8] = MibNode.get("cfsFeatureOpExtShowCfgOption");
            this._mibNodes[9] = MibNode.get("cfsFeatureOpExtLastAction");
            this._mibNodes[10] = MibNode.get("cfsFeatureOpExtLastActionResult");
            this._mibNodes[15] = MibNode.get("cfsFeatureOpExtLastFailureReason");
        }
        super.getTableVars(nodes);
        this.fetchCfsGlobal(nodes);
        this.selectMaster(nodes);
        return this._responseData;
    }

    private void selectMaster(SnmpPeer[] nodes) {
        if (this._hasMaster && !this._masterSelected && nodes != null) {
            Object[] row;
            int rowN;
            HashMap index2RowN;
            ArrayList<Wwn> swWwnList = new ArrayList<Wwn>();
            for (int i = 0; i < nodes.length; ++i) {
                Object[] row2;
                int rowN2;
                ClientController.getInstance();
                Switch sw = ClientController.findFabricSwitchByIpAddress(nodes[i].getAddress());
                SnmpPeer peer = sw.getSnmpPeer();
                HashMap index2RowN2 = (HashMap)this._peers2RowInfo.get(peer);
                if (index2RowN2 == null || (rowN2 = ((Integer)index2RowN2.get(this._featureName)).intValue()) >= this._responseData.size() || (row2 = (Object[])this._responseData.elementAt(rowN2)) == null || !((String)row2[5]).equals("enabled") || !((JnmMibEnum)row2[6]).getLabel().equals("enable")) continue;
                if (this._usePricipalForMaster) {
                    MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
                    Vsan v = mgmtDomain.isVsan() ? (Vsan)mgmtDomain : ((EnforcedZone)mgmtDomain).getVsan();
                    swWwnList.add(sw.getVsanWwn(v.getId()));
                    continue;
                }
                swWwnList.add(sw.getWwn());
            }
            SnmpPeer masterPeer = null;
            if (swWwnList.size() != 0) {
                if (this._usePricipalForMaster) {
                    MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
                    Vsan v = mgmtDomain.isVsan() ? (Vsan)mgmtDomain : ((EnforcedZone)mgmtDomain).getVsan();
                    Wwn principalWwn = v.getPrincipalVsanWwn();
                    int masterSwitchPos = 0;
                    if (principalWwn != null) {
                        for (int i = 0; i < swWwnList.size(); ++i) {
                            if (!principalWwn.equals(swWwnList.get(i))) continue;
                            masterSwitchPos = i;
                            break;
                        }
                    } else {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "INFO   vsan " + v + " principal null, selecting the first switch as master.");
                        if (SnmpSession.isTrace()) {
                            DefaultLogger._DefLogger.debug((Object)("INFO   vsan " + v + " principal null, selecting the first switch as master."));
                        }
                    }
                    ClientController.getInstance();
                    masterPeer = ClientController.findFabricSwitchByWwn((Wwn)swWwnList.get(masterSwitchPos), true).getSnmpPeer();
                } else {
                    Collections.sort(swWwnList);
                    ClientController.getInstance();
                    masterPeer = ClientController.findFabricSwitchByWwn((Wwn)swWwnList.get(0)).getSnmpPeer();
                }
            }
            if (masterPeer != null && (index2RowN = (HashMap)this._peers2RowInfo.get(masterPeer)) != null && (Integer)index2RowN.get(this._featureName) != null && (rowN = ((Integer)index2RowN.get(this._featureName)).intValue()) < this._responseData.size() && ((String)(row = (Object[])this._responseData.elementAt(rowN))[5]).equals("enabled")) {
                row[14] = Boolean.TRUE;
                this._masterSelected = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchCfsGlobal(SnmpPeer[] nodes) {
        this._state = 1;
        boolean requestSent = false;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        Object object = this._peers2RowNoInfo;
        synchronized (object) {
            for (SnmpPeer peer : this._peers2RowNoInfo.keySet()) {
                ArrayList rowIndices = (ArrayList)this._peers2RowNoInfo.get(peer);
                if (rowIndices == null) continue;
                VarBindList vbl = new VarBindList();
                int[] index = new int[]{0};
                vbl.add(new SnmpVarBind(new SnmpOID(_cfsDistCtrlOid, index)));
                peers2Vbl.put(peer, vbl);
            }
        }
        this._numOutstanding.set(0);
        object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                VarBindList vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpFetch f = new SnmpFetch();
                try {
                    f.get(peer, vbl, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    private void processCfsGlobal(SnmpPeer peer, VarBindList vbl) {
        for (int i = 0; i < vbl.size(); ++i) {
            int cfsEnabled = vbl.intValue(i);
            ArrayList index2RowN = (ArrayList)this._peers2RowNoInfo.get(peer);
            if (index2RowN == null) continue;
            for (int j = 0; j < index2RowN.size(); ++j) {
                int rowN = (Integer)index2RowN.get(i);
                if (rowN >= this.getData().size()) continue;
                Object[] row = (Object[])this.getData().elementAt(rowN);
                if (vbl.get(i).getVar().getType() == 5) {
                    row[6] = new JnmMibEnum("n/a", cfsEnabled, _cfsDistCtrlEnum);
                    continue;
                }
                boolean found = false;
                for (int k = 0; k < _cfsDistCtrlEnum.length; ++k) {
                    if (_cfsDistCtrlEnum[k].getValue() != cfsEnabled) continue;
                    row[6] = new JnmMibEnum(_cfsDistCtrlEnum[k].getLabel(), cfsEnabled, _cfsDistCtrlEnum);
                    found = true;
                }
                if (found) continue;
                row[6] = new JnmMibEnum("Unknown: " + cfsEnabled, cfsEnabled, _cfsDistCtrlEnum);
            }
        }
    }

    @Override
    protected SnmpPeer[] getWrkingPeers(SnmpPeer[] peers) {
        if (this._vsanId == 0) {
            peers = ClientController.getInstance().getFabric().getSnmpPeers();
        }
        return super.getWrkingPeers(peers);
    }

    @Override
    public boolean applyChanges() throws Exception {
        if (this._peers2RowsGetStatus.size() != 0) {
            return false;
        }
        Array cells = super.getChanged();
        if (cells == null) {
            return false;
        }
        this._peers2RowsGetStatus.clear();
        this._actionChangedCells.clear();
        this._allChangedCells.clear();
        this._peers2CfsRegionCreation.clear();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._col == 4 || cell._col == 7) {
                this.setValueAt("inProgress", cell._row, 10);
                BrowserFrame.getInstance();
                BrowserFrame.getDataView()._table.calcPreferredSize();
                this._actionChangedCells.addElement(new Cell(cell._row, cell._col));
            }
            if (cell._col == 14) continue;
            this._allChangedCells.addElement(new Cell(cell._row, cell._col));
        }
        this.fireTableDataChanged();
        boolean isApply = super.applyChanges(this);
        this.selectMaster(this.getWrkingPeers());
        if (this._actionChangedCells.size() != 0) {
            this._statusTimer.start();
        }
        return isApply;
    }

    @Override
    protected Array getChangeCells() {
        return this._allChangedCells;
    }

    void updatePeers2RowInfo() {
        this._peers2RowInfo.clear();
        Array data = this.getData();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            SnmpPeer node = (SnmpPeer)row[0];
            HashMap<String, Integer> index2RowN = (HashMap<String, Integer>)this._peers2RowInfo.get(node);
            if (index2RowN == null) {
                index2RowN = new HashMap<String, Integer>();
                this._peers2RowInfo.put(node, index2RowN);
            }
            int[] indexOid = ((SnmpOID)row[1]).getValue();
            String featureName = SnmpString.toString(indexOid, 1, indexOid.length);
            index2RowN.put(featureName, new Integer(i));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._peers2RowsGetStatus.size() != 0) {
                this.pollSwitches();
                return;
            }
            this._statusTimer.stop();
            this.resetChanges(false);
        } else if (e.getActionCommand().startsWith("diff")) {
            try {
                this.diff();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSwitches() {
        this._state = 1;
        boolean requestSent = false;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        Object object = this._peers2RowsGetStatus;
        synchronized (object) {
            for (SnmpPeer peer : this._peers2RowsGetStatus.keySet()) {
                Array rowIndices = (Array)this._peers2RowsGetStatus.get(peer);
                if (rowIndices == null) continue;
                VarBindList vbl = new VarBindList();
                for (int i = 0; i < rowIndices.size(); ++i) {
                    int[] nArray;
                    int[] nArray2;
                    int[] nArray3;
                    int[] mergeIndex;
                    int[] featureIndex = ((FeatureAction)rowIndices.elementAt(i)).getFeature().getValue();
                    boolean isEnableDisable = ((FeatureAction)rowIndices.elementAt(i)).getAction() == 2 || ((FeatureAction)rowIndices.elementAt(i)).getAction() == 3;
                    byte[] vsanB = SnmpIntList.valueOf(new int[]{this._vsanId});
                    int[] vsanValIndex = SnmpString.valueOf(vsanB, true);
                    int[] vsanIndex = new int[featureIndex.length + vsanB.length + 2];
                    System.arraycopy(featureIndex, 0, vsanIndex, 0, featureIndex.length);
                    vsanIndex[featureIndex.length] = 2;
                    System.arraycopy(vsanValIndex, 0, vsanIndex, featureIndex.length + 1, vsanValIndex.length);
                    int[] index = this._vsanId != 0 && !isEnableDisable ? vsanIndex : featureIndex;
                    if (this._vsanId != 0) {
                        mergeIndex = vsanIndex;
                    } else {
                        mergeIndex = new int[featureIndex.length + 1];
                        System.arraycopy(featureIndex, 0, mergeIndex, 0, featureIndex.length);
                        mergeIndex[mergeIndex.length - 1] = 1;
                    }
                    if (this._vsanId != 0 && !isEnableDisable) {
                        SmCfsUtil.getInstance();
                        nArray3 = SmCfsUtil._cfsFeatureOpExtLastActionOid;
                    } else {
                        SmCfsUtil.getInstance();
                        nArray3 = this._lastActionOid = SmCfsUtil._cfsFeatureOpLastActionOid;
                    }
                    if (this._vsanId != 0 && !isEnableDisable) {
                        SmCfsUtil.getInstance();
                        nArray2 = SmCfsUtil._cfsFeatureOpExtLastActionResultOid;
                    } else {
                        SmCfsUtil.getInstance();
                        nArray2 = this._lastActionResultOid = SmCfsUtil._cfsFeatureOpLastActionResultOid;
                    }
                    if (this._vsanId != 0 && !isEnableDisable) {
                        SmCfsUtil.getInstance();
                        nArray = SmCfsUtil._cfsFeatureOpExtLastFailureReasonOid;
                    } else {
                        SmCfsUtil.getInstance();
                        nArray = SmCfsUtil._cfsFeatureOpLastFailureReasonOid;
                    }
                    this._lastFailureReasonOid = nArray;
                    vbl.add(new SnmpVarBind(new SnmpOID(this._lastActionResultOid, index)));
                    vbl.add(new SnmpVarBind(new SnmpOID(this._lastFailureReasonOid, index)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfsFeatureOpStatusOid, featureIndex)));
                    vbl.add(new SnmpVarBind(new SnmpOID(this._lastActionOid, index)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfsMergeStatusValueOid, mergeIndex)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfsPendingConfOwnerAddrOid, mergeIndex)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfsPendingConfOwnerIDOid, mergeIndex)));
                }
                peers2Vbl.put(peer, vbl);
            }
        }
        this._numOutstanding.set(0);
        object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                VarBindList vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpPDU pdu = new SnmpPDU(-96, vbl);
                pdu.setRetries(0);
                try {
                    peer.send(pdu, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
        this.selectMaster(this.getWrkingPeers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object vbl;
        if (this._state == 5) {
            return;
        }
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(peer, pdu, timedOut) && pdu.getVariables().size() > 0) {
            if (this._state == 2) {
                SnmpOID firstOid = pdu.getVariables().getVb(0).getOid();
                VarBindList vbl2 = pdu.getVariables();
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
            vbl = pdu.getVariables();
            if (SnmpOID.startsWith(((VarBindList)vbl).get(0).getOid().getValue(), _cfsDistCtrlOid)) {
                this.processCfsGlobal(peer, (VarBindList)vbl);
            } else {
                this.processPollVbl(peer, (VarBindList)vbl);
            }
        } else {
            vbl = this._peers2RowsGetStatus;
            synchronized (vbl) {
                this._peers2RowsGetStatus.remove(peer);
            }
            vbl = this._peers2RowInfo;
            synchronized (vbl) {
                this.updatePeers2RowInfo();
            }
        }
        this.fireTableDataChanged();
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                vbl = this._numOutstanding;
                synchronized (vbl) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPollVbl(SnmpPeer peer, VarBindList vbl) {
        for (int i = 0; i < vbl.size(); i += 7) {
            Array rowIndices;
            int rowN;
            int[] indexOid;
            String featureName;
            SnmpVarBind vb = vbl.getVb(i);
            int actionResult = vbl.intValue(i);
            int[] oid = vb.getOid().getValue();
            SnmpOID index = new SnmpOID(oid, this._lastActionResultOid.length, oid.length - this._lastActionResultOid.length);
            int len = this._lastActionResultOid.length;
            int[] newIndex = new int[oid[len]];
            System.arraycopy(oid, len + 1, newIndex, 0, newIndex.length);
            index = new SnmpOID(newIndex);
            HashMap index2RowN = (HashMap)this._peers2RowInfo.get(peer);
            if (index2RowN != null && (Integer)index2RowN.get(featureName = SnmpString.toString(indexOid = index.getValue(), 0, indexOid.length)) != null && (rowN = ((Integer)index2RowN.get(featureName)).intValue()) < this.getData().size()) {
                Object[] row = (Object[])this.getData().elementAt(rowN);
                String strLastActionResult = MibEnum.getLabel(MibNode.get("cfcFeatureCtrlLastActionResult").getEnums(), actionResult);
                row[5] = MibEnum.getLabel(MibNode.get("cfcFeatureCtrlOpStatus").getEnums(), vbl.intValue(i + 2));
                row[9] = MibVariableFormat.cfsFeatureOpLastAction(vbl.getVb(i + 3).getVar());
                row[10] = MibVariableFormat.cfsFeatureOpLastActionResultAdv(vbl.getVb(i + 3).getVar(), vbl.getVb(i).getVar(), vbl.stringValue(i + 1));
                row[4] = CFSActionsCmd[0];
                row[7] = CFSActionsCmd[0];
                if (vbl.get(i + 4).getVar().getType() != 5) {
                    row[13] = MibEnum.getLabel(MibNode.get("cfsMergeStatusValue").getEnums(), vbl.intValue(i + 4));
                    if (vbl.intValue(i + 4) == 3) {
                        row[13] = row[13] + "...";
                    }
                } else {
                    row[13] = "";
                }
                boolean isMaster = false;
                byte[] nodeAddrByte = peer.getAddress().getAddress();
                SnmpVar ownerVar = vbl.get(i + 5).getVar();
                byte[] ownerAddrByte = null;
                if (ownerVar.getType() != 5 && SnmpString.equals(nodeAddrByte, ownerAddrByte = ((SnmpString)ownerVar).getValue())) {
                    isMaster = true;
                }
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                String masterSwitch = "self";
                if (isMaster) {
                    masterSwitch = sw != null && !sw.toString().equals("") ? sw.toString() : peer.getAddress().toString();
                }
                row[11] = isMaster ? masterSwitch : "";
                row[12] = ownerVar.getType() == 5 || !isMaster ? "" : vbl.stringValue(i + 6);
                BrowserFrame.getInstance();
                BrowserFrame.getDataView()._table.calcPreferredSize();
            }
            if (actionResult == 4 || (rowIndices = (Array)this._peers2RowsGetStatus.get(peer)) == null) continue;
            for (int j = rowIndices.size() - 1; j >= 0; --j) {
                SnmpOID rowIndex = ((FeatureAction)rowIndices.elementAt(j)).getFeature();
                if (!SnmpOID.equals(rowIndex.getValue(), 1, index.getValue(), 0)) continue;
                rowIndices.removeElementAt(j);
                break;
            }
            HashMap hashMap = this._peers2RowsGetStatus;
            synchronized (hashMap) {
                if (rowIndices.size() == 0) {
                    this._peers2RowsGetStatus.remove(peer);
                }
                continue;
            }
        }
    }

    @Override
    protected boolean prepareGetNextPdu(SnmpPeer peer, VarBindList vbl) {
        Integer indicesStepObj = (Integer)this._peers2indicesStep.get(peer);
        if (indicesStepObj == null) {
            return false;
        }
        int indicesStep = indicesStepObj;
        if (indicesStep == this._featureIndices.length - 1) {
            return false;
        }
        this._peers2indicesStep.put(peer, new Integer(++indicesStep));
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            vb.setVar(null);
            int[] mibOid = this._mibNodes[i + this._offset].getOid();
            vb.setOid(new SnmpOID(mibOid, this.getNextFeatureIndex(indicesStep)));
        }
        return true;
    }

    @Override
    protected boolean isSkip(SnmpPeer peer, int[] req, SnmpVarBind firstVb, int[] index, VarBindList vbl, int reqId) {
        for (int i = 0; i < this._featureIndices.length; ++i) {
            if (!SnmpOID.equals(index, 1, this._featureIndices[i], 0)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        if (pdu.getVariables().size() > 0 && pdu.getVariables().get(0).getOid().startsWith(_CfsRegionStatusOid)) {
            return;
        }
        super.snmpAggregrate(pdu, err);
        VarBindList vbl = pdu.getVariables();
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (err != null && err.length() != 0) {
            for (int i = 0; i < vbl.size(); ++i) {
                int rowN;
                SnmpOID index;
                int[] indexOid;
                String featureName;
                HashMap index2RowN;
                SnmpVarBind vb = vbl.getVb(i);
                int[] oid = vb.getOid().getValue();
                if (!SnmpOID.startsWith(oid, _cfsFeatureOpActionOid) || (index2RowN = (HashMap)this._peers2RowInfo.get(node)) == null || (Integer)index2RowN.get(featureName = SnmpString.toString(indexOid = (index = new SnmpOID(oid, _cfsFeatureOpActionOid.length + 1, oid.length - _cfsFeatureOpActionOid.length - 1)).getValue(), 0, indexOid.length)) == null || (rowN = ((Integer)index2RowN.get(featureName)).intValue()) >= this.getData().size()) continue;
                this.setValueAt("error", rowN, 10);
            }
            return;
        }
        Array<FeatureAction> rowIndices = (Array<FeatureAction>)this._peers2RowsGetStatus.get(node);
        if (rowIndices == null) {
            rowIndices = new Array<FeatureAction>();
            HashMap vb = this._peers2RowsGetStatus;
            synchronized (vb) {
                this._peers2RowsGetStatus.put(node, rowIndices);
            }
        }
        boolean match = false;
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            int action = vbl.intValue(i);
            if (SnmpOID.startsWith(oid, _cfsDistCtrlOid)) continue;
            SnmpOID index = new SnmpOID(oid, _cfsFeatureOpActionOid.length, oid.length - _cfsFeatureOpActionOid.length);
            if (!SnmpOID.startsWith(oid, _cfsFeatureOpActionOid)) continue;
            rowIndices.addElement(new FeatureAction(index, action));
        }
        if (rowIndices.size() == 0) {
            HashMap hashMap = this._peers2RowsGetStatus;
            synchronized (hashMap) {
                this._peers2RowsGetStatus.remove(node);
            }
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._statusTimer != null) {
            int nOfEnable = 0;
            boolean noMaster = true;
            Array data = this.getData();
            if (data == null) {
                return;
            }
            int total = data.size();
            SnmpPeer[] scopePeers = this._wrkingPeers;
            if (scopePeers == null) {
                return;
            }
            int nScopePeers = scopePeers.length;
            ArrayList<Object> cfsEnabledPeers = new ArrayList<Object>();
            for (int i = 0; i < total; ++i) {
                Object[] row = (Object[])data.elementAt(i);
                boolean isEnabled = ((String)row[5]).equals("enabled");
                if (isEnabled) {
                    ++nOfEnable;
                    cfsEnabledPeers.add(row[0]);
                }
                SmCfsUtil.getInstance().addFeaturePeerCfsState(this._featureName, (SnmpPeer)row[0], isEnabled ? 2 : 3);
                if (!isEnabled || (Boolean)row[14] != Boolean.TRUE) continue;
                noMaster = false;
                if (this._vsanId == 0) {
                    SmCfsUtil.getInstance().addMaster(this._featureName, (SnmpPeer)row[0]);
                    continue;
                }
                String feature_vsan = this._featureName + Integer.toString(this._vsanId);
                SmCfsUtil.getInstance().addMaster(feature_vsan, (SnmpPeer)row[0]);
            }
            StringBuffer buf = new StringBuffer();
            if (this._hasMaster) {
                boolean warn;
                if (nOfEnable != 0 && nOfEnable != nScopePeers && (warn = SmCfsUtil._PromptCFSWarning)) {
                    buf.append(this._featureName.toUpperCase() + " CFS is not enabled on the following switches:\n");
                    int nOfPeerOnLine = 0;
                    for (int i = 0; i < nScopePeers; ++i) {
                        if (cfsEnabledPeers.contains(scopePeers[i])) continue;
                        buf.append(scopePeers[i]);
                        if (i != nScopePeers - 1) {
                            buf.append(", ");
                        } else {
                            buf.append(".");
                        }
                        if (++nOfPeerOnLine != 4) continue;
                        nOfPeerOnLine = 0;
                        buf.append("\n");
                    }
                    buf.append("\n\n");
                    buf.append("Reminder: Configuration changes will not be consistent across fabric.\n");
                    buf.append("Check:\n");
                    buf.append("1) Has feature been enabled?\n");
                    buf.append("2) Has CFS been enabled for feature?\n");
                    buf.append("3) Do all switches support this feature?\n");
                    JOptionPane pane = new JOptionPane(buf.toString(), 2, -1, null, new Object[]{new JCheckBox("Don't warn me again"), "OK"});
                    JDialog dialog = pane.createDialog(BrowserFrame.getDataView(), "CFS warning");
                    dialog.setVisible(true);
                    Object[] options = pane.getOptions();
                    JCheckBox donotshowChkbx = (JCheckBox)options[0];
                    boolean selected = donotshowChkbx.isSelected();
                    boolean bl = SmCfsUtil._PromptCFSWarning = !selected;
                }
                if (noMaster) {
                    if (this._vsanId == 0) {
                        SmCfsUtil.getInstance().removeMaster(this._featureName);
                    } else {
                        String feature_vsan = this._featureName + Integer.toString(this._vsanId);
                        SmCfsUtil.getInstance().removeMaster(feature_vsan);
                    }
                }
            }
            this._statusTimer.stop();
            this._statusTimer = null;
        }
        BrowserFrame.getTable().removeMouseListener(this);
    }

    @Override
    protected void performPostSorting() {
        this.updatePeers2RowInfo();
    }

    @Override
    protected void repairVb(int[] mibOid, int[] curOid, int[] firstIndex, SnmpVarBind vb) {
        if (SnmpOID.equals(mibOid, _CfsFeatureRegionId)) {
            vb.setOid(new SnmpOID(mibOid, firstIndex));
            vb.setVar(new SnmpCfsRegion(0L));
        } else {
            super.repairVb(mibOid, curOid, firstIndex, vb);
        }
    }

    @Override
    public boolean isCellActive(int row, int col) {
        Object o = null;
        MibEnum enaction = (MibEnum)this.getValueAt(row, 4);
        MibEnum action = (MibEnum)this.getValueAt(row, 7);
        MibEnum global = (MibEnum)this.getValueAt(row, 6);
        String opStatus = (String)this.getValueAt(row, 5);
        String mergeStatus = (String)this.getValueAt(row, 13);
        boolean master = false;
        if (!(this.getValueAt(row, 14) instanceof Boolean)) {
            if (SnmpSession.isTrace()) {
                DefaultLogger._DefLogger.debug((Object)("master column non Boolean r/c " + row + '/' + col + '-' + this.getValueAt(row, 0)));
            }
        } else {
            master = (Boolean)this.getValueAt(row, 14) == Boolean.TRUE;
        }
        switch (col) {
            case 4: {
                return action.getValue() == 1;
            }
            case 7: {
                return opStatus.equals("enabled") && enaction.getValue() == 1 && (master || !master && mergeStatus.equals("failed"));
            }
            case 8: {
                return opStatus.equals("enabled") && (master || !master && mergeStatus.equals("failed"));
            }
            case 14: {
                boolean newIsMaster;
                boolean bl = newIsMaster = opStatus.equals("enabled") && !global.getLabel().startsWith("disable");
                if (master && !newIsMaster) {
                    this._masterSelected = false;
                    this.selectMaster(this.getWrkingPeers());
                    Object[] rows = (Object[])this.getData().elementAt(row);
                    rows[14] = Boolean.FALSE;
                }
                return newIsMaster;
            }
            case 2: 
            case 3: {
                if ((action.getLabel().equals("enable") || action.getLabel().equals("disable")) && this._vsanId == 0) {
                    return false;
                }
                if (col == 3) {
                    o = this.getValueAt(row, 2);
                    return o != null && ((JnmMibEnum)o).getValue() == 2;
                }
            }
            case 6: {
                o = (JnmMibEnum)this.getValueAt(row, 6);
                return !((MibEnum)o).getLabel().startsWith("n/a");
            }
            case 17: {
                SnmpPeer peer = (SnmpPeer)this.getValueAt(row, 0);
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                return sw.isVersionGreaterThanEqual("3.2(0)");
            }
        }
        return super.isCellActive(row, col);
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        if (col == 7) {
            String action = ((MibEnum)aValue).getLabel();
            if (action.startsWith("commit") || action.startsWith("abort") || action.startsWith("clear")) {
                int value = 1;
                Object[] rows = (Object[])this.getData().elementAt(row);
                this.setValueAt(new JnmMibEnum(_cfsFeatureOpShowCfgOptionEnum[value - 1].getLabel(), value, _cfsFeatureOpShowCfgOptionEnum), row, 8);
            } else if (action.equals("enable") && this._vsanId != 0) {
                Object[] rows = (Object[])this.getData().elementAt(row);
                this.setValueAt(new JnmMibEnum(_cfsFeatureOpScopeTypeEnum[1].getLabel(), 2, _cfsFeatureOpScopeTypeEnum), row, 2);
                new SnmpLongList(Integer.toString(this._vsanId));
                this.setValueAt(new SnmpLongList(Integer.toString(this._vsanId)), row, 3);
            }
        } else if (col == 14) {
            if (!isProcessMasterCol) {
                boolean isMaster;
                boolean bl = isMaster = (Boolean)aValue == Boolean.TRUE;
                if (isMaster) {
                    isProcessMasterCol = true;
                    Array data = this.getData();
                    int total = data.size();
                    for (int i = 0; i < total; ++i) {
                        Object[] rowData = (Object[])data.elementAt(i);
                        if ((Boolean)rowData[14] != Boolean.TRUE) continue;
                        this.setValueAt(Boolean.FALSE, i, col);
                    }
                    isProcessMasterCol = false;
                } else {
                    aValue = Boolean.TRUE;
                }
            }
        } else if (col == 17 && aValue instanceof String && ((aValue = ((String)aValue).trim()).equals("") || aValue.equals("default") || aValue.equals("(default)"))) {
            aValue = "0";
        }
        super.setValueAt(aValue, row, col);
    }

    @Override
    protected void assignCellValueSameClass(Object aValue, int row, int col, Object[] values) {
        if (col == 3) {
            byte[] b = ((SnmpLongList)aValue).getValue();
            if (b.length > 4) {
                String msg = "(row=" + (row + 1) + ",col=" + (col + 1) + ")  Bad assignment: not a list";
                Util.errorMessage((Component)BrowserFrame.getInstance(), msg);
            } else {
                super.assignCellValueSameClass(aValue, row, col, values);
            }
        } else {
            super.assignCellValueSameClass(aValue, row, col, values);
        }
    }

    @Override
    public int applyChangesSet(HashMap pdus, SnmpAggregrateIf applyChangesCallback) throws Exception {
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        if (this._peers2CfsRegionCreation != null && this._peers2CfsRegionCreation.size() > 0) {
            aggregrate.set(this._peers2CfsRegionCreation.keySet().iterator(), this._peers2CfsRegionCreation.values().iterator(), this._peers2CfsRegionCreation.values().iterator(), applyChangesCallback, this._fragPduOnByte);
        }
        return super.applyChangesSet(pdus, applyChangesCallback);
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        if (cell._col == 17) {
            SnmpVar changedCellVar = this.getChangedCell(cell._row, cell._col);
            long newRegion = ((SnmpGauge)changedCellVar).getValue();
            Object[] values = (Object[])this.getData().elementAt(cell._row);
            Object[] oldVals = (Object[])values[this.getHeaders().length];
            long oldRegion = ((SnmpGauge)oldVals[17]).getValue();
            if (oldRegion != newRegion) {
                if (newRegion != 0L) {
                    this.addRegionCreationPdu(this._peers2CfsRegionCreation, cell, newRegion);
                    if (oldRegion == 0L) {
                        pdu.addVar(new SnmpOID(_CfsFeatureRegionStatusOid, index), new SnmpInt(4));
                    }
                    return super.processChangedCell(cell, pdu, changedCellOid, index);
                }
                if (oldRegion != 0L) {
                    changedCellVar = new SnmpInt(6);
                    pdu.addVar(new SnmpOID(_CfsFeatureRegionStatusOid, index), changedCellVar);
                    return changedCellVar;
                }
                return super.processChangedCell(cell, pdu, changedCellOid, index);
            }
            return null;
        }
        return super.processChangedCell(cell, pdu, changedCellOid, index);
    }

    @Override
    protected void addChangedCells2Pdu(HashMap pdus, Array cells, Array warningMsg) throws Exception {
        int preRow = -1;
        boolean setType = false;
        boolean setVSAN = false;
        for (int i = cells.size() - 1; i >= 0; --i) {
            Cell cell = (Cell)cells.elementAt(i);
            this.addCell2Pdu(pdus, cells, cell, warningMsg);
            if (cell._row != preRow) {
                setVSAN = false;
                setType = false;
            }
            boolean bl = setType ? setType : (setType = cell._col == 2);
            setVSAN = setVSAN ? setVSAN : cell._col == 3;
            SnmpPeer node = this.getRowPeer(cell._row);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) continue;
            if (cell._col == 7) {
                SnmpOID oid;
                int[] index = this.getCellSetIndex(cell);
                if (!setType) {
                    oid = new SnmpOID(this._mibNodes[2].getOid(), index);
                    pdu.addVar(oid, this._vsanId == 0 ? this.getChangedCell(cell._row, 2) : new SnmpInt(2));
                }
                if (!setVSAN) {
                    oid = new SnmpOID(this._mibNodes[3].getOid(), index);
                    pdu.addVar(oid, this._vsanId == 0 ? this.getChangedCell(cell._row, 3) : new SnmpString(SnmpIntList.valueOf(new int[]{this._vsanId})));
                }
                if (this._isCheckCommit) {
                    Object action = this.getValueAt(cell._row, cell._col);
                    Object merge = this.getValueAt(cell._row, 13);
                    if (action instanceof MibEnum && ((MibEnum)action).getValue() == 4 && merge instanceof String && ((String)merge).equals(MibEnum.getLabel(_cfsMergeStatusValueEnum, 3))) {
                        warningMsg.addElement(this._checkCommitWarnMsg);
                    }
                }
            }
            preRow = cell._row;
        }
    }

    private void addRegionCreationPdu(HashMap pdus, Cell cell, long newRegion) throws Exception {
        SnmpPeer node = this.getRowPeer(cell._row);
        SnmpPDU pdu = (SnmpPDU)pdus.get(node);
        if (pdu == null) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.setAddress(node.getAddress());
            pdus.put(node, pdu);
        }
        int[] index = new int[]{1, (int)newRegion};
        pdu.addVar(new SnmpOID(_CfsRegionStatusOid, index), new SnmpInt(4));
    }

    @Override
    protected String getEditTitle(SnmpKTable table) {
        return "CFS";
    }

    @Override
    protected boolean enableApplyOnChange(boolean requestToEnable, TableModelEvent e) {
        int col = e.getColumn();
        return requestToEnable && col != 14;
    }

    public void diff() throws Exception {
        if (BrowserFrame.getTable().getSelectedRow() == -1) {
            return;
        }
        Object[] row = (Object[])this.getData().elementAt(BrowserFrame.getTable().getSelectedRow());
        SnmpPeer peer = (SnmpPeer)row[0];
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        try {
            String cliCommand = this.getFeatureNameAtSwitch(peer);
            for (int i = 0; i < this._custom_CLIcmd_Features.length; ++i) {
                if (!this._custom_CLIcmd_Features[i].equals(this._featureName)) continue;
                cliCommand = sw.isVersionGreaterThanEqual("3.0(0)") ? this._custom_CLIcmd[i] : this._custom_CLIcmd_2x[i];
                break;
            }
            String[] cmd = new String[]{"show " + cliCommand + " pending-diff\n"};
            if (SnmpSession.isTrace()) {
                DefaultLogger._DefLogger.debug((Object)("Command :" + cmd[0]));
            }
            VshDump dlg = new VshDump(BrowserFrame.getInstance(), peer + " Show " + cliCommand + " pending-diff", cmd, peer);
            dlg.setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Fail to display CFS pending-diff Details");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof KTable && e.getClickCount() > 1) {
            Point p = e.getPoint();
            KTable t = (KTable)e.getSource();
            int r = t.rowAtPoint(p);
            int c = t.columnAtPoint(p);
            int model = BrowserFrame.getDataView()._table.convertColumnIndexToModel(c);
            if (model == 13) {
                Array data = this.getData();
                Object[] row = (Object[])data.elementAt(r);
                SnmpPeer peer = (SnmpPeer)row[0];
                String strMergeStatus = (String)row[13];
                if (strMergeStatus != null) {
                    try {
                        String[] cmd = new String[]{"show cfs merge status name " + this.getFeatureNameAtSwitch(peer) + "\n"};
                        if (SnmpSession.isTrace()) {
                            DefaultLogger._DefLogger.debug((Object)("Command :" + cmd[0]));
                        }
                        VshDump dlg = new VshDump(BrowserFrame.getInstance(), "CFS: Merge Failure Details", cmd, peer);
                        dlg.setVisible(true);
                    }
                    catch (Exception ex) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "Fail to display Merge Failure Details");
                    }
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public String getProgressStatus() {
        return "All fabric switches participate in CFS; " + super.getProgressStatus();
    }

    static class FeatureAction {
        SnmpOID _feature;
        int _action;

        public FeatureAction(SnmpOID feature, int action) {
            this._feature = feature;
            this._action = action;
        }

        public SnmpOID getFeature() {
            return this._feature;
        }

        public int getAction() {
            return this._action;
        }
    }
}

