/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpDateAndTime;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.gui.SmTableModel;

public class SmClockDateTimeZoneModel
extends SmTableModel {
    static final int DATETIME_COL = 1;
    static final int TIMEZONE_COL = 2;

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        if (col == 1) {
            SnmpDateAndTime v = (SnmpDateAndTime)super.toCell(mibNode, vb.getVar(), var, row);
            byte[] b = v.getValue();
            byte[] n = new byte[8];
            for (int j = 0; j < b.length && j < 8; ++j) {
                n[j] = b[j];
            }
            SnmpDateAndTime timeZone = new SnmpDateAndTime(n);
            return super.toCell(mibNode, timeZone, var, row);
        }
        if (col == 2) {
            SnmpDateAndTime v = (SnmpDateAndTime)super.toCell(mibNode, vb.getVar(), var, row);
            byte[] b = v.getValue();
            for (int j = 0; j < b.length && j < 8; ++j) {
                b[j] = 0;
            }
            SnmpDateAndTime timeZone = new SnmpDateAndTime(b);
            return super.toCell(mibNode, timeZone, var, row);
        }
        return super.toCell(mibNode, vb.getVar(), var, row);
    }

    @Override
    protected SnmpVar getChangedCell(int row, int col, MibNode[] mibNodes) throws Exception {
        SnmpVar r = super.getChangedCell(row, col, mibNodes);
        if (col == 1) {
            SnmpVar d = super.getChangedCell(row, 2, mibNodes);
            byte[] date = ((SnmpString)r).getValue();
            byte[] timezone = ((SnmpString)d).getValue();
            if (timezone.length > 8) {
                byte[] n = new byte[11];
                for (int j = 0; j < 11; ++j) {
                    n[j] = j < 8 ? date[j] : timezone[j];
                }
                r = new SnmpDateAndTime(n);
            }
        }
        return r;
    }
}

