/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Vlan;
import com.cisco.dcbu.sm.common.model.EthPortBase;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SmEthInterfaceTableModel
extends SmTableModel {
    AbstractSwitch _sw = null;
    String[] _labels = new String[]{"Switch", "Interface", "Shared Mode", "Description", "Oper Speed", "Admin Status", "Oper Status", "Last Change", "SwitchObj"};
    public static HashMap<Integer, String> AdminStatus = new HashMap();
    public static HashMap<Integer, String> OperStatus = new HashMap();
    static final int SWITCHOBJ = 8;
    public static final int STATUS_COL = 6;

    public SmEthInterfaceTableModel() {
        AdminStatus.put(1, "up");
        AdminStatus.put(2, "down");
        AdminStatus.put(3, "testing");
        OperStatus.put(1, "up");
        OperStatus.put(2, "down");
        OperStatus.put(3, "testing");
        OperStatus.put(4, "unknown");
        OperStatus.put(5, "dormant");
        OperStatus.put(6, "notPresent");
        OperStatus.put(7, "lowerLayerDown");
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, 4);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        String[] headers = new String[this._labels.length];
        this._prefixes = prefixes;
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = this._labels[i];
        }
        this.setHeaders(headers);
        this.setData(new Array());
        this._isEditable = false;
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        return this.getTableData();
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        return this.getTableData();
    }

    protected Array getTableData() {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        List<EthPortBase> ports = this.getEthPorts(mgmtDomain);
        this._responseData = this.addPortInfo(ports);
        return this._responseData;
    }

    protected List<EthPortBase> getEthPorts(MgmtDomainIf mgmtDomain) {
        HashedArrayList<EthPortBase> data = new HashedArrayList<EthPortBase>();
        EthSwitch[] sws = new EthSwitch[]{};
        if (mgmtDomain.isLAN()) {
            sws = ((Lan)mgmtDomain).getEthSwitches();
        } else if (mgmtDomain.isVlan()) {
            sws = ((Vlan)mgmtDomain).getEthSwitches();
        }
        for (EthSwitch sw : sws) {
            Collection<EthPortBase> ports = sw.getAllPorts();
            data.addAll(ports);
        }
        return data;
    }

    protected Array addPortInfo(List<EthPortBase> ports) {
        Array<Object[]> data = new Array<Object[]>();
        for (EthPortBase port : ports) {
            Integer operStatus;
            if (port.isChannel() || port.getIfType() != 6) continue;
            Object[] row = new Object[this._labels.length];
            EthSwitch sw = (EthSwitch)Lan.getInstance().findSwitchByPK(port.getSwitchPK());
            row[0] = sw.getName();
            row[1] = sw.ifIndexToName(port.getIfIndex());
            row[2] = SharedMode.getValue(port.getSharedMode());
            row[3] = port.getIfAlias();
            long speed = port.getIfSpeed();
            row[4] = speed == -1L ? "n/a" : MibVariableFormat.speedBasic(port.getIfSpeed());
            Integer adminStatus = port.getIfAdminStatus();
            if (AdminStatus.containsKey(adminStatus)) {
                row[5] = AdminStatus.get(adminStatus);
            }
            if ((operStatus = Integer.valueOf(port.getIfOperMode())) < 3 && operStatus != adminStatus) {
                row[6] = "failure";
            } else if (OperStatus.containsKey(operStatus)) {
                row[6] = OperStatus.get(operStatus);
            }
            SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
            row[7] = f.format(new Date(port.getLastScanTime()));
            row[8] = sw;
            data.addElement(row);
        }
        return data;
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[8];
    }

    static enum SharedMode {
        Unknown(1),
        Dedicated(2),
        SharedOwner(3),
        SharedOnly(4);

        private int mode;

        private SharedMode(int m) {
            this.mode = m;
        }

        public static String getValue(int m) {
            if (m > 0 && m < SharedMode.values().length) {
                return SharedMode.values()[m - 1].name();
            }
            return "n/a";
        }
    }
}

