/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.HashMap;

public class SmEthPortChannelTableModel
extends SmTableModel
implements SnmpCallbackIf {
    public static final int MEMBERLIST_COL = 1;
    HashMap<SnmpPeer, HashMap<Integer, Integer>> _peer2IfIndices2row = new HashMap();

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._index = IfIndexUtil.getFirstValidIfIndexFor(22) - 1;
        this._stopIndex = IfIndexUtil.getLastValidIfIndexFor(22) + 1;
        this._peer2IfIndices2row.clear();
        Array data = super.getTableVars(nodes);
        if (this._peer2IfIndices2row.size() != 0) {
            this.getMemberList();
        }
        return data;
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        int[] oid = vb.getOid().getValue();
        int rowIfindex = index.getValue()[0];
        int mibNodeIndexWithoutOffset = col - this._offset;
        if (mibNodeIndexWithoutOffset == 1) {
            if (SnmpOID.startsWith(oid, mibNode.getOid()) && oid[oid.length - 1] == rowIfindex) {
                int[] childIfindexes = IfIndexUtil.dot1Indexes2IfIndexes(vb.byteValue());
                return SnmpIntList.toString(childIfindexes, MibVariableFormat._IfIndexIf, false);
            }
            return "n/a";
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMemberList() throws SnmpException {
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : this._peer2IfIndices2row.keySet()) {
                if (this._timedoutPeers.find(peer) != -1) continue;
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                boolean is6dot2_8 = sw.isVersionGreaterThanEqual("6.2(8)");
                HashMap<Integer, Integer> info2Row = this._peer2IfIndices2row.get(peer);
                VarBindList vbl = new VarBindList();
                for (Integer ifIndexObj : info2Row.keySet()) {
                    vbl.add(is6dot2_8 ? MibNode.get("clagAggPortListInterfaceIndexList").getOid() : MibNode.get("clagAggPortListPorts").getOid(), ifIndexObj);
                }
                if (vbl.size() == 0) continue;
                SnmpFetch f = new SnmpFetch();
                f.get(peer, vbl, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        HashMap<Integer, Integer> info2Row = this._peer2IfIndices2row.get(node);
        if (info2Row == null) {
            info2Row = new HashMap();
        }
        int ifIndex = index.getValue()[0];
        info2Row.put(new Integer(ifIndex), new Integer(this._responseData.size() - 1));
        this._peer2IfIndices2row.put(node, info2Row);
        return row;
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean is6dot2_8 = sw.isVersionGreaterThanEqual("6.2(8)");
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            int[] membersOID;
            SnmpOID firstOid = pdu.getVariables().getVb(0).getOid();
            int[] nArray = membersOID = is6dot2_8 ? MibNode.get("clagAggPortListInterfaceIndexList").getOid() : MibNode.get("clagAggPortListPorts").getOid();
            if (!firstOid.startsWith(membersOID)) {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
            this.processMemberVarsData(node, pdu.getVariables());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMemberVarsData(SnmpPeer node, VarBindList vbl) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean is6dot2_8 = sw.isVersionGreaterThanEqual("6.2(8)");
        HashMap<Integer, Integer> info2Row = this._peer2IfIndices2row.get(node);
        if (info2Row == null) {
            return;
        }
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind v = vbl.getVb(i);
            if (v.isNull()) continue;
            int ifIndex = v.getIndex();
            int rowIndex = info2Row.get(ifIndex);
            Object[] row = (Object[])this.getData().elementAt(rowIndex);
            int[] childIfindexes = is6dot2_8 ? IfIndexUtil.interfaceIndexList2ifIndexes(v.byteValue()) : IfIndexUtil.dot1Indexes2IfIndexes(v.byteValue());
            row[1 + this._offset] = SnmpIntList.toString(childIfindexes, MibVariableFormat._IfIndexIf, false);
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                SyncedInt i = this._numOutstanding;
                synchronized (i) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }
}

