/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Switch;
import javax.swing.JOptionPane;

public class SmFCoEConfigTableModel
extends SmTableModel {
    public static int FC_MAP_IDX = 2;

    @Override
    protected boolean isModelTypeSupported(SnmpPeer peer) {
        boolean supported = super.isModelTypeSupported(peer);
        if (supported) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            supported = sw.getSwitchBase().isFCoEEnabled();
            if (sw.isN5K() && !sw.isVersionGreaterThanEqual("4.0(1a)")) {
                supported = false;
            }
        }
        return supported;
    }

    @Override
    public Array getTableVars(MgmtDomainIf mgmtDomain, boolean isScalar) throws SnmpException {
        Array array = super.getTableVars(mgmtDomain, isScalar);
        this.validateFcMAP();
        return array;
    }

    @Override
    public boolean applyChanges() throws Exception {
        this.validateFcMAP();
        return super.applyChanges();
    }

    protected boolean validateFcMAP() {
        Array data = this.getData();
        int count = data.size();
        if (count > 1) {
            String s = ((Object[])data.elementAt(0))[FC_MAP_IDX].toString();
            for (int i = 1; i < count; ++i) {
                if (s.equals(((Object[])data.elementAt(i))[FC_MAP_IDX].toString())) continue;
                JOptionPane.showMessageDialog(null, "The switches listed above have different FC MAP values. It is recommended that all the switches have the same FC MAP values.", "Warning", 2);
                break;
            }
        }
        return true;
    }
}

