/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntHashMap;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmCfsUtil;
import com.cisco.dcbu.sm.client.gui.SmFeatureCtrlUtil;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;

public class SmFeatureSetTableModel
extends SmTableModel
implements ActionListener {
    HashMap _peers2RowInfo;
    HashMap _peers2RowsGetStatus;
    Array _actionChangedCells;
    protected Timer _statusTimer;
    int[][] _ownerIndices;
    HashMap _peers2indicesStep;
    IntHashMap _featureCtrl2CfsCtrl;
    static final int OP_STATUS_COL = 3;
    static final int ACTION_COL = 4;
    static final int LASTACTION_COL = 5;
    static final int ACTION_STATUS_COL = 6;
    static final int FAILURE_REASON_COL = 7;
    static final int[] _cfcFeatureSetActionOid = MibNode.get("cfcFeatureSetAction").getOid();
    static final int STATUS_POLLING_MIB_SIZE = 3;
    static final int[] _cfcFeatureSetLastActionResultOid = MibNode.get("cfcFeatureSetLastActionResult").getOid();
    static final int[] _cfcFeatureSetLastFailureReasonOid = MibNode.get("cfcFeatureSetLastFailureReason").getOid();
    static final int[] _cfcFeatureSetOpStatusOid = MibNode.get("cfcFeatureSetOpStatus").getOid();
    public static final int[] FCOE_SET_INDEX = new int[]{1};
    static final int DISABLE_FEATURE = 3;
    static final int ENABLE_FEATURE = 2;
    static final int FEATURE_ENABLED = 2;
    static final int ACTION_RESULT_INPROGRESS = 4;

    public SmFeatureSetTableModel(int[][] ownerIndices, int pollingInterval) {
        this._ownerIndices = ownerIndices;
        this._peers2RowInfo = new HashMap();
        this._statusTimer = new Timer(pollingInterval, this);
        this._peers2RowsGetStatus = new HashMap();
        this._actionChangedCells = new Array();
        this._peers2indicesStep = new HashMap();
        this._featureCtrl2CfsCtrl = new IntHashMap();
    }

    public SmFeatureSetTableModel(int[][] ownerIndices) {
        this(ownerIndices, 5000);
    }

    public void setCfsCtrlIndex(String cfsCtrlIndex) {
        for (int i = 0; i < this._ownerIndices.length; ++i) {
            this._featureCtrl2CfsCtrl.put(this._ownerIndices[i][0], cfsCtrlIndex);
        }
    }

    @Override
    protected void setSpecialAttr() {
        SmTableModel.SmTableModelCellChecker[] checkers = new SmTableModel.SmTableModelCellChecker[1];
        String mibName = "cfcFeatureSetAction";
        int[] value = new int[]{3};
        String warningMsgVsanId = "Disabling the feature will remove its configuration. Continue?";
        checkers[0] = new SmTableModel.SmTableModelCellChecker(this, mibName, value, warningMsgVsanId, false);
        this.setCellChecker(checkers);
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        return super.getTableVars(mgmtDomain);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        int i;
        for (i = 0; i < this._ownerIndices.length; ++i) {
            SmFeatureCtrlUtil.getInstance().clearPeer(this._ownerIndices[i][0]);
        }
        this._responseData = new Array();
        if (nodes == null || nodes.length == 0) {
            return this._responseData;
        }
        this._peers2indicesStep.clear();
        for (i = 0; i < nodes.length; ++i) {
            this._peers2indicesStep.put(nodes[i], new Integer(0));
        }
        this._index = this._ownerIndices[0][0] - 1;
        return super.getTableVars(nodes);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        HashMap<String, Integer> index2RowN;
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        String failureReason = row[7].toString();
        if (failureReason != null && !failureReason.trim().equals("")) {
            row[6] = row[6].toString() + " - " + failureReason;
        }
        if ((index2RowN = (HashMap<String, Integer>)this._peers2RowInfo.get(node)) == null) {
            index2RowN = new HashMap<String, Integer>();
            this._peers2RowInfo.put(node, index2RowN);
        }
        int[] indexOid = index.getValue();
        String featureName = SnmpString.toString(indexOid, 0, indexOid.length);
        index2RowN.put(featureName, new Integer(this._responseData.size() - 1));
        if (vbl.intValue(3 - this._offset) == 2) {
            SmFeatureCtrlUtil.getInstance().addPeer(indexOid[0], node);
        }
        return row;
    }

    @Override
    public boolean applyChanges() throws Exception {
        if (this._peers2RowsGetStatus.size() != 0) {
            return false;
        }
        Array cells = super.getChanged();
        if (cells == null) {
            return false;
        }
        this._peers2RowsGetStatus.clear();
        this._actionChangedCells.clear();
        boolean rtnVal = super.applyChanges(this);
        if (rtnVal && this._peers2RowsGetStatus.size() != 0) {
            this._statusTimer.start();
        }
        return rtnVal;
    }

    @Override
    protected Array getChangeCells() {
        if (this._actionChangedCells.size() == 0) {
            return super.getChangeCells();
        }
        return this._actionChangedCells;
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        Array cells;
        HashMap pdus = super.buildSendPdus();
        if (pdus != null && (cells = super.getChanged()) != null) {
            for (int i = 0; i < cells.size(); ++i) {
                Cell cell = (Cell)cells.elementAt(i);
                this.setValueAt("inProgress", cell._row, 6);
                this._actionChangedCells.addElement(new Cell(cell._row, 4));
            }
            this.fireTableDataChanged();
        }
        return pdus;
    }

    void updatePeers2RowInfo() {
        this._peers2RowInfo.clear();
        Array data = this.getData();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            SnmpPeer node = (SnmpPeer)row[0];
            HashMap<String, Integer> index2RowN = (HashMap<String, Integer>)this._peers2RowInfo.get(node);
            if (index2RowN == null) {
                index2RowN = new HashMap<String, Integer>();
                this._peers2RowInfo.put(node, index2RowN);
            }
            int[] indexOid = ((SnmpOID)row[1]).getValue();
            String featureName = SnmpString.toString(indexOid, 0, indexOid.length);
            index2RowN.put(featureName, new Integer(i));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._peers2RowsGetStatus.size() != 0) {
                this.pollSwitches();
                return;
            }
            this._statusTimer.stop();
            this.resetChanges(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSwitches() {
        this._state = 1;
        boolean requestSent = false;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        Object object = this._peers2RowsGetStatus;
        synchronized (object) {
            for (SnmpPeer peer : this._peers2RowsGetStatus.keySet()) {
                Array rowIndices = (Array)this._peers2RowsGetStatus.get(peer);
                if (rowIndices == null) continue;
                VarBindList vbl = new VarBindList();
                for (int i = 0; i < rowIndices.size(); ++i) {
                    int[] index = ((SnmpOID)rowIndices.elementAt(i)).getValue();
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfcFeatureSetLastActionResultOid, index)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfcFeatureSetLastFailureReasonOid, index)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cfcFeatureSetOpStatusOid, index)));
                }
                peers2Vbl.put(peer, vbl);
            }
        }
        this._numOutstanding.set(0);
        object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                VarBindList vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpPDU pdu = new SnmpPDU(-96, vbl);
                pdu.setRetries(0);
                try {
                    peer.send(pdu, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object vbl;
        if (this._state == 2) {
            super.callback(session, reqid, pdu, timedOut);
            return;
        }
        if (this._state == 5) {
            return;
        }
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(peer, pdu, timedOut) && pdu.getVariables().size() > 0) {
            vbl = pdu.getVariables();
            for (int i = 0; i < ((VarBindList)vbl).size(); i += 3) {
                SnmpVarBind vb = ((VarBindList)vbl).getVb(i);
                int actionResult = ((VarBindList)vbl).intValue(i);
                int[] oid = vb.getOid().getValue();
                SnmpOID index = new SnmpOID(oid, _cfcFeatureSetLastActionResultOid.length, oid.length - _cfcFeatureSetLastActionResultOid.length);
                HashMap index2RowN = (HashMap)this._peers2RowInfo.get(peer);
                if (index2RowN != null) {
                    int[] indexOid = index.getValue();
                    String featureName = SnmpString.toString(indexOid, 0, indexOid.length);
                    int rowN = (Integer)index2RowN.get(featureName);
                    Object[] row = (Object[])this.getData().elementAt(rowN);
                    String strLastActionResult = MibEnum.getLabel(MibNode.get("cfcFeatureSetLastActionResult").getEnums(), actionResult);
                    String failureReason = ((VarBindList)vbl).stringValue(i + 1);
                    row[6] = strLastActionResult + (failureReason != null && !failureReason.equals("") ? " - " + failureReason : "");
                    row[3] = MibEnum.getLabel(MibNode.get("cfcFeatureSetOpStatus").getEnums(), ((VarBindList)vbl).intValue(i + 2));
                    BrowserFrame.getInstance();
                    BrowserFrame.getDataView()._table.calcPreferredSize();
                }
                if (actionResult == 4) continue;
                if (((VarBindList)vbl).intValue(i + 2) == 2) {
                    SmFeatureCtrlUtil.getInstance().addPeer(index.getValue()[0], peer);
                } else {
                    SmFeatureCtrlUtil.getInstance().removePeer(index.getValue()[0], peer);
                    int featureIndex = index.getValue()[0];
                    String cfsCtrlIndex = (String)this._featureCtrl2CfsCtrl.get(featureIndex);
                    if (cfsCtrlIndex != null) {
                        MgmtDomainIf mgmtDomain;
                        SnmpPeer cfsMaster = SmCfsUtil.getInstance().getMaster(cfsCtrlIndex);
                        if (cfsMaster == null && (mgmtDomain = ClientController.getInstance().getSelectedDomain()) instanceof Vsan) {
                            cfsCtrlIndex = cfsCtrlIndex + Integer.toString(mgmtDomain.getVsanId());
                            cfsMaster = SmCfsUtil.getInstance().getMaster(cfsCtrlIndex);
                        }
                        if (cfsMaster != null && cfsMaster.getAddress().equals(peer.getAddress())) {
                            SmCfsUtil.getInstance().removeMaster(cfsCtrlIndex);
                        }
                    }
                }
                Array rowIndices = (Array)this._peers2RowsGetStatus.get(peer);
                if (rowIndices == null) continue;
                for (int j = rowIndices.size() - 1; j >= 0; --j) {
                    SnmpOID rowIndex = (SnmpOID)rowIndices.elementAt(j);
                    if (!SnmpOID.equals(rowIndex.getValue(), index.getValue())) continue;
                    rowIndices.removeElementAt(j);
                    break;
                }
                HashMap hashMap = this._peers2RowsGetStatus;
                synchronized (hashMap) {
                    if (rowIndices.size() == 0) {
                        this._peers2RowsGetStatus.remove(peer);
                    }
                    continue;
                }
            }
        } else {
            vbl = this._peers2RowsGetStatus;
            synchronized (vbl) {
                this._peers2RowsGetStatus.remove(peer);
            }
        }
        this.fireTableDataChanged();
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                vbl = this._numOutstanding;
                synchronized (vbl) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
    }

    @Override
    protected boolean prepareGetNextPdu(SnmpPeer peer, VarBindList vbl) {
        Integer indicesStepObj = (Integer)this._peers2indicesStep.get(peer);
        if (indicesStepObj == null) {
            return false;
        }
        int indicesStep = indicesStepObj;
        if (indicesStep == this._ownerIndices.length - 1) {
            return false;
        }
        this._peers2indicesStep.put(peer, new Integer(++indicesStep));
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            vb.setVar(null);
            int[] mibOid = this._mibNodes[i + this._offset].getOid();
            vb.setOid(new SnmpOID(mibOid, this._ownerIndices[indicesStep][0] - 1));
        }
        return true;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 4) {
            return false;
        }
        return super.isCellEditable(row, col);
    }

    @Override
    protected boolean isSkip(SnmpPeer peer, int[] req, SnmpVarBind firstVb, int[] index, VarBindList vbl, int reqId) {
        for (int i = 0; i < this._ownerIndices.length; ++i) {
            if (index[0] != this._ownerIndices[i][0]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        if (err.length() != 0) {
            return;
        }
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        Array<SnmpOID> rowIndices = (Array<SnmpOID>)this._peers2RowsGetStatus.get(node);
        if (rowIndices == null) {
            rowIndices = new Array<SnmpOID>();
            HashMap hashMap = this._peers2RowsGetStatus;
            synchronized (hashMap) {
                this._peers2RowsGetStatus.put(node, rowIndices);
            }
        }
        VarBindList vbl = pdu.getVariables();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            SnmpOID index = new SnmpOID(oid, _cfcFeatureSetActionOid.length, oid.length - _cfcFeatureSetActionOid.length);
            rowIndices.addElement(index);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
    }

    @Override
    protected void performPostSorting() {
        this.updatePeers2RowInfo();
    }
}

