/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmFiconPortFileTableModel;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.model.SmFilter;
import java.util.HashMap;

public class SmFiconPortFileDiffTableModel
extends SmFiconPortFileTableModel {
    static final int[] _cficonRunCfgProhibitPrtNumsOid = MibNode.get("cficonRunCfgProhibitPrtNums").getOid();
    static final int[] _cficonPortRunCfgBlockOid = MibNode.get("cficonPortRunCfgBlock").getOid();
    HashMap _index2RowNoInfo = new HashMap();
    HashMap _prohibitPort2RowNoInfo = new HashMap();
    static final int BLOCK_VAR_POS = 1;
    static final int PROHIBIT_VAR_POS = 2;
    static final int BLOCK_COL = 3;
    static final int PROHIBIT_COL = 4;

    public SmFiconPortFileDiffTableModel(DataView view) {
        super(view);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        int[] key = new int[2];
        int[] oid = ((SnmpOID)row[1]).getValue();
        key[0] = oid[0];
        key[1] = oid[oid.length - 1];
        this._index2RowNoInfo.put(new SnmpOID(key), new Integer(this._responseData.size() - 1));
        this._prohibitPort2RowNoInfo.put(new SnmpOID(key), new SnmpVar[]{vbl.get(1).getVar(), vbl.get(2).getVar()});
        return row;
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        this._index2RowNoInfo.clear();
        this._prohibitPort2RowNoInfo.clear();
        Array result = super.getTableVars(invoker);
        if (this._openFileInvokers != null) {
            this.fetchRunningConfig(this._openFileInvokers);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchRunningConfig(Array invoker) {
        this._state = 1;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        for (int i = 0; i < invoker.size(); ++i) {
            SnmpPeer peer = ((SmFilter)invoker.elementAt(i)).getSnmpPeer();
            VarBindList vbl = new VarBindList();
            int[][] indices = ((SmFilter)invoker.elementAt(i)).getIndices();
            vbl.add(new SnmpVarBind(new SnmpOID(_cficonRunCfgProhibitPrtNumsOid, indices[0][0])));
            vbl.add(new SnmpVarBind(new SnmpOID(_cficonPortRunCfgBlockOid, indices[0][0])));
            peers2Vbl.put(peer, vbl);
        }
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                VarBindList vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpFetch f = new SnmpFetch();
                try {
                    f.getBulk(peer, vbl, (SnmpCallbackIf)this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    private void processRunningConfig(SnmpPeer peer, VarBindList vbl) {
        for (int i = 0; i < vbl.size(); i += 2) {
            int[] oid = vbl.get(i).getOid().getValue();
            SnmpVar prohibitPortsOnRunning = vbl.get(i).getVar();
            SnmpVar blockOnRunning = vbl.get(i + 1).getVar();
            int[] key = new int[2];
            System.arraycopy(oid, oid.length - 2, key, 0, 2);
            Object rowNo = this._index2RowNoInfo.get(new SnmpOID(key));
            SnmpVar[] vars = (SnmpVar[])this._prohibitPort2RowNoInfo.get(new SnmpOID(key));
            SnmpVar blockOnFile = vars[0];
            SnmpVar prohibitPortsOnFile = vars[1];
            if (prohibitPortsOnFile == null) continue;
            Object[] row = (Object[])this.getData().elementAt((Integer)rowNo);
            row[4] = this.diffProhibitPorts(prohibitPortsOnFile, prohibitPortsOnRunning);
            row[3] = ((SnmpInt)blockOnRunning).getValue() != ((SnmpInt)blockOnFile).getValue() ? "true" : "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object vbl;
        if (this._state == 5) {
            super.callback(session, reqid, pdu, timedOut);
            return;
        }
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(peer, pdu, timedOut) && pdu.getVariables().size() > 0) {
            if (this._state == 2) {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
            vbl = pdu.getVariables();
            if (SnmpOID.startsWith(((VarBindList)vbl).get(0).getOid().getValue(), _cficonRunCfgProhibitPrtNumsOid)) {
                this.processRunningConfig(peer, pdu.getVariables());
            }
        }
        this.fireTableDataChanged();
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                vbl = this._numOutstanding;
                synchronized (vbl) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wait(Object o) {
        try {
            Object object = o;
            synchronized (object) {
                o.wait(SnmpPeer._Timeout * (SnmpPeer._Retries + 1) + 15000);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    String diffProhibitPorts(SnmpVar prohibitPortsOnFile, SnmpVar prohibitPortsOnRunning) {
        int i;
        byte[] portsOnFile = ((SnmpString)prohibitPortsOnFile).getValue();
        byte[] portsOnRunnnig = ((SnmpString)prohibitPortsOnRunning).getValue();
        StringBuffer sb = new StringBuffer();
        int maxOnFile = portsOnFile.length * 8 - 1;
        int maxOnRunning = portsOnRunnnig.length * 8 - 1;
        for (i = 0; i <= maxOnFile && i <= maxOnRunning && !(SnmpString.getBitBase0(portsOnFile, i) ^ SnmpString.getBitBase0(portsOnRunnnig, i)); ++i) {
        }
        while (i <= maxOnFile && i <= maxOnRunning) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(Integer.toHexString(i));
            while (i <= maxOnFile && i <= maxOnRunning) {
                int j;
                for (j = i + 1; j <= maxOnFile && i <= maxOnRunning && SnmpString.getBitBase0(portsOnFile, j) ^ SnmpString.getBitBase0(portsOnRunnnig, j); ++j) {
                }
                if (j <= maxOnFile && i <= maxOnRunning && j > i + 1) {
                    sb.append('-');
                    sb.append(Integer.toHexString(j - 1));
                }
                for (i = j; i <= maxOnFile && i <= maxOnRunning && !(SnmpString.getBitBase0(portsOnFile, i) ^ SnmpString.getBitBase0(portsOnRunnnig, i)); ++i) {
                }
                if (i > maxOnFile || i > maxOnRunning) continue;
                sb.append(',');
                sb.append(Integer.toHexString(i));
            }
        }
        return sb.toString();
    }
}

