/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.FCIPDefaults;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SmInsertFCIPProfiles
extends InsertForm
implements ItemListener {
    static final int IP_ADDR = 1;
    static final int SEND_BUFSIZE = 8;
    static final int MAX_BANDWIDTH = 9;
    static final int MIN_BANDWIDTH = 10;
    static final int MAX_BANDWIDTH2 = 11;
    static final int MIN_BANDWIDTH2 = 12;
    static final int RDTRIPTIME_EST = 13;
    static final int PMTU_ENABLE = 14;
    static final int PMTU_RESET = 15;
    static final int CWM_ENABLE = 16;
    static final int CWM_BURSTSIZE = 17;
    int _idIndex;
    private FieldPanel _ipadrcmbx;
    private HashMap<SnmpPeer, HashMap<String, FCIPDefaults>> _peer2IpAddress;
    HashMap<String, FCIPDefaults> defaultsMap = new HashMap();

    public SmInsertFCIPProfiles(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
        this._idIndex = this.getVarIndex("cfmFcipEntityId");
        this._peer2IpAddress = new HashMap();
    }

    @Override
    public void build() throws Exception {
        super.build();
        ((JCheckBox)this._values[14]).addItemListener(this);
        ((JCheckBox)this._values[16]).addItemListener(this);
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this.updateInputFields();
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            KTextField tf = new KTextField(50);
            Dimension d = tf.getPreferredSize();
            tf.setColumns(0);
            tf.setPreferredSize(d);
            this._ipadrcmbx = new FieldPanel(tf, (JComponent)new IpAddressButton(null));
            tf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KTextField source = (KTextField)e.getSource();
                    SmInsertFCIPProfiles.this.setFCIPDefaults(source.getText());
                }
            });
            tf.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    KTextField source = (KTextField)e.getSource();
                    SmInsertFCIPProfiles.this.setFCIPDefaults(source.getText());
                }
            });
            return this._ipadrcmbx;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1 && ((FieldPanel)this._values[index]).getText().equals("")) {
            throw new Exception("Please provide IPAddress");
        }
        return super.getComponentValue(index);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 13) {
            return new JLabel("<html><div align=right>Estimated Round<br>Trip Time:</html>", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected = e.getStateChange() == 1;
        JComponent comp = (JComponent)e.getSource();
        if (comp == this._values[14]) {
            this.setEnabled(15, isSelected);
        } else if (comp == this._values[16]) {
            this.setEnabled(17, isSelected);
        }
    }

    @Override
    protected VarBindList buildInsertVarbind(int[] index, SnmpVar[] values) {
        VarBindList vbl = super.buildInsertVarbind(index, values);
        SnmpVarBind tcpPortVb = vbl.getVb(2);
        vbl.remove(2);
        vbl.add(1, tcpPortVb);
        return vbl;
    }

    @Override
    protected void insertAction() throws Exception {
        super.insertAction();
        int curIndex = Integer.parseInt(this.getComponentText(this._idIndex));
        this.updateFields(curIndex);
    }

    protected void updateFields(int curIndex) {
        int nextIndex = curIndex + 1;
        this.setComponentText(this._idIndex, Integer.toString(nextIndex));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this.updateInputFields();
                return;
            }
        }
        super.actionPerformed(e);
    }

    void updateInputFields() {
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isAbove20 = sw.isVersionGreaterThanEqual("2.0(0)");
        this.setEnabled(16, isAbove20);
        this.setEnabled(17, isAbove20);
        boolean isAbove21 = sw.isVersionGreaterThanEqual("2.1(0)");
        this.setComponentText(1, "");
        boolean isEqualOrAbove625 = sw.isVersionGreaterThanEqual("6.2(5)");
        this.setEnabled(8, !sw.isAlishan());
        this.setEnabled(9, !isEqualOrAbove625);
        this.setEnabled(10, !isEqualOrAbove625);
        this.setEnabled(11, isEqualOrAbove625);
        this.setEnabled(12, isEqualOrAbove625);
        this.setComponentVisibleAt(9, !isEqualOrAbove625);
        this.setComponentVisibleAt(10, !isEqualOrAbove625);
        this.setComponentVisibleAt(11, isEqualOrAbove625);
        this.setComponentVisibleAt(12, isEqualOrAbove625);
        this.setComponentText(11, "");
        this.setComponentText(12, "");
    }

    private void setFCIPDefaults(String ipAddress) {
        FCIPDefaults defaults = this.defaultsMap.get(ipAddress);
        if (defaults != null) {
            FCIPDefaults fcipDefault = defaults;
            this.setComponentText(11, (fcipDefault.getDefaultTCPmax() > 0 ? Integer.valueOf(fcipDefault.getDefaultTCPmax()) : "") + "");
            this.setComponentText(12, (fcipDefault.getDefaultTCPmin() > 0 ? Integer.valueOf(fcipDefault.getDefaultTCPmin()) : "") + "");
        } else {
            this.setComponentText(11, "");
            this.setComponentText(12, "");
        }
    }

    class IpAddressButton
    extends MenuButton {
        SnmpPeer _peer;

        public IpAddressButton(JMenu menu) {
            super(menu);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SnmpPeer selectedPeer = null;
            selectedPeer = SmInsertFCIPProfiles.this._choice != null ? (SnmpPeer)SmInsertFCIPProfiles.this._choice.getSelectedItem() : SmInsertFCIPProfiles.this._peers[0];
            if (selectedPeer != this._peer) {
                this._peer = selectedPeer;
                ClientController.getInstance();
                Switch sw = ClientController.findFabricSwitchByIpAddress(this._peer.getAddress());
                SmInsertFCIPProfiles.this.defaultsMap = (HashMap)SmInsertFCIPProfiles.this._peer2IpAddress.get(selectedPeer);
                if (SmInsertFCIPProfiles.this.defaultsMap == null) {
                    try {
                        SmInsertFCIPProfiles.this.defaultsMap = SharedUtil.getEthIpAddressFCIPDefaults(selectedPeer, sw);
                    }
                    catch (SnmpException ex) {
                        // empty catch block
                    }
                    if (SmInsertFCIPProfiles.this.defaultsMap != null) {
                        SmInsertFCIPProfiles.this._peer2IpAddress.put(selectedPeer, SmInsertFCIPProfiles.this.defaultsMap);
                    }
                }
                this.buildMenu(SmInsertFCIPProfiles.this.defaultsMap.keySet().toArray(new String[0]));
            }
            if (e.getSource() instanceof JMenuItem) {
                if (this.getParent() instanceof FieldPanel) {
                    ((FieldPanel)this.getParent()).setText(this._isSetText ? ((JMenuItem)e.getSource()).getText() : "");
                }
                if (this._isSetText) {
                    SmInsertFCIPProfiles.this.setFCIPDefaults(((JMenuItem)e.getSource()).getText());
                }
            } else if (this._menu != null) {
                if (this._menu.getItemCount() > 0) {
                    this._menu.getPopupMenu().show(this, 0, this.getHeight());
                } else {
                    JOptionPane.showMessageDialog(this, "No match", "Warning", 2);
                }
            }
        }
    }
}

