/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JLabel;

public class SmInsertIkePresharedKey
extends InsertForm {
    static final int DOI = 0;
    static final int INDEX = 1;
    static final int REMID_SEPERATPR = 2;
    static final int ID = 3;
    static final int TYPE = 4;
    static final int KEY = 5;
    public static final int DOI_IPSEC = 3;
    public static final int DOI_FCSP = 4;
    static final int TYPE_IPV4 = 0;
    static final int TYPE_DNS = 1;
    public static final int IKE_ID_TYPE_IPV4_VAL = 2;
    public static final int IKE_ID_TYPE_IPV6_VAL = 8;
    public static final int IKE_ID_TYPE_DNS_VAL = 3;
    public static final int IKE_ID_TYPE_WWN_VAL = 13;
    static final int[] _cicIkeCfgPskNextAvailIndexOid = MibNode.get("cicIkeCfgPskNextAvailIndex").getOid();
    HashMap _peer2NextAvIndex = new HashMap();
    int _doiSelection;
    int _type = 2;

    public SmInsertIkePresharedKey(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        RadioButtonPanel doiPanel = (RadioButtonPanel)this._values[0];
        for (int i = 0; i < doiPanel.getComponentCount(); ++i) {
            doiPanel.getButton(i).addActionListener(this);
            doiPanel.getButton(i).setActionCommand("doi");
        }
        this._labels[1].setVisible(false);
        this._values[1].setVisible(false);
        this._labels[0].setVisible(false);
        this._values[0].setVisible(false);
        this._labels[4].setVisible(false);
        this._values[4].setVisible(false);
        this._values[2].setVisible(false);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 4) {
            return new JLabel("Type:");
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            int selected = ((RadioButtonPanel)this._values[0]).getSelected();
            this._doiSelection = selected == 0 ? 3 : 4;
        } else {
            if (index == 1) {
                return null;
            }
            if (index == 3) {
                String id = this.getComponentText(index);
                try {
                    byte[] ipaddress = SnmpIpAddress.parse(this.getComponentText(index));
                    if (ipaddress.length == 4) {
                        this._type = 2;
                    } else if (ipaddress.length == 16) {
                        this._type = 8;
                    }
                    return new SnmpString(ipaddress);
                }
                catch (Exception ex) {
                    this._type = 3;
                    return super.getComponentValue(index);
                }
            }
            if (index == 4) {
                return new SnmpInt(this._type);
            }
        }
        return super.getComponentValue(index);
    }

    @Override
    protected void insert() throws Exception {
        this.insertInit();
        int selected = ((RadioButtonPanel)this._values[0]).getSelected();
        this._peer2NextAvIndex.clear();
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(_cicIkeCfgPskNextAvailIndexOid, selected == 0 ? 3 : 4)));
        this._pending = this._selPeerList.length;
        this._firstOid = _cicIkeCfgPskNextAvailIndexOid;
        for (int i = 0; i < this._selPeerList.length; ++i) {
            SnmpPDU pdu = new SnmpPDU(-96, vbl);
            ((SnmpPeer)this._selPeerList[i]).send(pdu, this);
        }
        this.wait(this._peers);
        this._insertValues = this.getInsertValue();
        this.insertRow(new VarBindList());
    }

    @Override
    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        SnmpGauge snmpIndexToUse = (SnmpGauge)this._peer2NextAvIndex.get(peer);
        if (snmpIndexToUse == null) {
            return null;
        }
        int indexToUse = (int)snmpIndexToUse.getValue();
        int[] index = new int[]{this._doiSelection, indexToUse};
        vbl = this.buildInsertVarbind(index, this._insertValues);
        return new SnmpPDU(-93, vbl);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        int[] oid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!timedOut && pdu.getError() == 0 && SnmpOID.startsWith(oid = pdu.getVariables().getVb(0).getOid().getValue(), _cicIkeCfgPskNextAvailIndexOid)) {
            SnmpPeer[] indexVar;
            VarBindList vbl = pdu.getVariables();
            SnmpVar indexVb = vbl.getVb(0).getVar();
            if (indexVb.getType() != 5) {
                indexVar = (SnmpPeer[])vbl.getVb(0).getVar();
                this._peer2NextAvIndex.put(node, indexVar);
            } else {
                this._insertErrMsg.addElement(node + ": " + "unable to get next available Index\n");
            }
            --this._pending;
            if (this._pending <= 0) {
                try {
                    indexVar = this._peers;
                    synchronized (this._peers) {
                        this._peers.notifyAll();
                        // ** MonitorExit[indexVar] (shouldn't be in output)
                    }
                }
                catch (IllegalMonitorStateException ex) {
                    DefaultLogger._DefLogger.error((Object)ex);
                }
            }
            {
                return;
            }
        }
        super.callback(session, reqid, pdu, timedOut);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("doi")) {
            char cmd = ((AbstractButton)e.getSource()).getText().charAt(0);
            RadioButtonPanel typePanel = (RadioButtonPanel)this._values[4];
            if (cmd == 'I') {
                typePanel.getButton(0).setEnabled(true);
                typePanel.getButton(0).setSelected(true);
                typePanel.getButton(1).setEnabled(true);
            } else {
                typePanel.getButton(0).setEnabled(false);
                typePanel.getButton(1).setEnabled(false);
            }
        } else {
            super.actionPerformed(e);
        }
    }
}

