/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.sm.client.dialogs.SmInsertIpAddress;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SmInsertRadiusServer
extends SmInsertIpAddress {
    static final int SERVERKEYTYPE = 4;
    static final int SERVERKEY = 5;
    static final String[] _serverKeyType = new String[]{"plaintext", "encrypted"};

    public SmInsertRadiusServer(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
        this._addrTypeVar = "crRadiusServerAddrType";
        this._insertRowCallback = null;
    }

    @Override
    protected void insert() throws Exception {
        super.insert();
        BrowserFrame.getDataView().refresh();
    }

    @Override
    protected void build() throws Exception {
        super.build();
        ((RadioButtonPanel)this.getComponentAt(4)).setSelected(0);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 4) {
            Object[] choices = new String[]{"plaintext", "encrypted"};
            return new RadioButtonPanel(choices);
        }
        if (index == 5) {
            return new JPasswordField();
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 4) {
            int selectedKeyType = ((RadioButtonPanel)this.getComponentAt(index)).getSelected();
            String key = ((JTextField)this.getComponentAt(5)).getText();
            if (key.length() != 0 && selectedKeyType == -1) {
                throw new Exception("Please select a value for KeyType.");
            }
            String serverKeyType = "";
            if (selectedKeyType != -1) {
                serverKeyType = ((RadioButtonPanel)this.getComponentAt(index)).getButton(selectedKeyType).getText();
            }
            return new SnmpString(serverKeyType);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected VarBindList buildInsertVarbind(int[] index, SnmpVar[] values) {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(this._table.getRowStatus(), index), new SnmpInt(this._table.getInsertValue())));
        this._firstOid = this._table.getRowStatus();
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i].isIndex() || values[i] == null || i == 4 || i == 5) continue;
            int[] mibOid = this._mibNodes[i].getOid();
            vbl.add(new SnmpVarBind(new SnmpOID(mibOid, index), values[i]));
        }
        int[] mibOid = this._mibNodes[4].getOid();
        byte[] serverKeyType = ((SnmpString)values[4]).getValue();
        byte[] serverKey = ((SnmpString)values[5]).getValue();
        if (serverKeyType.length != 0 && serverKey.length != 0) {
            byte[] newserverKey = new byte[serverKey.length + 1];
            newserverKey[0] = serverKeyType[0];
            System.arraycopy(serverKey, 0, newserverKey, 1, serverKey.length);
            vbl.add(new SnmpVarBind(new SnmpOID(mibOid, index), new SnmpString(newserverKey)));
        }
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(MibNode.get(this._addrTypeVar).getOid(), index), new SnmpInt(this._addrType));
        vbl.add(1, vb);
        return vbl;
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 4) {
            return new JLabel("KeyType:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }
}

