/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmInsertAsmBase;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.SmPortSetFieldPanel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmInsertSanTapData
extends SmInsertAsmBase
implements ListSelectionListener,
ItemListener {
    static final int INTERFACE = 0;
    static final int VSAN = 1;
    static final int WWN = 2;
    static final int TARGET_VSAN = 3;
    static final int NAME = 4;
    static final int LUNSIZEHANDLE = 5;
    static final int IOTIMEOUT = 6;
    static final int TGTIOTIMEOUT = 7;
    static final int USE_FULL_MODULE_GUI = 0;
    static final int MODULE_LIST_GUI = 1;
    static final int INTERFACE_GUI = 2;
    static final int VSAN_GUI = 3;
    static final int WWN_GUI = 4;
    static final int TARGET_VSAN_GUI = 5;
    static final int NAME_GUI = 6;
    static final int LUNSIZEHANDLE_GUI = 7;
    static final int IOTIMEOUT_GUI = 8;
    static final int TGTIOTIMEOUT_GUI = 9;
    private JTextField _wwn;
    private JList _list;
    JLabel _wwnLabel;
    private JComboBox _vsanIdcmbx;
    private SmPortSetFieldPanel _interfaceFieldPanel;
    JCheckBox _autoChooseInterface;
    JComboBox _moduleList;
    JLabel _moduleLabel;
    private HashMap _peers2WwnVsanId;

    public SmInsertSanTapData(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
        this._asmTimeout = 12000;
        this._peers2WwnVsanId = new HashMap();
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this._interfaceFieldPanel.setNode((SnmpPeer)this._choice.getSelectedItem());
        if (this._wwnLabel != null) {
            DialogUtil.constrain(this._container, this._wwnLabel, new GridBagConstraints(), 0, 5, 0, 14);
        }
        this.updateInputFields();
        this.loadModuleList(this._moduleList);
        this.updateModuleInterface();
    }

    @Override
    protected void layoutForm() {
        JComponent[] labels = new JComponent[this._labels.length + 2];
        System.arraycopy(this._labels, 0, labels, 2, this._labels.length);
        JComponent[] values = new JComponent[this._values.length + 2];
        System.arraycopy(this._values, 0, values, 2, this._values.length);
        this._autoChooseInterface = new JCheckBox("Automatically Choose Interface", true);
        values[0] = this._autoChooseInterface;
        this._autoChooseInterface.addItemListener(this);
        values[1] = this._moduleList = new JComboBox();
        this._moduleLabel = new JLabel("Module:");
        labels[1] = this._moduleLabel;
        DialogUtil.buildPanel(this._container, labels, values);
    }

    void updateModuleInterface() {
        boolean showCard = this._autoChooseInterface.isSelected();
        this._moduleList.setVisible(showCard);
        this._moduleLabel.setVisible(showCard);
        this._labels[0].setVisible(!showCard);
        this._values[0].setVisible(!showCard);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._autoChooseInterface) {
            this.updateModuleInterface();
            this._parent.validate();
            this._parent.invalidate();
            this._parent.pack();
        }
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 2) {
            this._wwnLabel = new JLabel("<html><div align=right>Available<br>(WWN, VSAN Ids)<br>Port WWN:</html>", 4);
            return this._wwnLabel;
        }
        if (index == 3) {
            return new JLabel("Target VSAN Id:");
        }
        if (index == 0) {
            return new JLabel("Interface:");
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            this._vsanIdcmbx = new JComboBox();
            this._vsanIdcmbx.setEditable(false);
            this.updateVsanId(this._peers[0]);
            return this._vsanIdcmbx;
        }
        if (index == 2) {
            JPanel panel = new JPanel(new BorderLayout(1, 2));
            this._list = new JList();
            this._list.addListSelectionListener(this);
            this._list.setSelectionMode(0);
            this._list.setCellRenderer(new SwitchWwnVsanIdCellRenderer());
            JScrollPane sp = new JScrollPane(this._list);
            sp.setPreferredSize(new Dimension(300, 100));
            panel.add("Center", sp);
            this._wwn = new KTextField();
            panel.add("South", this._wwn);
            this.updateWwnVsanIdList(this._peers[0]);
            return panel;
        }
        if (index == 0) {
            PortEditorFilter portFilter = new PortEditorFilter(new int[]{5, 20}, null);
            this._interfaceFieldPanel = new SmPortSetFieldPanel(true, 10, portFilter);
            return this._interfaceFieldPanel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        SnmpPeer curPeer = (SnmpPeer)this._choice.getSelectedItem();
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(curPeer.getAddress());
        if (index == 1) {
            int vsanId = (Integer)this._vsanIdcmbx.getSelectedItem();
            return new SnmpInt(vsanId);
        }
        if (index == 2) {
            if (this._wwn.getText().length() == 0) {
                throw new Exception("Port WWN: invalid entry");
            }
            return new SnmpWWN(this._wwn.getText(), false);
        }
        if (index == 0) {
            boolean showCard = this._autoChooseInterface.isSelected();
            if (showCard) {
                int curCardSel = (Integer)this._moduleList.getSelectedItem();
                Card[] cards = sw.getCards();
                String ifName = "fc" + sw.getCard(curCardSel).getSlotId() + '/' + "1";
                int ifIndex = sw.nameToIfIndex(ifName);
                return new SnmpInt(ifIndex |= 0x7F000);
            }
            String ifName = this._interfaceFieldPanel.getText();
            if (ifName.length() == 0) {
                throw new Exception("Interface: invalid entry");
            }
            return new SnmpInt(sw.nameToIfIndex(ifName));
        }
        return super.getComponentValue(index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = new int[9];
        index[0] = ((SnmpInt)values[1]).getValue();
        byte[] b = ((SnmpString)values[2]).getValue();
        for (int i = 0; i < b.length; ++i) {
            index[i + 1] = b[i] & 0xFF;
        }
        return index;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this.updateInputFields();
            }
        }
        super.actionPerformed(e);
    }

    void updateInputFields() {
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isSupported = sw.isVersionGreaterThan("5.0(4)");
        this.setEnabled(7, isSupported);
    }

    @Override
    protected void updateParamsUponSwitchListChange() {
        SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
        this.updateVsanId(peer);
        this.updateWwnVsanIdList(peer);
        this._wwn.setText("");
        ((FieldPanel)this._values[3]).setText("");
        this._interfaceFieldPanel.setNode(peer);
        this._interfaceFieldPanel.setText("");
        this.loadModuleList(this._moduleList);
        this.updateModuleInterface();
    }

    void updateVsanId(SnmpPeer peer) {
        this._vsanIdcmbx.removeAllItems();
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        short[] vsanIds = sw.getVsanIds();
        for (int i = 0; i < vsanIds.length; ++i) {
            this._vsanIdcmbx.addItem(new Integer(vsanIds[i]));
        }
    }

    void updateWwnVsanIdList(SnmpPeer peer) {
        Switch sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(peer.getAddress());
        HashedArrayList<EndPort> epsList = (HashedArrayList<EndPort>)this._peers2WwnVsanId.get(peer);
        if (epsList == null) {
            epsList = new HashedArrayList<EndPort>();
            EndPort[] eps = ClientController.getInstance().getFabric().getEndPorts();
            short[] swVsanIds = sw.getVsanIds();
            block0: for (int i = 0; i < eps.length; ++i) {
                short[] targetVsanIds;
                if (!eps[i].isTarget() || eps[i].isVirtualized() || (targetVsanIds = eps[i].getVsanIds()) == null) continue;
                boolean targetVsanKnownBySwitch = false;
                for (int t = 0; t < targetVsanIds.length; ++t) {
                    for (int v = 0; v < swVsanIds.length; ++v) {
                        if (targetVsanIds[t] != swVsanIds[v]) continue;
                        ((ArrayList)epsList).add(eps[i]);
                        targetVsanKnownBySwitch = true;
                        break;
                    }
                    if (targetVsanKnownBySwitch) continue block0;
                }
            }
            if (epsList.size() != 0) {
                this._peers2WwnVsanId.put(peer, epsList);
            }
        }
        Collections.sort(epsList);
        this._list.setListData(epsList.toArray(new EndPort[epsList.size()]));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        EndPort ep = (EndPort)this._list.getSelectedValue();
        if (ep != null) {
            this._wwn.setText(SnmpString.toHexString(ep.getPortWwn().getValue()));
            this.setComponentText(3, Integer.toString(ep.getFirstVsanId()));
        }
    }

    class SwitchWwnVsanIdCellRenderer
    extends DefaultListCellRenderer {
        SwitchWwnVsanIdCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            EndPort ep = (EndPort)value;
            StringBuffer buf = new StringBuffer();
            buf.append(ep.getPortWwn());
            buf.append(",");
            buf.append(ep.getVsansAsString());
            this.setText(buf.toString());
            return retValue;
        }
    }
}

