/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.VsanUtil;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmInsertVsan;
import com.cisco.dcbu.sm.client.dialogs.SmVsanTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.util.ArrayList;

public class SmInsertVsanVsan
extends SmInsertVsan {
    public SmInsertVsanVsan(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table);
        ((SmVsanTableModel)table)._isFilteredByVsan = true;
    }

    @Override
    protected void build() throws Exception {
        super.build();
        int curIndex = this._table.getTableIndex();
        this.setComponentText(this._indexIndex, Integer.toString(curIndex));
        this.setComponentVisibleAt(this._indexIndex, false);
        this.setComponentText(this._nameIndex, VsanUtil.getDefaultVsanName(curIndex));
        this.setComponentVisibleAt(this._nameIndex, false);
    }

    @Override
    protected void addPeers() throws Exception {
        this.addPeers(this.getInsertPeerList());
    }

    protected void updateFields(int curIndex) {
        Vsan v = ClientController.getInstance().getFabric().findVsanById(this._table.getTableIndex());
        if (v == null || v.getSnmpPeers().length == this._peers.length) {
            BrowserFrame.getDataView().enableButton(3, false);
            this._parent.dispose();
        } else {
            this._list.clearSelection();
            this._list.clearChoices();
            this._list.setChoices(this.getInsertPeerList());
            this._list.repaint();
            this._parent.pack();
            this._parent.invalidate();
        }
    }

    @Override
    protected SnmpPeer[] getInsertPeerList() {
        ArrayList<SnmpPeer> insertPeerList = new ArrayList<SnmpPeer>();
        Vsan v = ClientController.getInstance().getFabric().findVsanById(this._table.getTableIndex());
        if (v == null) {
            return this.getValidPeers();
        }
        SnmpPeer[] curVsanPeerLst = v.getSnmpPeers();
        Fabric f = v.getFabric();
        SnmpPeer[] fabricPeers = f.getSnmpPeers();
        for (int i = 0; i < fabricPeers.length; ++i) {
            boolean bNotInVsan = true;
            for (int j = 0; j < curVsanPeerLst.length; ++j) {
                if (fabricPeers[i] != curVsanPeerLst[j]) continue;
                bNotInVsan = false;
                break;
            }
            if (!bNotInVsan) continue;
            insertPeerList.add(fabricPeers[i]);
        }
        return insertPeerList.toArray(new SnmpPeer[0]);
    }

    @Override
    protected SnmpPeer[] getUsedDmIdPeerList() {
        Fabric fb = ClientController.getInstance().getFabric();
        return fb.getSnmpPeers();
    }
}

