/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.dialogs.SmIpProfileUtil;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIControls;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

public class SmIpFilterProfileTableModel
extends SmTableModel
implements ActionListener {
    public static final String[] Wizard_BUTTON = new String[]{"icons/ipfilter16.gif", "Wizard...", "ipFilterWizard"};
    static final int[] _cippfIpProfileStatusOid = MibNode.get("cippfIpProfileStatus").getOid();

    public SmIpFilterProfileTableModel() {
        DataView dataView = BrowserFrame.getDataView();
        dataView.replaceButton(3, Wizard_BUTTON, this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIControls.getInstance().actionPerformed(e);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        int[] indexOid = index.getValue();
        SnmpVarBind vb = vbl.get(0);
        int type = vb.intValue();
        SmIpProfileUtil.getInstance().addProfile(node, SnmpString.toString(indexOid, 1, indexOid.length), type);
        return super.addElement(vbl, node, index);
    }

    @Override
    public boolean deleteRowsAction(int[] rows) throws Exception {
        Object[] options = new Object[]{"Continue", "Cancel"};
        if (JOptionPane.showOptionDialog(BrowserFrame.getInstance(), "<html>Deleting profles would cause an implicit deny if there are interfaces using them, <br>possibly locking you out of the switch.<br><br>Please unbind any interfaces to profiles before deleting them.</html>", "DCNM-SAN", -1, 2, null, options, options[0]) == 1) {
            return false;
        }
        return super.deleteRowsAction(rows);
    }

    @Override
    public void deleteRows(int[] rows) throws Exception {
        this.deleteRows(rows, this);
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        if (err.length() == 0) {
            SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
            VarBindList vbl = pdu.getVariables();
            for (int i = 0; i < vbl.size(); ++i) {
                SnmpVarBind vb = vbl.getVb(i);
                int[] oid = vb.getOid().getValue();
                SnmpOID index = new SnmpOID(oid, _cippfIpProfileStatusOid.length, oid.length - _cippfIpProfileStatusOid.length);
                int[] indexOid = index.getValue();
                SmIpProfileUtil.getInstance().removeProfile(node, SnmpString.toString(indexOid, 1, indexOid.length));
            }
        }
    }
}

