/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmIvrEnabledTableModel;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmIvrErrorTableModel
extends SmIvrEnabledTableModel {
    static final int PEER = 0;
    static final int ACTZNST_CHKSM = 1;
    static final int ACTTPL_CHKSM = 2;
    static final int FABRICID_CHKSM = 3;
    static final int DEFAULTFABRICID_CHKSM = 4;
    static final String[] LABELS = new String[]{"Switch", "Discrepancy", "Region ID"};

    @Override
    public VarBindList buildGetVbl(SnmpPeer node, int[] index) {
        VarBindList vbl = super.buildGetVbl(node, index);
        vbl.remove(2);
        vbl.add(MibNode.get("cfsFeatureRegionId").getOid(), new int[]{3, 105, 118, 114, 1});
        return vbl;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        this.setHeaders(LABELS);
    }

    @Override
    public Array getVars(SnmpPeer[] nodes) throws SnmpException {
        Array responseData = super.getVars(nodes);
        Array<Object[]> modData = new Array<Object[]>();
        for (int i = 0; i < responseData.size(); ++i) {
            SnmpPeer refPeer;
            Object[] rowData = (Object[])responseData.elementAt(i);
            int regionId = (int)((SnmpGauge)rowData[3]).getValue();
            Switch ivrSw = ClientController.getInstance().getFabric().getIvrSeedSwitch(regionId);
            if (ivrSw == null || (refPeer = ivrSw.getPeer()) == null) continue;
            int refPeerRow = -1;
            for (int k = 0; k < responseData.size(); ++k) {
                Object[] refRowData = (Object[])responseData.elementAt(k);
                if (refRowData[0] != refPeer) continue;
                refPeerRow = k;
                break;
            }
            if (refPeerRow == -1) continue;
            Object[] refRowData = (Object[])responseData.elementAt(refPeerRow);
            if (rowData[0] == refPeer) continue;
            if (!rowData[1].toString().equals(refRowData[1].toString())) {
                modData.addElement(new Object[]{rowData[0], "Active zonesets differs from " + refRowData[0], rowData[3], null});
            }
            if (!rowData[2].toString().equals(refRowData[2].toString())) {
                modData.addElement(new Object[]{rowData[0], "Active topology differs from " + refRowData[0], rowData[3], null});
            }
            if (rowData.length > 3 && !rowData[3].toString().equals(refRowData[3].toString())) {
                modData.addElement(new Object[]{rowData[0], "Fabric ID configuration differs from " + refRowData[0], rowData[3], null});
            }
            if (rowData.length <= 4 || rowData[4].toString().equals(refRowData[4].toString())) continue;
            modData.addElement(new Object[]{rowData[0], "Default Fabric ID configuration differs from " + refRowData[0], rowData[3], null});
        }
        return modData;
    }

    @Override
    protected SnmpPeer[] getWrkingPeers(MgmtDomainIf mgmtDomain) {
        return this.getWrkingPeers();
    }
}

