/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;

public class SmLmFeatureTableModel
extends SmTableModel
implements ActionListener {
    static final int[] _clmLicenseConfigSpinLock = MibNode.get("clmLicenseConfigSpinLock").getOid();
    static final int[] _ClmLicenseGracePeriodOid = MibNode.get("clmLicenseGracePeriod").getOid();
    static final int[] _ClmLicenseGracePeriodLeftOid = MibNode.get("clmLicenseGracePeriodLeft").getOid();
    HashMap _peers2SpinLock;
    VarBindList _spinLockVB;
    int ERRORS;
    Array _fmlicenseInUsePeers;
    private static final String FM_SERVER_INDEX = "FM_SERVER_PKG";
    private static final String[] NEW_BUTTON = new String[]{null, "Check in FM", "F"};
    JButton _checkInFMButton;

    public SmLmFeatureTableModel() {
        this.ERRORS = this._offset + 6;
        this._peers2SpinLock = new HashMap();
        this._spinLockVB = new VarBindList();
        this._spinLockVB.add(new SnmpVarBind(new SnmpOID(MibNode.get("clmLicenseConfigSpinLock").getOid(), 0)));
        this._fmlicenseInUsePeers = new Array();
        this._checkInFMButton = BrowserFrame.getDataView().insertButton(0, new String[][]{NEW_BUTTON}, new ActionListener[]{this});
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        this._fmlicenseInUsePeers.clear();
        Array returnArray = super.getTableVars(invoker);
        super.sort(this.ERRORS, false);
        this.updateCheckinFm();
        return returnArray;
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._fmlicenseInUsePeers.clear();
        Array returnArray = super.getTableVars(nodes);
        super.sort(this.ERRORS, false);
        this.updateCheckinFm();
        return returnArray;
    }

    @Override
    public void updateTableInfo() {
        super.updateTableInfo();
        super.sort(this.ERRORS, false);
    }

    @Override
    protected void repairVb(int[] mibOid, int[] curOid, int[] firstIndex, SnmpVarBind vb) {
        if (SnmpOID.startsWith(mibOid, _ClmLicenseGracePeriodOid) && SnmpOID.startsWith(curOid, _ClmLicenseGracePeriodLeftOid)) {
            int[] curIndex = new int[curOid.length - mibOid.length];
            System.arraycopy(curOid, curOid.length - curIndex.length, curIndex, 0, curIndex.length);
            if (SnmpOID.startsWith(firstIndex, curIndex)) {
                return;
            }
        }
        super.repairVb(mibOid, curOid, firstIndex, vb);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        int type = this._offset;
        int installed = this._offset + 1;
        int used = this._offset + 2;
        int expiry = this._offset + 3;
        int grace = this._offset + 4;
        int missing = this._offset + 5;
        int errors = this._offset + 6;
        SnmpVar flag = vbl.getVb(0).getVar();
        byte[] bits = vbl.byteValue(0);
        int curr = vbl.intValue(2);
        int gracePeriod = vbl.intValue(4);
        int miss = vbl.intValue(5);
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        if (miss == 0) {
            row[missing] = "";
        }
        row[errors] = "";
        if (!SnmpString.getBitBase0(bits, 2)) {
            row[installed] = "";
        }
        if (SnmpString.getBitBase0(bits, 1)) {
            row[expiry] = "never";
            row[grace] = "";
        }
        if (SnmpString.getBitBase0(bits, 3)) {
            row[expiry] = "";
        }
        row[type] = MibVariableFormat.clmLicenseFlag(flag, gracePeriod);
        row[grace] = MibVariableFormat.clmLicenseGracePeriodLeft(gracePeriod, flag);
        if (gracePeriod == 0) {
            row[errors] = "Grace Expired";
        }
        row[errors] = miss > 0 ? (row[errors].toString().length() > 0 ? row[this.ERRORS].toString() + ",License File Missing" : "License File Missing") : "";
        int[] indexOid = index.getValue();
        String pkgName = SnmpString.toString(indexOid, 1, indexOid[0] + 1);
        boolean isFMServer = pkgName.equals(FM_SERVER_INDEX);
        if (isFMServer && curr != 0) {
            this._fmlicenseInUsePeers.addElement(node);
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkinFmLicense() {
        this.getSpinkLock();
        this._state = 5;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : this._peers2SpinLock.keySet()) {
                SnmpInt spinLock = (SnmpInt)this._peers2SpinLock.get(peer);
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
                pdu.addVar(new SnmpOID(MibNode.get("clmLicenseConfigSpinLock").getOid(), 0), spinLock);
                pdu.addVar(new SnmpOID(MibNode.get("clmLicenseRequestFeatureName").getOid(), 0), new SnmpString(FM_SERVER_INDEX));
                pdu.addVar(new SnmpOID(MibNode.get("clmLicenseRequestCommand").getOid(), 0), new SnmpInt(1));
                try {
                    peer.send(pdu, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
        BrowserFrame.getDataView().refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getSpinkLock() {
        int checkInPeers = this._fmlicenseInUsePeers.size();
        this._peers2SpinLock.clear();
        this._state = 1;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < checkInPeers; ++i) {
                SnmpFetch f = new SnmpFetch();
                try {
                    f.get((SnmpPeer)this._fmlicenseInUsePeers.elementAt(i), this._spinLockVB, this);
                    this._numOutstanding.increment();
                    continue;
                }
                catch (SnmpException ex) {
                    // empty catch block
                }
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    public void processCallback(SnmpPeer node, SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpVarBind vb = pdu.getVariables().getVb(0);
        int[] oid = vb.getOid().getValue();
        if (!SnmpOID.startsWith(oid, _clmLicenseConfigSpinLock)) {
            super.processCallback(node, session, reqid, pdu, timedOut);
        }
        SnmpInt spinLock = (SnmpInt)pdu.getVar(0);
        this._peers2SpinLock.put(node, spinLock);
    }

    void updateCheckinFm() {
        this._checkInFMButton.setVisible(this._fmlicenseInUsePeers.size() != 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            this.checkinFmLicense();
        }
    }
}

