/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.SnmpDateAndTime;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.client.dialogs.SmLmDelete;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIControls;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableModel;

public class SmLmFileContentTableModel
extends SmTableModel
implements ActionListener {
    static final int SWITCH = 0;
    static final int NAME = 1;
    static final int LASTMODIFIED = 2;
    static final int FEATURE = 3;
    static final int VERSION = 4;
    static final int TYPE = 5;
    static final int COUNT = 6;
    static TableMouseListener _lsnr;
    String _line;
    static SimpleDateFormat _DateFormat;
    HashMap _licWriters = new HashMap();
    boolean _refresh;
    public static final String[] Wizard_BUTTON;

    public SmLmFileContentTableModel() {
        DataView dataView = BrowserFrame.getDataView();
        dataView.replaceButton(3, Wizard_BUTTON, this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIControls.getInstance().actionPerformed(e);
    }

    public MouseListener getMouseListener() {
        if (_lsnr == null) {
            _lsnr = new TableMouseListener();
        }
        return _lsnr;
    }

    @Override
    protected int[] getIndex() {
        int[] index = new int[]{this._index};
        return index;
    }

    @Override
    protected void refresh() {
        this._refresh = true;
    }

    @Override
    protected String getInsertTitle(SnmpKTable table) {
        return "Fetch and Install Licenses";
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        Array ret = super.getTableVars(nodes);
        this._refresh = false;
        return ret;
    }

    @Override
    public Array getVars(SnmpPeer[] nodes) throws SnmpException {
        Array ret = super.getVars(nodes);
        this._refresh = false;
        return ret;
    }

    @Override
    public boolean deleteRowsAction(int[] rows) {
        if (rows.length > 0) {
            SmLmDelete d = new SmLmDelete(BrowserFrame.getInstance(), rows, this.getWrkingPeers(), this);
            d.setVisible(true);
        }
        return false;
    }

    @Override
    public void processCallback(SnmpPeer node, SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpVarBind vb = pdu.getVariables().getVb(0);
        int[] oid = vb.getOid().getValue();
        if (oid.length >= this._firstOid.length) {
            SnmpOID index = new SnmpOID(oid, this._firstOid.length, oid.length - this._firstOid.length);
            if (this._state == 5) {
                this.processSetCallback(node, session, reqid, pdu, timedOut);
            } else if (this._state == 2) {
                if (!this.isEnd(node, this._firstOid, vb, index.getValue(), reqid)) {
                    int skipVals = 0;
                    if (!this.isSkip(node, this._firstOid, vb, index.getValue(), pdu.getVariables(), reqid)) {
                        if (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), this._state)) {
                            skipVals = this.gotRow(pdu.getVariables(), node, index);
                        }
                        for (int i = 0; i < pdu.getVariables().size(); ++i) {
                            vb = pdu.getVariables().getVb(i);
                            vb.setVar(null);
                        }
                    }
                    if (skipVals != 0) {
                        int[] ids = index.getValue();
                        int[] newids = new int[ids.length];
                        System.arraycopy(ids, 0, newids, 0, ids.length - 1);
                        newids[ids.length - 1] = skipVals;
                        pdu = this.buildGetTablePdu(node, newids);
                        this._numOutstanding.increment();
                        try {
                            node.send(pdu, this);
                        }
                        catch (SnmpException ex) {}
                    } else {
                        try {
                            pdu.setCommand((byte)-95);
                            pdu.setReqid(0);
                            this._numOutstanding.increment();
                            node.send(pdu, this);
                        }
                        catch (SnmpException ex) {}
                    }
                }
            } else if (this._state == 1) {
                if (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), this._state)) {
                    this.addElement(pdu.getVariables(), node, index);
                }
            } else if (!this._validateVbl || this._validateVbl && this.validateVbl(node, pdu.getVariables(), this._state)) {
                this.addElements(pdu.getVariables(), node, index);
            }
        }
    }

    public synchronized int gotRow(VarBindList vbl, SnmpPeer peer, SnmpOID index) {
        block13: {
            int[] oids = index.getValue();
            int rowNumber = oids[oids.length - 1];
            int numOfRows = vbl.intValue(0);
            String modified = SnmpDateAndTime.toString(vbl.byteValue(1));
            String contents = vbl.stringValue(2);
            String path = this.getPath(peer, index);
            BufferedWriter wr = null;
            String key = peer.toString() + ":" + this.getName(index);
            if (!this._licWriters.containsKey(key)) {
                File f = new File(path);
                if (!this._refresh && this.parseFile(f, peer, index, modified)) {
                    return numOfRows;
                }
                try {
                    wr = new BufferedWriter(new FileWriter(f));
                    this._licWriters.put(key, wr);
                }
                catch (IOException ex) {
                    DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (this._licWriters.containsKey(key)) {
                wr = (BufferedWriter)this._licWriters.get(key);
                try {
                    wr.write(contents);
                    if (contents.endsWith("\r")) {
                        wr.write("\n");
                    } else {
                        wr.write("\r\n");
                    }
                }
                catch (IOException ex) {
                    DefaultLogger._DefLogger.error((Object)ex.getMessage());
                }
            }
            this.gotRow(peer, index, modified, contents);
            if (numOfRows == rowNumber) {
                try {
                    if (wr != null) {
                        wr.close();
                        this._licWriters.remove(key);
                    }
                }
                catch (IOException ex) {
                    if (!SnmpSession.isTrace()) break block13;
                    DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return 0;
    }

    boolean parseFile(File f, SnmpPeer peer, SnmpOID index, String modified) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(f));
            while ((line = reader.readLine()) != null) {
                this.gotRow(peer, index, modified, line);
            }
            reader.close();
            return true;
        }
        catch (IOException ex) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex2) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    void gotRow(SnmpPeer peer, SnmpOID index, String modified, String line) {
        if ((line = line.trim()).startsWith("FEATURE ") || line.startsWith("INCREMENT ")) {
            this._line = null;
        } else {
            line = this._line != null ? this._line + line : null;
        }
        if (line != null) {
            String[] lic = this.parse(line);
            if (lic == null && line.endsWith("\\")) {
                this._line = line.substring(0, line.length() - 1);
            } else if (lic != null) {
                Object[] row = new Object[8];
                row[0] = peer;
                row[1] = index;
                row[2] = modified;
                row[3] = lic[0];
                row[4] = lic[1];
                row[5] = lic[2];
                row[6] = lic[3];
                this._responseData.addElement(row);
            }
        }
    }

    String[] parse(String line) {
        int indexOf;
        int offset = 0;
        String[] lic = new String[6];
        int i = 0;
        while ((indexOf = line.indexOf(" ", offset)) != -1) {
            lic[i++] = line.substring(offset, indexOf);
            offset = indexOf + 1;
            if (i != 6) continue;
        }
        if (i != 6) {
            return null;
        }
        String exp = lic[4];
        if (exp.equals("0")) {
            exp = "permanent";
        } else if (!exp.startsWith("permanent")) {
            exp = "expires " + exp;
        }
        return new String[]{lic[1], lic[3], exp, lic[5]};
    }

    String getTime(long time) {
        if (_DateFormat == null) {
            _DateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return _DateFormat.format(new Date(time));
    }

    String getName(SnmpOID index) {
        int[] oids = index.getValue();
        return SnmpString.toString(oids, 1, oids[0] + 1);
    }

    String getPath(SnmpPeer peer, SnmpOID index) {
        String path = ClientCache.getLocation() + "licenses";
        File f = new File(path);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(path = path + File.separator + peer.toString())).exists()) {
            f.mkdir();
        }
        String name = this.getName(index);
        return path + File.separator + name;
    }

    static {
        Wizard_BUTTON = new String[]{"icons/licensewiz_toolbar.gif", "License Install...", "licenseInstall"};
    }

    class TableMouseListener
    extends MouseInputAdapter {
        TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            SnmpKTable t = (SnmpKTable)e.getSource();
            TableModel tm = t.getModel();
            if (tm instanceof SmLmFileContentTableModel) {
                int row = t.rowAtPoint(p);
                int col = t.columnAtPoint(p);
                if (col == 1) {
                    SnmpOID index;
                    SnmpPeer peer = (SnmpPeer)tm.getValueAt(row, 0);
                    String path = SmLmFileContentTableModel.this.getPath(peer, index = (SnmpOID)tm.getValueAt(row, 1));
                    if (new File(path).exists()) {
                        try {
                            ExternalTools.openUnknownFile(path);
                        }
                        catch (Exception ex) {
                            DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    } else {
                        DefaultLogger._DefLogger.error((Object)(path + " not present."));
                    }
                }
            }
        }
    }
}

