/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.event.LunDiscListenerIf;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmGenericTab;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.dto.Lun;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreePath;

public class SmLunsTableModel
extends SmTableModel
implements LunDiscListenerIf {
    static final String[] _headers = new String[]{"VSAN Id", "Enclosure", "Port WWN", "FcId", "Switch Interface", "Number", "Capacity (MB)", "SerialNum", "OS"};
    static int _nElementsInRow;
    static final int VSANID = 0;
    static final int NAME = 1;
    static final int PORTWWN = 2;
    static final int FCID = 3;
    static final int ATTACH = 4;
    static final int NUM = 5;
    static final int CAPACITY = 6;
    static final int SERIAL = 7;
    static final int LUNOS = 8;
    static final int ENDPORT = 10;
    static final long LUN_DISCOVERY_DELTA = 600000L;
    TreePath _myPath;
    ArrayList _endPorts = null;

    public SmLunsTableModel() {
        Fabric fabric = ClientController.getInstance().getFabric();
        Fabric.addListener(this);
        this._myPath = BrowserFrame.getTreePath();
    }

    public SmLunsTableModel(ArrayList endPorts) {
        this._endPorts = endPorts;
        this._myPath = BrowserFrame.getTreePath();
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, this._isScalar ? 1 : 2);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._prefixes = prefixes;
        _nElementsInRow = _headers.length;
        String[] headers = new String[_nElementsInRow];
        boolean[] editable = new boolean[_nElementsInRow];
        for (int i = 0; i < _nElementsInRow; ++i) {
            headers[i] = _headers[i];
            editable[i] = false;
        }
        this.setHeaders(headers);
        this.setEditable(editable);
        this.setData(new Array());
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._responseData = null;
        Fabric cfabric = ClientController.getInstance().getFabric();
        return null;
    }

    public Array populateLunData() throws SnmpException {
        this._responseData = new Array();
        Fabric fabric = ClientController.getInstance().getFabric();
        ArrayList<EndPort> eps = this._endPorts != null ? this._endPorts : fabric.getTargets();
        Collections.sort(eps);
        for (int i = 0; i < eps.size(); ++i) {
            EndPort ep = eps.get(i);
            Lun[] luns = Fabric.getLuns(ep);
            if (luns == null || luns.length == 0) continue;
            Integer vsanId = new Integer(ep.getVsanId());
            Enclosure en = ep.getEnclosure();
            Wwn pWwn = ep.getPortWwn();
            String fcId = ep.getFcIdAsString();
            String attatchedTo = ep.getSwitch().toString() + " " + ep.getIfIndexName();
            for (int j = 0; j < luns.length; ++j) {
                Lun lun = luns[j];
                Object[] row = new Object[_nElementsInRow + 2];
                row[0] = vsanId;
                row[1] = en;
                row[2] = pWwn;
                row[3] = fcId;
                row[4] = attatchedTo;
                row[5] = "0x" + Integer.toString(lun.getIndex(), 16);
                row[6] = new Long(lun.getCapacity());
                row[7] = lun.getSerialNum();
                row[8] = lun.getOS();
                row[10] = ep;
                this._responseData.addElement(row);
            }
        }
        return this._responseData;
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        this.mapSelectDevice(table);
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[10];
    }

    @Override
    protected boolean RefreshBtnOn() {
        return false;
    }

    @Override
    public void lunDiscovered(Fabric fabric) {
        String tabTitle;
        BrowserFrame frame = BrowserFrame.getInstance();
        TreePath curPath = frame.getTreePath();
        DataView dataview = frame.getDataView();
        SmGenericTab curTabPanel = dataview.getTabPanel();
        if ((this._myPath == null || curPath == null || curPath.equals(this._myPath)) && curTabPanel != null && (tabTitle = ((JTabbedPane)((Object)curTabPanel)).getTitleAt(((JTabbedPane)((Object)curTabPanel)).getSelectedIndex())).equals("LUNs")) {
            try {
                dataview.setTableData(this.populateLunData());
            }
            catch (Exception ex) {
                // empty catch block
            }
            dataview.displayTable();
        }
    }

    @Override
    public void lunDiscovered(Switch sw, boolean successful, boolean local, int numTgts, int numLuns) {
    }

    @Override
    public String getStatusUpdate() {
        long lastscanTime = ClientController.getInstance().getFabric().getLastLunScanTime();
        if (this._responseData == null || lastscanTime == 0L) {
            return null;
        }
        String msg = "LUNs discovered on " + new Date(lastscanTime) + ".";
        return msg;
    }
}

