/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.net.InetAddress;
import java.util.HashMap;

public class SmPhysicalSummaryTableModel
extends SmTableModel {
    static final int NAME_COL = 2;
    static final int OPERSTATUS_COL = 10;
    static final String[][] _statusVars = new String[][]{{"Fan", "cefcFanTrayOperStatus"}, {"Power", "cefcFRUPowerOperStatus"}, {"other", "cefcModuleOperStatus"}};
    private boolean _isFetchOperStatus;

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        Array data = super.getTableVars(invoker);
        this.getOperStatusData();
        return data;
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        this._isFetchOperStatus = false;
        Array data = this.getChassisRows(nodes);
        Array newData = this.getCardRows(nodes);
        data.append(newData);
        newData = this.getPowerSupplyRows(nodes);
        data.append(newData);
        newData = this.getFanRows(nodes);
        data.append(newData);
        this._responseData = data;
        this.getOperStatusData();
        return this._responseData;
    }

    public static int[][] getIndices2Array(int[] indices) {
        int[][] outIndices = new int[indices.length][1];
        for (int i = 0; i < indices.length; ++i) {
            outIndices[i][0] = indices[i];
        }
        return outIndices;
    }

    Array getChassisRows(SnmpPeer[] nodes) throws SnmpException {
        SmFilter[] filters = new SmFilter[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(nodes[i].getAddress());
            int[][] indices = new int[1][1];
            indices[0][0] = sw.getChassisPhysicalIndex();
            filters[i] = new SmFilter(nodes[i], indices);
        }
        return super.getTableVars(filters, false);
    }

    Array getCardRows(SnmpPeer[] nodes) throws SnmpException {
        SmFilter[] filters = new SmFilter[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(nodes[i].getAddress());
            int[] modelindices = sw.getCardPhysicalIndices();
            if (modelindices != null) {
                int[][] indices = SmPhysicalSummaryTableModel.getIndices2Array(modelindices);
                filters[i] = new SmFilter(nodes[i], indices);
                continue;
            }
            filters[i] = null;
        }
        return super.getTableVars(filters, false);
    }

    Array getPowerSupplyRows(SnmpPeer[] nodes) throws SnmpException {
        SmFilter[] filters = new SmFilter[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(nodes[i].getAddress());
            int[] modelindices = sw.getPSPhysicalIndices();
            if (modelindices != null) {
                int[][] indices = SmPhysicalSummaryTableModel.getIndices2Array(modelindices);
                filters[i] = new SmFilter(nodes[i], indices);
                continue;
            }
            filters[i] = null;
        }
        return super.getTableVars(filters, false);
    }

    Array getFanRows(SnmpPeer[] nodes) throws SnmpException {
        SmFilter[] filters = new SmFilter[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(nodes[i].getAddress());
            int[] modelindices = sw.getFanPhysicalIndices();
            if (modelindices != null) {
                int[][] indices = SmPhysicalSummaryTableModel.getIndices2Array(modelindices);
                filters[i] = new SmFilter(nodes[i], indices);
                continue;
            }
            filters[i] = null;
        }
        return super.getTableVars(filters, false);
    }

    private boolean isChassisRow(SnmpPeer peer, int index) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw.isVersionGreaterThanEqual("3.0(0)")) {
            return index == sw.getChassisPhysicalIndex();
        }
        return index == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getOperStatusData() throws SnmpException {
        for (int i = 0; i < this._responseData.size(); ++i) {
            Object[] row = (Object[])this._responseData.elementAt(i);
            row[10] = "n/a";
        }
        this._state = 1;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        VarBindList vbl = null;
        for (int i = 0; i < this._responseData.size(); ++i) {
            Object[] row = (Object[])this._responseData.elementAt(i);
            int index = ((SnmpOID)row[1]).getValue()[0];
            String name = ((SnmpString)row[2]).toString();
            if (this.isChassisRow((SnmpPeer)row[0], index)) continue;
            SnmpPeer peer = (SnmpPeer)row[0];
            int[] mibOid = null;
            if (!peers2Vbl.containsKey(peer)) {
                vbl = new VarBindList();
                peers2Vbl.put(peer, vbl);
            } else {
                vbl = (VarBindList)peers2Vbl.get(peer);
            }
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            boolean find = false;
            for (int j = 0; j < _statusVars.length; ++j) {
                if (!name.startsWith(_statusVars[j][0]) && (!sw.isN5K() || !name.contains(_statusVars[j][0]))) continue;
                mibOid = MibNode.get(_statusVars[j][1]).getOid();
                find = true;
                break;
            }
            if (!find) {
                mibOid = MibNode.get(_statusVars[_statusVars.length - 1][1]).getOid();
            }
            if (mibOid == null) continue;
            vbl.add(new SnmpVarBind(new SnmpOID(mibOid, index)));
        }
        this._isFetchOperStatus = true;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpFetch f = new SnmpFetch();
                f.get(peer, vbl, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        if (!this._isFetchOperStatus) {
            super.callback(session, reqid, pdu, timedOut);
            return;
        }
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            this.fillOperStatusData(node, pdu.getVariables());
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    void fillOperStatusData(SnmpPeer statusPeer, VarBindList statusVbl) {
        InetAddress statusPeerAdr = statusPeer.getAddress();
        block0: for (int i = 0; i < statusVbl.size(); ++i) {
            SnmpVarBind vb = statusVbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            int statusIndex = oid[oid.length - 1];
            int status = statusVbl.intValue(i);
            for (int j = 0; j < this._responseData.size(); ++j) {
                Object[] row = (Object[])this._responseData.elementAt(j);
                SnmpPeer peer = (SnmpPeer)row[0];
                InetAddress peerAdr = peer.getAddress();
                int index = ((SnmpOID)row[1]).getValue()[0];
                if (!statusPeerAdr.equals(peerAdr) || statusIndex != index) continue;
                String statusMibName = null;
                for (int k = 0; k < _statusVars.length; ++k) {
                    int[] statusOid = MibNode.get(_statusVars[k][1]).getOid();
                    if (!SnmpOID.startsWith(oid, statusOid)) continue;
                    statusMibName = _statusVars[k][1];
                    break;
                }
                if (statusMibName == null) continue block0;
                MibEnum[] enumUnitState = MibNode.get(statusMibName).getEnums();
                row[10] = MibEnum.getLabel(enumUnitState, status);
                continue block0;
            }
        }
    }
}

