/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.flash.FlashUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.BrowseInfoCellRenderer;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntHashMap;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;

public class SmPkiTrustPointActionTableModel
extends SmTableModel
implements ActionListener {
    HashMap _peers2RowInfo = new HashMap();
    HashMap _peers2RowsGetStatus;
    Array _actionChangedCells;
    protected Timer _statusTimer = new Timer(3000, this);
    static final int ACTION_COL = 2;
    static final int ACTION_URL_COL = 3;
    static final int ACTION_PSWD_COL = 4;
    static final int LASTACTION_COL = 5;
    static final int LASTACTION_RESULT_COL = 6;
    static final int FAILURE_REASON_COL = 7;
    static final int[] _cpkiActionOid = MibNode.get("cpkiAction").getOid();
    static final int STATUS_POLLING_MIB_SIZE = 2;
    static final int[] _cpkiLastActionResultOid = MibNode.get("cpkiLastActionResult").getOid();
    static final int[] _cpkiLastActionFailureReasonOid = MibNode.get("cpkiLastActionFailureReason").getOid();
    static final int ACTION_RESULT_INPROGRESS = 4;
    static final int ACTION_CMD_NOSELECTION = 1;
    static final int ACTION_CMD_CAAUTH = 2;
    static final int ACTION_CMD_CA_DEL = 3;
    static final int ACTION_CMD_CERT_REQ = 4;
    static final int ACTION_CMD_CERT_IMPORT = 5;
    static final int ACTION_CMD_CERT_DEL = 6;
    static final int ACTION_CMD_PKCS12_IMPORT = 7;
    static final int ACTION_CMD_PKCS12_EXPORT = 8;
    static final int ACTION_CMD_CERT_CONFIRM = 9;
    static final int ACTION_CMD_CERT_NOCONFIRM = 10;
    static final int ACTION_CMD_FORCE_DEL = 11;
    static final int ACTION_CMD_CRL_IMPORT = 12;
    static final int ACTION_CMD_CRL_DEL = 13;
    static TableMouseListener _tableMouseListener;
    private boolean _delInProgress;

    public SmPkiTrustPointActionTableModel() {
        this._peers2RowsGetStatus = new HashMap();
        this._actionChangedCells = new Array();
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        HashMap<String, Integer> index2RowN;
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        String failureReason = row[7].toString();
        if (failureReason != null && !failureReason.equals("")) {
            row[6] = row[6].toString() + " - " + failureReason;
        }
        if ((index2RowN = (HashMap<String, Integer>)this._peers2RowInfo.get(node)) == null) {
            index2RowN = new HashMap<String, Integer>();
            this._peers2RowInfo.put(node, index2RowN);
        }
        int[] indexOid = index.getValue();
        String featureName = SnmpString.toString(indexOid, 0, indexOid.length);
        index2RowN.put(featureName, new Integer(this._responseData.size() - 1));
        return row;
    }

    @Override
    public boolean applyChanges() throws Exception {
        if (this._peers2RowsGetStatus.size() != 0) {
            return false;
        }
        Array cells = super.getChanged();
        if (cells == null) {
            return false;
        }
        this._peers2RowsGetStatus.clear();
        this._actionChangedCells.clear();
        IntHashMap ingoreRemainingChangingRows = new IntHashMap();
        for (int i = 0; i < cells.size(); ++i) {
            int actCmd;
            Cell cell = (Cell)cells.elementAt(i);
            this.setValueAt("inProgress", cell._row, 6);
            if (cell._col == 2) {
                this._actionChangedCells.addElement(new Cell(cell._row, cell._col));
                actCmd = ((JnmMibEnum)this.getValueAt(cell._row, cell._col)).getValue();
                if (actCmd == 2 || actCmd == 4 || actCmd == 5 || actCmd == 7 || actCmd == 8 || actCmd == 12) {
                    this._actionChangedCells.addElement(new Cell(cell._row, 3));
                }
                if (actCmd == 4 || actCmd == 7 || actCmd == 8) {
                    this._actionChangedCells.addElement(new Cell(cell._row, 4));
                }
                ingoreRemainingChangingRows.put(cell._row, new Integer(cell._row));
                continue;
            }
            if (cell._col == 3) {
                if (ingoreRemainingChangingRows.get(cell._row) != null) continue;
                this._actionChangedCells.addElement(new Cell(cell._row, 2));
                this._actionChangedCells.addElement(new Cell(cell._row, cell._col));
                actCmd = ((JnmMibEnum)this.getValueAt(cell._row, 2)).getValue();
                if (actCmd == 4 || actCmd == 7 || actCmd == 8) {
                    this._actionChangedCells.addElement(new Cell(cell._row, 4));
                }
                ingoreRemainingChangingRows.put(cell._row, new Integer(cell._row));
                continue;
            }
            if (ingoreRemainingChangingRows.get(cell._row) != null) continue;
            this._actionChangedCells.addElement(new Cell(cell._row, 2));
            actCmd = ((JnmMibEnum)this.getValueAt(cell._row, 2)).getValue();
            if (actCmd == 2 || actCmd == 4 || actCmd == 5 || actCmd == 7 || actCmd == 8 || actCmd == 12) {
                this._actionChangedCells.addElement(new Cell(cell._row, 3));
            }
            this._actionChangedCells.addElement(new Cell(cell._row, cell._col));
        }
        this.fireTableDataChanged();
        super.applyChanges(this);
        if (this._peers2RowsGetStatus.size() != 0) {
            this._statusTimer.start();
        }
        return true;
    }

    @Override
    protected Array getChangeCells() {
        return this._actionChangedCells;
    }

    void updatePeers2RowInfo() {
        this._peers2RowInfo.clear();
        Array data = this.getData();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            SnmpPeer node = (SnmpPeer)row[0];
            HashMap<String, Integer> index2RowN = (HashMap<String, Integer>)this._peers2RowInfo.get(node);
            if (index2RowN == null) {
                index2RowN = new HashMap<String, Integer>();
                this._peers2RowInfo.put(node, index2RowN);
            }
            int[] indexOid = ((SnmpOID)row[1]).getValue();
            String featureName = SnmpString.toString(indexOid, 0, indexOid.length);
            index2RowN.put(featureName, new Integer(i));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._peers2RowsGetStatus.size() != 0) {
                this.pollSwitches();
                return;
            }
            this._statusTimer.stop();
            this.resetChanges(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSwitches() {
        this._state = 1;
        boolean requestSent = false;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        Object object = this._peers2RowsGetStatus;
        synchronized (object) {
            for (SnmpPeer peer : this._peers2RowsGetStatus.keySet()) {
                Array rowIndices = (Array)this._peers2RowsGetStatus.get(peer);
                if (rowIndices == null) continue;
                VarBindList vbl = new VarBindList();
                for (int i = 0; i < rowIndices.size(); ++i) {
                    int[] index = ((SnmpOID)rowIndices.elementAt(i)).getValue();
                    vbl.add(new SnmpVarBind(new SnmpOID(_cpkiLastActionResultOid, index)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_cpkiLastActionFailureReasonOid, index)));
                }
                peers2Vbl.put(peer, vbl);
            }
        }
        this._numOutstanding.set(0);
        object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                VarBindList vbl = (VarBindList)peers2Vbl.get(peer);
                requestSent = true;
                SnmpPDU pdu = new SnmpPDU(-96, vbl);
                pdu.setRetries(0);
                try {
                    peer.send(pdu, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object vbl;
        if (this._state == 2) {
            super.callback(session, reqid, pdu, timedOut);
            return;
        }
        if (this._state == 5) {
            return;
        }
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(peer, pdu, timedOut) && pdu.getVariables().size() > 0) {
            vbl = pdu.getVariables();
            for (int i = 0; i < ((VarBindList)vbl).size(); i += 2) {
                Array rowIndices;
                SnmpVarBind vb = ((VarBindList)vbl).getVb(i);
                int actionResult = ((VarBindList)vbl).intValue(i);
                int[] oid = vb.getOid().getValue();
                SnmpOID index = new SnmpOID(oid, _cpkiLastActionResultOid.length, oid.length - _cpkiLastActionResultOid.length);
                HashMap index2RowN = (HashMap)this._peers2RowInfo.get(peer);
                if (index2RowN != null) {
                    int[] indexOid = index.getValue();
                    String name = SnmpString.toString(indexOid, 0, indexOid.length);
                    int rowN = (Integer)index2RowN.get(name);
                    Object[] row = (Object[])this.getData().elementAt(rowN);
                    String strLastActionResult = MibEnum.getLabel(MibNode.get("cpkiLastActionResult").getEnums(), actionResult);
                    String failureReason = ((VarBindList)vbl).stringValue(i + 1);
                    row[6] = strLastActionResult + (failureReason != null && !failureReason.equals("") ? " - " + failureReason : "");
                    BrowserFrame.getInstance();
                    BrowserFrame.getDataView()._table.calcPreferredSize();
                }
                if (actionResult == 4 || (rowIndices = (Array)this._peers2RowsGetStatus.get(peer)) == null) continue;
                for (int j = rowIndices.size() - 1; j >= 0; --j) {
                    SnmpOID rowIndex = (SnmpOID)rowIndices.elementAt(j);
                    if (!SnmpOID.equals(rowIndex.getValue(), index.getValue())) continue;
                    rowIndices.removeElementAt(j);
                    break;
                }
                HashMap hashMap = this._peers2RowsGetStatus;
                synchronized (hashMap) {
                    if (rowIndices.size() == 0) {
                        this._peers2RowsGetStatus.remove(peer);
                    }
                    continue;
                }
            }
        } else {
            vbl = this._peers2RowsGetStatus;
            synchronized (vbl) {
                this._peers2RowsGetStatus.remove(peer);
            }
        }
        this.fireTableDataChanged();
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                vbl = this._numOutstanding;
                synchronized (vbl) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
    }

    @Override
    public void deleteRows(int[] rows) throws Exception {
        this._delInProgress = true;
        super.deleteRows(rows);
        this._delInProgress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        if (this._delInProgress) {
            return;
        }
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        Array<SnmpOID> rowIndices = (Array<SnmpOID>)this._peers2RowsGetStatus.get(node);
        if (rowIndices == null) {
            rowIndices = new Array<SnmpOID>();
            HashMap hashMap = this._peers2RowsGetStatus;
            synchronized (hashMap) {
                this._peers2RowsGetStatus.put(node, rowIndices);
            }
        }
        VarBindList vbl = pdu.getVariables();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            SnmpOID index = new SnmpOID(oid, _cpkiActionOid.length, oid.length - _cpkiActionOid.length);
            boolean newRow = true;
            if (rowIndices == null) continue;
            for (int j = rowIndices.size() - 1; j >= 0; --j) {
                SnmpOID rowIndex = (SnmpOID)rowIndices.elementAt(j);
                if (!SnmpOID.equals(rowIndex.getValue(), index.getValue())) continue;
                newRow = false;
                break;
            }
            if (!newRow) continue;
            rowIndices.addElement(index);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
    }

    @Override
    protected void performPostSorting() {
        this.updatePeers2RowInfo();
    }

    @Override
    public boolean isCellActive(int row, int col) {
        int actCmd = ((JnmMibEnum)this.getValueAt(row, 2)).getValue();
        if (col == 3) {
            return actCmd == 2 || actCmd == 4 || actCmd == 5 || actCmd == 7 || actCmd == 8 || actCmd == 12;
        }
        if (col == 4) {
            return actCmd == 4 || actCmd == 7 || actCmd == 8;
        }
        return super.isCellActive(row, col);
    }

    public MouseListener getMouseListener() {
        if (_tableMouseListener == null) {
            _tableMouseListener = new TableMouseListener();
        }
        return _tableMouseListener;
    }

    class TableMouseListener
    extends MouseInputAdapter {
        TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            SnmpKTable t = (SnmpKTable)e.getSource();
            if (t.getModel() instanceof SmPkiTrustPointActionTableModel) {
                SmPkiTrustPointActionTableModel tm = (SmPkiTrustPointActionTableModel)t.getModel();
                int row = t.rowAtPoint(p);
                int col = t.columnAtPoint(p);
                int ncol = t.convertColumnIndexToModel(col);
                if (ncol == 3 && tm.isCellEditable(row, ncol)) {
                    BrowseInfoCellRenderer renderer = (BrowseInfoCellRenderer)t.getCellRenderer(row, col);
                    Rectangle r = t.getCellRect(row, col, true);
                    if (r.getX() + r.getWidth() - p.getX() < (double)renderer.getButtonWidth()) {
                        SnmpPeer peer = (SnmpPeer)tm.getValueAt(row, 0);
                        Object[] bootflashFiles = null;
                        try {
                            bootflashFiles = FlashUtil.getFiles(peer);
                        }
                        catch (SnmpException ex) {
                            // empty catch block
                        }
                        String fileName = (String)JOptionPane.showInputDialog(BrowserFrame.getInstance(), "Select an import Certificate File:", "BootFlash Files: " + peer, -1, null, bootflashFiles, bootflashFiles[0]);
                        String url = "bootflash:/" + fileName;
                        if (fileName != null && fileName.length() > 0) {
                            tm.setValueAt(url, row, 3);
                        }
                    }
                }
            }
        }
    }
}

