/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;

public class SmPollStatusTableModel
extends SmTableModel
implements ActionListener {
    int[] _actionOid;
    int _actionCol;
    String[] _statusObjs;
    int[][] _statusOids;
    int[] _statusCols;
    MibNode[] _statusMibNodes;
    protected Timer _statusTimer = new Timer(5000, this);
    HashMap _peers2RowsGetStatus = new HashMap();
    HashMap _peers2RowInfo = new HashMap();
    int _inProgressCode;

    public SmPollStatusTableModel(int[] actionOid, int actionCol, String[] statusObjs, int[] statusCols, int inProgressCode) {
        this._actionOid = actionOid;
        this._actionCol = actionCol;
        this._statusObjs = statusObjs;
        this._statusMibNodes = new MibNode[this._statusObjs.length];
        this._statusOids = new int[this._statusObjs.length][];
        for (int i = 0; i < this._statusObjs.length; ++i) {
            this._statusMibNodes[i] = MibNode.get(this._statusObjs[i]);
            this._statusOids[i] = MibNode.get(this._statusObjs[i]).getOid();
        }
        this._statusCols = statusCols;
        this._inProgressCode = inProgressCode;
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        this._peers2RowInfo.clear();
        return super.getTableVars(invoker);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._responseData = new Array();
        if (nodes == null || nodes.length == 0) {
            return this._responseData;
        }
        this._peers2RowInfo.clear();
        super.getTableVars(nodes);
        return this._responseData;
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        HashMap<SnmpOID, Integer> index2RowN = (HashMap<SnmpOID, Integer>)this._peers2RowInfo.get(node);
        if (index2RowN == null) {
            index2RowN = new HashMap<SnmpOID, Integer>();
            this._peers2RowInfo.put(node, index2RowN);
        }
        index2RowN.put(index, new Integer(this._responseData.size() - 1));
        return row;
    }

    void updatePeers2RowInfo() {
        this._peers2RowInfo.clear();
        Array data = this.getData();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            SnmpPeer node = (SnmpPeer)row[0];
            HashMap<SnmpOID, Integer> index2RowN = (HashMap<SnmpOID, Integer>)this._peers2RowInfo.get(node);
            if (index2RowN == null) {
                index2RowN = new HashMap<SnmpOID, Integer>();
                this._peers2RowInfo.put(node, index2RowN);
            }
            index2RowN.put((SnmpOID)row[1], new Integer(i));
        }
    }

    void setInProgress(int row) {
    }

    @Override
    public boolean applyChanges() throws Exception {
        if (this._peers2RowsGetStatus.size() != 0) {
            return false;
        }
        Array cells = super.getChanged();
        if (cells == null) {
            return false;
        }
        this._peers2RowsGetStatus.clear();
        Array<Cell> actionChangedCells = new Array<Cell>();
        actionChangedCells.clear();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._col != this._actionCol) continue;
            this.setInProgress(cell._row);
            BrowserFrame.getInstance();
            BrowserFrame.getDataView()._table.calcPreferredSize();
            actionChangedCells.addElement(new Cell(cell._row, cell._col));
        }
        this.fireTableDataChanged();
        boolean isApply = super.applyChanges(this);
        if (actionChangedCells.size() != 0) {
            this._statusTimer.start();
        }
        return isApply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        if (err.length() != 0) {
            return;
        }
        VarBindList vbl = pdu.getVariables();
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        Array<FeatureAction> rowIndices = (Array<FeatureAction>)this._peers2RowsGetStatus.get(node);
        if (rowIndices == null) {
            rowIndices = new Array<FeatureAction>();
            HashMap hashMap = this._peers2RowsGetStatus;
            synchronized (hashMap) {
                this._peers2RowsGetStatus.put(node, rowIndices);
            }
        }
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.getVb(i);
            int[] oid = vb.getOid().getValue();
            if (!SnmpOID.startsWith(oid, this._actionOid)) continue;
            SnmpOID index = new SnmpOID(oid, this._actionOid.length, oid.length - this._actionOid.length);
            int action = vbl.intValue(i);
            rowIndices.addElement(new FeatureAction(index, action));
        }
        if (rowIndices.size() == 0) {
            HashMap hashMap = this._peers2RowsGetStatus;
            synchronized (hashMap) {
                this._peers2RowsGetStatus.remove(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSwitches() {
        this._state = 1;
        boolean requestSent = false;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        Object object = this._peers2RowsGetStatus;
        synchronized (object) {
            for (SnmpPeer peer : this._peers2RowsGetStatus.keySet()) {
                Array rowIndices = (Array)this._peers2RowsGetStatus.get(peer);
                if (rowIndices == null) continue;
                VarBindList vbl = new VarBindList();
                for (int i = 0; i < rowIndices.size(); ++i) {
                    int[] index = ((FeatureAction)rowIndices.elementAt(i)).getFeature().getValue();
                    for (int j = 0; j < this._statusOids.length; ++j) {
                        vbl.add(new SnmpVarBind(new SnmpOID(this._statusOids[j], index)));
                    }
                }
                peers2Vbl.put(peer, vbl);
            }
        }
        this._numOutstanding.set(0);
        object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                VarBindList vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpPDU pdu = new SnmpPDU(-96, vbl);
                pdu.setRetries(0);
                try {
                    peer.send(pdu, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPollVbl(SnmpPeer peer, VarBindList vbl) {
        for (int i = 0; i < vbl.size(); i += this._statusOids.length) {
            Array rowIndices;
            int rowN;
            SnmpVarBind vb = vbl.getVb(i);
            int actionResult = vbl.intValue(i);
            int[] oid = vb.getOid().getValue();
            int len = this._statusOids[0].length;
            SnmpOID index = new SnmpOID(oid, this._statusOids[0].length, oid.length - len);
            HashMap index2RowN = (HashMap)this._peers2RowInfo.get(peer);
            Object[] _row = null;
            if (index2RowN != null && (Integer)index2RowN.get(index) != null && (rowN = ((Integer)index2RowN.get(index)).intValue()) < this.getData().size()) {
                _row = (Object[])this.getData().elementAt(rowN);
                this.setPollCols(_row, vbl, i, rowN);
                BrowserFrame.getInstance();
                BrowserFrame.getDataView()._table.calcPreferredSize();
            }
            if (actionResult == this._inProgressCode || (rowIndices = (Array)this._peers2RowsGetStatus.get(peer)) == null) continue;
            for (int j = rowIndices.size() - 1; j >= 0; --j) {
                SnmpOID rowIndex = ((FeatureAction)rowIndices.elementAt(j)).getFeature();
                if (!SnmpOID.equals(rowIndex.getValue(), 0, index.getValue(), 0)) continue;
                rowIndices.removeElementAt(j);
                if (_row == null) break;
                this.postProcess(_row);
                break;
            }
            HashMap hashMap = this._peers2RowsGetStatus;
            synchronized (hashMap) {
                if (rowIndices.size() == 0) {
                    this._peers2RowsGetStatus.remove(peer);
                }
                continue;
            }
        }
    }

    protected void setPollCols(Object[] row, VarBindList vbl, int offset, int rowNo) {
        for (int i = 0; i < this._statusObjs.length; ++i) {
            row[this._statusCols[i]] = this.toCell(this._statusMibNodes[i], vbl.get(offset + i).getVar(), this._statusObjs[i], rowNo);
        }
    }

    protected void postProcess(Object[] row) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object vbl;
        block12: {
            if (this._state == 5) {
                return;
            }
            SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
            if (!this.checkSnmpCallbackErr(peer, pdu, timedOut) && pdu.getVariables().size() > 0) {
                vbl = pdu.getVariables();
                if (SnmpOID.startsWith(((VarBindList)vbl).get(0).getOid().getValue(), this._statusOids[0]) && ((VarBindList)vbl).size() == this._statusOids.length) {
                    this.processPollVbl(peer, (VarBindList)vbl);
                    break block12;
                } else {
                    super.callback(session, reqid, pdu, timedOut);
                    return;
                }
            }
            vbl = this._peers2RowsGetStatus;
            synchronized (vbl) {
                this._peers2RowsGetStatus.remove(peer);
            }
            vbl = this._peers2RowInfo;
            synchronized (vbl) {
                this.updatePeers2RowInfo();
            }
        }
        this.fireTableDataChanged();
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() > 0) return;
        try {
            vbl = this._numOutstanding;
            synchronized (vbl) {
                this._numOutstanding.notifyAll();
                return;
            }
        }
        catch (IllegalMonitorStateException ex) {
            DefaultLogger._DefLogger.error((Object)ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._peers2RowsGetStatus.size() != 0) {
                this.pollSwitches();
                return;
            }
            this._statusTimer.stop();
            this.resetChanges(false);
        }
    }

    static class FeatureAction {
        SnmpOID _index;
        int _action;

        public FeatureAction(SnmpOID index, int action) {
            this._index = index;
            this._action = action;
        }

        public SnmpOID getFeature() {
            return this._index;
        }

        public int getAction() {
            return this._action;
        }
    }
}

