/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JOptionPane;

public class SmPortChannelTableModel
extends SmTableModel
implements ActionListener {
    boolean _bPortListChanged = false;
    static final int[] _portChannelMemberListOid = MibNode.get("portChannelMemberList").getOid();
    static final int NUM_IF_MIB = 4;
    static final int[] _fcIfOperModeOid = MibNode.get("fcIfOperMode").getOid();
    static final int[] _adminStatusOid = MibNode.get("ifAdminStatus").getOid();
    static final int[] _ifOperStatusOid = MibNode.get("ifOperStatus").getOid();
    static final int[] _fcIfOperStatusCauseOid = MibNode.get("fcIfOperStatusCause").getOid();
    HashMap _peer2RowIndices2Data;
    static final int IFINDEX_MIB = 0;
    static final int MEMLIST_MIB = 2;
    static final int FC_MODE_OPER_MIB = 8;
    static final int IF_ADMINSTATUSE_MIB = 9;
    static final int IF_OPERSTATUS_MIB = 10;
    static final int IF_STATUSCAUSE_MIB = 11;
    public static final String[] Wizard_BUTTON = new String[]{"icons/prtchnnl_toolbar.gif", "FC-Channel Wizard...", "createPortChannel"};

    public SmPortChannelTableModel() {
        DataView dataView = BrowserFrame.getDataView();
        dataView.insertButton(3, new String[][]{Wizard_BUTTON}, new ActionListener[]{this});
        dataView.setButtonNewToolTip(3, "Create Ether-Channel...");
        BrowserFrame.getInstance();
        BrowserFrame.getDataView()._table.setSelectionMode(0);
        this._peer2RowIndices2Data = new HashMap();
    }

    @Override
    public Array getTableVars(MgmtDomainIf mgmtDomain, boolean isScalar) throws SnmpException {
        if (mgmtDomain.isSan() || mgmtDomain.isFabric()) {
            return super.getTableVars(mgmtDomain);
        }
        SmFilter[] filters = mgmtDomain.getFilters((short)5136);
        HashMap peers2PCIfs = new HashMap();
        if (filters.length != 0) {
            for (int i = 0; i < filters.length; ++i) {
                if (filters[i].getIndicesCount() == 0) continue;
                SnmpPeer peer = filters[i].getSnmpPeer();
                ArrayList<int[]> ifList = (ArrayList<int[]>)peers2PCIfs.get(peer);
                if (ifList == null) {
                    ifList = new ArrayList<int[]>();
                    peers2PCIfs.put(peer, ifList);
                }
                int[][] queryIndices = this.getTableVarsIndices(filters[i]);
                for (int j = 0; j < queryIndices.length; ++j) {
                    int pcId = IfIndexUtil.ifIndex2PortChannel(queryIndices[j][0]) + 1;
                    ifList.add(new int[]{pcId});
                }
            }
            if (peers2PCIfs.size() != 0) {
                SmFilter[] invoker = new SmFilter[peers2PCIfs.size()];
                SnmpPeer[] peers = peers2PCIfs.keySet().toArray(new SnmpPeer[peers2PCIfs.size()]);
                for (int i = 0; i < invoker.length; ++i) {
                    ArrayList indexList = (ArrayList)peers2PCIfs.get(peers[i]);
                    invoker[i] = new SmFilter(peers[i], (int[][])indexList.toArray((T[])new int[indexList.size()][]));
                }
                return this.getTableVars(invoker);
            }
        }
        return null;
    }

    @Override
    public boolean applyChangesAction() throws Exception {
        boolean bChangesApplied = super.applyChangesAction();
        if (this._bPortListChanged) {
            BrowserFrame.getDataView().refresh();
        }
        return bChangesApplied;
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        this._bPortListChanged = false;
        HashMap pdus = super.buildSendPdus();
        if (this._bPortListChanged) {
            Object[] options = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(BrowserFrame.getInstance(), "<html>You've changed membership list. You'll need to do the same operation on the peer switch.\t<br>Converting all the ISLs simultaneously to Port channels coud be disruptive </html>", "DCNM-SAN", -1, 2, null, options, options[0]) == 1) {
                this._bPortListChanged = false;
                return null;
            }
        }
        return pdus;
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        SnmpVar changedVar = super.processChangedCell(cell, pdu, changedCellOid, index);
        if (changedCellOid.startsWith(_portChannelMemberListOid)) {
            this._bPortListChanged = true;
            int[] memberList = SnmpIntList.valueOf(((SnmpIntList)changedVar).getValue());
            for (int i = 0; i < memberList.length; ++i) {
                pdu.addVar(new SnmpOID(_adminStatusOid, memberList[i]), new SnmpInt(1));
            }
        }
        return changedVar;
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        SnmpVar memberStatus;
        if (var.startsWith("portChannelMemberOperStatus") && (memberStatus = vb.getVar()).getType() != 5) {
            SnmpVar memberList = vbl.getVb(2 + indexOfVbl).getVar();
            Switch ifIndexIf = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            return MibVariableFormat.portChannelMemberOperStatus(memberList, memberStatus, ifIndexIf);
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIControls.getInstance().actionPerformed(e);
    }

    @Override
    protected String getInsertTitleDetail(SnmpKTable table) {
        return " EtherChannel";
    }

    @Override
    public void cleanup() {
        super.cleanup();
        BrowserFrame.getInstance();
        BrowserFrame.getDataView()._table.setSelectionMode(2);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peer2RowIndices2Data.clear();
        Array data = super.getTableVars(nodes);
        if (this._peer2RowIndices2Data.size() != 0) {
            this.getPCIfStatus();
        }
        return data;
    }

    @Override
    public Array getTableVars(SmFilter[] mapInvoker) throws SnmpException {
        this._peer2RowIndices2Data.clear();
        Array data = super.getTableVars(mapInvoker);
        if (this._peer2RowIndices2Data.size() != 0) {
            this.getPCIfStatus();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getPCIfStatus() throws SnmpException {
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : this._peer2RowIndices2Data.keySet()) {
                if (this._timedoutPeers.find(peer) != -1) continue;
                HashMap info2Row = (HashMap)this._peer2RowIndices2Data.get(peer);
                VarBindList vbl = new VarBindList();
                for (Integer ifIndexObj : info2Row.keySet()) {
                    vbl.add(new SnmpVarBind(new SnmpOID(_fcIfOperModeOid, (int)ifIndexObj)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_adminStatusOid, (int)ifIndexObj)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_ifOperStatusOid, (int)ifIndexObj)));
                    vbl.add(new SnmpVarBind(new SnmpOID(_fcIfOperStatusCauseOid, (int)ifIndexObj)));
                }
                if (vbl.size() == 0) continue;
                SnmpFetch f = new SnmpFetch();
                f.get(peer, vbl, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return null;
        }
        HashMap<Integer, Integer> info2Row = (HashMap<Integer, Integer>)this._peer2RowIndices2Data.get(node);
        if (info2Row == null) {
            info2Row = new HashMap<Integer, Integer>();
            this._peer2RowIndices2Data.put(node, info2Row);
        }
        int ifIndex = vbl.intValue(0);
        info2Row.put(new Integer(ifIndex), new Integer(this._responseData.size() - 1));
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            if (!((SnmpOID)firstOid).startsWith(_fcIfOperModeOid)) {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
            this.processIfMibData(node, pdu.getVariables());
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    void processIfMibData(SnmpPeer node, VarBindList vbl) {
        HashMap info2Row = (HashMap)this._peer2RowIndices2Data.get(node);
        if (info2Row == null) {
            return;
        }
        Set rowNs = info2Row.keySet();
        Object[] rowIfIndexbjs = rowNs.toArray();
        int i = 0;
        for (int j = 0; i < vbl.size() && j < rowIfIndexbjs.length; i += 4, ++j) {
            Integer rowNObj = (Integer)info2Row.get(rowIfIndexbjs[j]);
            if (rowNObj == null || vbl.getVb(i).getVar() instanceof SnmpNull || vbl.getVb(i + 1).getVar() instanceof SnmpNull) continue;
            int rowN = rowNObj;
            Object[] row = (Object[])this._responseData.elementAt(rowN);
            row[8 + this._offset] = this.toCell(this._mibNodes[8 + this._offset], vbl.getVb(i).getVar(), this._vars[8], rowN);
            row[9 + this._offset] = this.toCell(this._mibNodes[9 + this._offset], vbl.getVb(i + 1).getVar(), this._vars[9], rowN);
            row[10 + this._offset] = this.toCell(this._mibNodes[10 + this._offset], vbl.getVb(i + 2).getVar(), this._vars[10], rowN);
            row[11 + this._offset] = this.toCell(this._mibNodes[11 + this._offset], vbl.getVb(i + 3).getVar(), this._vars[11], rowN);
        }
    }

    @Override
    public int[] getIndex(int row, int col) {
        if (col == 9 + this._offset) {
            Object[] rowData = (Object[])this._responseData.elementAt(row);
            int pcIfIndex = ((SnmpInt)rowData[0 + this._offset]).getValue();
            int[] index = new int[]{pcIfIndex};
            return index;
        }
        return super.getIndex(row, col);
    }

    @Override
    protected boolean isMIBVarCreatable(String mibName) {
        if (!mibName.equals("ifAdminStatus")) {
            return super.isMIBVarCreatable(mibName);
        }
        return false;
    }
}

