/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmPsmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;

public class SmPsmFabricBindTableModel
extends SmPsmTableModel {
    private static final int DMID_POST30_COL = 3;
    private static final int DMID_PRIOR30_COL = 4;
    private static final int[] _cpsmFabricBindDomIdRev1Oid = MibNode.get("cpsmFabricBindDomIdRev1").getOid();
    private static final int[] _cpsmFabricBindDomIdOid = MibNode.get("cpsmFabricBindDomId").getOid();

    public SmPsmFabricBindTableModel(int vsanId) {
        super(vsanId);
    }

    public SmPsmFabricBindTableModel(Vsan vsan) {
        super(vsan);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean isVer30Above = sw.isVersionGreaterThanEqual("3.0(0)");
        if (!isVer30Above) {
            row[3] = row[4];
        }
        return row;
    }
}

