/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmIpAddressTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import java.util.HashMap;

public class SmRadiusServerTableModel
extends SmIpAddressTableModel {
    boolean _bNeedRefresh = false;
    static final int SERVERTYPE_PRIMARY = 2;
    static final int SERVERKEYTYPE_COL = 5;
    static final int SERVERKEY_COL = 6;
    static final String SERVERKEYTYPE_PLAINTEXT = "plaintext";
    static final String SERVERKEYTYPE_ENCRYPTED = "encrypted";
    static final int[] _serverKeyOid = MibNode.get("crRadiusServerKey").getOid();

    public SmRadiusServerTableModel() {
        this._addrVar = "crRadiusServerAddr";
        this._addrTypeVar = "crRadiusServerAddrType";
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        byte[] authInfo = vbl.byteValue(4);
        if (authInfo.length != 0) {
            if (authInfo[0] == 112 || authInfo[0] == 101) {
                row[5] = authInfo[0] == 101 ? new SnmpString(SERVERKEYTYPE_ENCRYPTED) : new SnmpString(SERVERKEYTYPE_PLAINTEXT);
                byte[] key = new byte[authInfo.length - 1];
                System.arraycopy(authInfo, 1, key, 0, authInfo.length - 1);
                row[6] = new SnmpString(key);
            } else {
                row[5] = "";
                row[6] = "";
            }
        }
        return row;
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return null;
        }
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            int[] index = this.getIndex(cell._row);
            SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
            if (oid.startsWith(_serverKeyOid)) {
                SnmpVar changedCellVar = this.getChangedCell(cell._row, cell._col);
                if (cell._col == 5 && i + 1 < cells.size()) {
                    Cell nextcell = (Cell)cells.elementAt(i + 1);
                    int[] nextindex = this.getIndex(nextcell._row);
                    SnmpOID nextoid = new SnmpOID(this._mibNodes[nextcell._col].getOid(), nextindex);
                    if (nextcell._row == cell._row && nextoid.startsWith(_serverKeyOid)) {
                        ++i;
                    }
                }
                byte[] authKeyType = ((SnmpString)this.getValueAt(cell._row, 5)).getValue();
                byte[] authKey = ((SnmpString)this.getValueAt(cell._row, 6)).getValue();
                if (authKeyType.length == 0 && authKey.length != 0) {
                    throw new Exception("Please make a selection for AuthKeyType for row " + (cell._row + 1));
                }
                if (authKeyType.length != 0 && authKey.length == 0) {
                    throw new Exception("Please enter a value for AuthKey for row " + (cell._row + 1));
                }
                byte[] newAuthKey = new byte[authKey.length + 1];
                newAuthKey[0] = authKeyType[0];
                System.arraycopy(authKey, 0, newAuthKey, 1, authKey.length);
                changedCellVar = new SnmpString(newAuthKey);
                pdu.addVar(oid, changedCellVar);
                continue;
            }
            this.processChangedCell(cell, pdu, oid, index);
        }
        return pdus;
    }

    @Override
    public boolean applyChanges() throws Exception {
        this._bNeedRefresh = false;
        boolean bChangesApplied = super.applyChanges();
        if (this._bNeedRefresh) {
            BrowserFrame.getDataView().refresh();
        }
        return bChangesApplied;
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        SnmpInt serverType;
        if (changedCellOid.startsWith(MibNode.get("crRadiusServerType").getOid()) && (serverType = (SnmpInt)this.getChangedCell(cell._row, cell._col)).getValue() == 2) {
            this._bNeedRefresh = true;
        }
        return super.processChangedCell(cell, pdu, changedCellOid, index);
    }
}

