/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.util.HashMap;

public class SmRadiusTableModel
extends SmTableModel {
    static final int AUTHKEYTYPE_COL = 2;
    static final int AUTHKEY_COL = 3;
    static final String AUTHKEYTYPE_PLAINTEXT = "plaintext";
    static final String AUTHKEYTYPE_ENCRYPTED = "encrypted";
    static final int[] _authKeyOid = MibNode.get("crRadiusAuthKey").getOid();

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = new Object[vbl.size() + this._offset + 1];
        this._responseData.addElement(row);
        row[0] = node;
        if (index != null) {
            row[1] = index;
        }
        for (int i = 0; i < vbl.size(); ++i) {
            row[i + this._offset] = this.toCell(this._mibNodes[i + this._offset], vbl.getVb(i).getVar(), this._vars[i], this._responseData.size() - 1);
        }
        byte[] authInfo = vbl.byteValue(1);
        if (authInfo.length != 0) {
            if (authInfo[0] == 112 || authInfo[0] == 101) {
                row[2] = authInfo[0] == 101 ? new SnmpString(AUTHKEYTYPE_ENCRYPTED) : new SnmpString(AUTHKEYTYPE_PLAINTEXT);
                byte[] key = new byte[authInfo.length - 1];
                System.arraycopy(authInfo, 1, key, 0, authInfo.length - 1);
                row[3] = new SnmpString(key);
            } else {
                row[2] = "";
                row[3] = "";
            }
        }
        this.updateGetProgress();
        return row;
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return null;
        }
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            int[] index = this.getIndex(cell._row);
            SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
            SnmpVar changedCellVar = this.getChangedCell(cell._row, cell._col);
            if (oid.startsWith(_authKeyOid)) {
                if (cell._col == 2 && i + 1 < cells.size()) {
                    Cell nextcell = (Cell)cells.elementAt(i + 1);
                    int[] nextindex = this.getIndex(nextcell._row);
                    SnmpOID nextoid = new SnmpOID(this._mibNodes[nextcell._col].getOid(), nextindex);
                    if (nextcell._row == cell._row && nextoid.startsWith(_authKeyOid)) {
                        ++i;
                    }
                }
                byte[] authKeyType = ((SnmpString)this.getValueAt(cell._row, 2)).getValue();
                byte[] authKey = ((SnmpString)this.getValueAt(cell._row, 3)).getValue();
                if (authKeyType.length == 0 && authKey.length != 0) {
                    throw new Exception("Please make a selection for AuthKeyType for row " + (cell._row + 1));
                }
                if (authKeyType.length != 0 && authKey.length == 0) {
                    throw new Exception("Please enter a value for AuthKey for row " + (cell._row + 1));
                }
                byte[] newAuthKey = new byte[authKey.length + 1];
                newAuthKey[0] = authKeyType[0];
                System.arraycopy(authKey, 0, newAuthKey, 1, authKey.length);
                changedCellVar = new SnmpString(newAuthKey);
            }
            pdu.addVar(oid, changedCellVar);
        }
        return pdus;
    }
}

