/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.PeerIdKey;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EndPort;
import java.util.HashMap;

public class SmScsiFlowModel
extends SmTableModel {
    private static final int INIT = 2;
    private static final int TARGET = 4;
    private static final int WRTACC = 6;
    private static final int BUFCNT = 7;
    private static final int STATSON = 8;
    private static final int CLEARSTATS = 9;
    private static HashMap _FlowsById;

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        try {
            Wwn init = new Wwn((SnmpString)row[2]);
            Wwn target = new Wwn((SnmpString)row[4]);
            EndPort endportInit = ClientController.getInstance().getFabric().findEndPortByWwn(init);
            row[2] = endportInit != null ? endportInit : init;
            EndPort endportTarget = ClientController.getInstance().getFabric().findEndPortByWwn(target);
            row[4] = endportTarget != null ? endportTarget : target;
            if (_FlowsById == null) {
                _FlowsById = new HashMap();
            }
            int[] oid = index.getValue();
            _FlowsById.put(new PeerIdKey(node, oid[oid.length - 1]), new Object[]{row[2], row[4]});
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.error((Object)ex);
        }
        return row;
    }

    @Override
    public void clear() {
        super.clear();
        _FlowsById = new HashMap();
    }

    public static Object[] getFlow(SnmpPeer peer, int id) {
        if (_FlowsById != null) {
            PeerIdKey pidKey = new PeerIdKey(peer, id);
            return (Object[])_FlowsById.get(pidKey);
        }
        return null;
    }

    @Override
    protected String getInsertTitle(SnmpKTable table) {
        return "FC Write Acceleration - Create" + ClientController.getInstance().getDialogFabricTitlePostfix();
    }

    @Override
    public String[] getInsertVars() {
        String[] vars = new String[]{"ciscoScsiFlowId", "-Initiator (List shows zoned ports on all SSM cards)", "ciscoScsiFlowIntrWwn", "ciscoScsiFlowIntrVsan", "-Target (List shows visible ports to selected initiator)", "ciscoScsiFlowTargetWwn", "ciscoScsiFlowTargetVsan", "-Options", "ciscoScsiFlowWriteAcc", "ciscoScsiFlowBufCount", "ciscoScsiFlowStatsEnabled"};
        return vars;
    }

    @Override
    public boolean isCellActive(int row, int col) {
        Object o = null;
        switch (col) {
            case 7: {
                o = this.getValueAt(row, 6);
                if (o instanceof Boolean) {
                    return (Boolean)o;
                }
                return false;
            }
            case 9: {
                o = this.getValueAt(row, 8);
                if (o instanceof Boolean) {
                    return (Boolean)o;
                }
                return false;
            }
        }
        return super.isCellActive(row, col);
    }
}

