/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmFeatureControlTableModel;
import java.util.HashMap;
import java.util.Iterator;

public class SmSmeFeatureControlTableModel
extends SmFeatureControlTableModel {
    static final int[] _HelloOid = MibNode.get("fspfIfHelloInterval").getOid();
    static final int[] _DeadOid = MibNode.get("fspfIfDeadInterval").getOid();
    static final int[] _ActionOid = MibNode.get("cfcFeatureCtrlAction").getOid();
    static final int CLUSTER = 32;
    static final int SME = 33;

    public SmSmeFeatureControlTableModel(int[][] ownerIndcies) {
        super(ownerIndcies);
    }

    @Override
    protected void addChangedCells2Pdu(HashMap pdus, Array cells, Array warningMsg) throws Exception {
        super.addChangedCells2Pdu(pdus, cells, warningMsg);
        Iterator pduMap = pdus.values().iterator();
        Iterator peers = pdus.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (pduMap.hasNext()) {
            SnmpPDU pdu = (SnmpPDU)pduMap.next();
            if (pdu.getVariables().size() == 0) continue;
            SnmpPeer peer = (SnmpPeer)peers.next();
            VarBindList vbl = pdu.getVariables();
            int clusterSmeFlag = 0;
            int action = 0;
            for (int i = 0; i < vbl.size(); ++i) {
                int feature;
                int[] oid = vbl.getOid(i).getValue();
                if (!SnmpOID.startsWith(oid, _ActionOid) || (feature = oid[oid.length - 1]) != 32 && feature != 33) continue;
                if (clusterSmeFlag == 0) {
                    ++clusterSmeFlag;
                    action = vbl.intValue(i);
                    continue;
                }
                if (clusterSmeFlag != 1 || vbl.intValue(i) != action) break;
                ++clusterSmeFlag;
                break;
            }
            if (clusterSmeFlag != 2) continue;
            if (sb.toString().length() == 0) {
                sb.append("Please enable cluster then sme or\ndisable sme then cluster\nfor the following switch(es):");
            }
            sb.append("\n");
            sb.append(peer.toString());
        }
        if (sb.toString().length() > 0) {
            throw new Exception(sb.toString());
        }
    }
}

