/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.sm.client.dialogs.SmAsmBaseTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SmSsmProvTableModel
extends SmAsmBaseTableModel
implements ActionListener {
    JCheckBox _allChkBox;
    boolean _forceRemove = false;
    static final int[] _ssmProvFeatureIfForceRemoveOid = MibNode.get("ssmProvFeatureIfForceRemove").getOid();

    public SmSsmProvTableModel() {
        this._asmTimeout = 60000;
        DataView dataView = BrowserFrame.getDataView();
        JPanel actPanel = new JPanel(new FlowLayout(0, 2, 2));
        this._allChkBox = new JCheckBox("Reboot Module on Delete");
        this._allChkBox.setToolTipText("Force reboot module when delete selected rows");
        this._allChkBox.addActionListener(this);
        actPanel.add(this._allChkBox);
        JPanel newToolbar = new JPanel(new FlowLayout(2, 2, 2));
        newToolbar.add(dataView.getDefaultButtonPanel());
        newToolbar.add(actPanel);
        dataView.replaceButtonPanel(newToolbar);
    }

    @Override
    public boolean deleteRowsAction(int[] rows) throws Exception {
        if (this._forceRemove) {
            Object[] options = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(BrowserFrame.getInstance(), "<html>Reboot card could possibly bring the switch down and essentially cause data loss.<p>Are you sure you want to reboot card when delete the selected row?</html>", "DCNM-SAN", -1, 2, null, options, options[0]) == 1) {
                return false;
            }
        }
        return super.deleteRowsAction(rows);
    }

    @Override
    protected SnmpPDU processDeleteRow(SnmpPeer node, SnmpPDU pdu, int rowN) {
        SnmpPDU newPdu = super.processDeleteRow(node, pdu, rowN);
        if (this._forceRemove) {
            newPdu.addVar(new SnmpOID(_ssmProvFeatureIfForceRemoveOid, this.getIndex(rowN)), new SnmpInt(1));
        }
        return newPdu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this._forceRemove = ((JCheckBox)e.getSource()).isSelected();
        }
    }
}

