/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.map.MDSN7KSwitchNode;
import com.cisco.dcbu.sm.client.map.MDSSwitchNode;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SmSwitchTableModel
extends SmTableModel
implements ActionListener {
    public static final String STRING_NAME = "Logical Name";
    public static final String STRING_IPADR = "IP Address";
    public static final String STRING_WWN = "WWN";
    public static final String STRING_VENDOR = "Vendor";
    public static final String STRING_MODEL = "Model";
    public static final String STRING_RELEASE = "Release";
    public static final String STRING_LOCATION = "Location";
    String[] _headers = new String[]{"Logical Name", "IP Address", "WWN", "Status", "Vendor", "Model", "Release", "Location", "Contact", "System UpTime", "NumFCPorts", "VDC Id", "FCoE Enabled"};
    static final boolean[] _colEditable = new boolean[]{true, true, false, false, false, false, false, true, true, false, false, false, false};
    public static final int NAME = 0;
    public static final int IPADR = 1;
    public static final int WWN = 2;
    public static final int STATUS = 3;
    public static final int VENDOR = 4;
    public static final int MODEL = 5;
    public static final int RELEASE = 6;
    public static final int LOCATION = 7;
    public static final int CONTACT = 8;
    public static final int UPTIME = 9;
    public static final int NUMPORTS = 10;
    public static final int VDC_ID = 11;
    public static final int FCOE_STATUS = 12;
    public static final int SW_INFO = 14;
    MgmtDomainIf _mgmtDomain = null;
    JButton _locateSwitchBtn;
    protected Logger _logger = LogManager.getLogger(this.getClass());
    private static final String[] NEW_BUTTON = new String[]{null, "Locate...", "L"};

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < invoker.length; ++i) {
            peers.add(invoker[i].getSnmpPeer());
        }
        return this.getVars(peers.toArray(new SnmpPeer[peers.size()]));
    }

    public SmSwitchTableModel() {
        this.init();
    }

    public SmSwitchTableModel(MgmtDomainIf mgmtDomain) {
        this._mgmtDomain = mgmtDomain;
        this.init();
    }

    @Override
    public JMenuItem[] getMapMenuItems() {
        if (this.isN7K(this._leadIndex)) {
            return MDSN7KSwitchNode.getMenuItemsForTable(null);
        }
        if (this.isMDSOrQuail(this._leadIndex)) {
            return MDSSwitchNode.getMenuItemsForTable(null);
        }
        return SwitchNode.getMenuItemsForTable(null);
    }

    private void init() {
        DataView dataView = BrowserFrame.getDataView();
        this._locateSwitchBtn = dataView.insertButton(0, new String[][]{NEW_BUTTON}, new ActionListener[]{this});
        if (this._locateSwitchBtn != null) {
            this._locateSwitchBtn.setVisible(false);
        }
        this.adjustHeader();
    }

    private void adjustHeader() {
        if (this._mgmtDomain != null) {
            if (this._mgmtDomain.isDataCenter()) {
                this._headers[2] = "WWN/Serial Number/Switch Id";
                this._headers[10] = "NumPorts";
            } else if (this._mgmtDomain.isLAN() || this._mgmtDomain.isVlan()) {
                this._headers[2] = "Serial Number/Switch Id";
                this._headers[10] = "NumPorts";
            } else {
                this._headers[2] = STRING_WWN;
                this._headers[10] = "NumFCPorts";
            }
        }
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, 0);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._mibVars = mibVars;
        this._prefixes = prefixes;
        this.setHeaders(this._headers);
        this.setEditable(_colEditable);
        this._isEditable = true;
        this.setData(new Array());
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        return this.getVars(nodes);
    }

    @Override
    public Array getVars(SnmpPeer[] nodes) throws SnmpException {
        MgmtDomainIf mgmtDomain;
        this._responseData = new Array();
        MgmtDomainIf mgmtDomainIf = mgmtDomain = this._mgmtDomain != null ? this._mgmtDomain : ClientController.getInstance().getSelectedDomain();
        if (mgmtDomain == null) {
            return this.getFabricSwitchData(mgmtDomain);
        }
        if (mgmtDomain.isDataCenter()) {
            return this.getDataCenterSwitchData(mgmtDomain);
        }
        if (mgmtDomain.isLAN() || mgmtDomain.isVlan()) {
            return this.getLANSwitchData(mgmtDomain);
        }
        return this.getFabricSwitchData(mgmtDomain);
    }

    protected Array getDataCenterSwitchData(MgmtDomainIf mgmtDomain) {
        Map<PKIf, PKIf> allCoexistSwPKs = null;
        boolean isIpAdrOrNameEmpty = false;
        Object[] sw = mgmtDomain.getAbstractSwitches();
        if (sw == null) {
            return this._responseData;
        }
        try {
            allCoexistSwPKs = ClientController.getInstance().getAllCoexistSwPKs();
        }
        catch (Exception e1) {
            this._logger.error((Object)e1);
        }
        if (allCoexistSwPKs == null) {
            allCoexistSwPKs = new HashMap<PKIf, PKIf>();
        }
        Arrays.sort(sw);
        for (int j = 0; j < sw.length; ++j) {
            Object[] row = new Object[this._headers.length + 2];
            Object s = sw[j];
            this.processRowData(row, (AbstractSwitch)s);
            if (((AbstractModelObject)s).isEthObject()) {
                EthSwitch ethSw = (EthSwitch)s;
                row[2] = ethSw.getPK().toString();
            } else {
                row[2] = SnmpString.toHexString(((Switch)s).getWwn().getValue());
            }
            if (!allCoexistSwPKs.isEmpty()) {
                Switch fcSwitch;
                PKIf fcSwitchPK;
                PKIf ethSwitchPK;
                if (((AbstractModelObject)s).isFcObject()) {
                    AbstractSwitch ethSwitch;
                    PKIf ethSwitchPK2;
                    PKIf fcSwitchPK2 = ((AbstractModelObject)s).getPK();
                    if (fcSwitchPK2 != null && (ethSwitchPK2 = allCoexistSwPKs.get(fcSwitchPK2)) != null && (ethSwitch = DataCenter.getInstance().findSwitchByPK(ethSwitchPK2)) != null) {
                        row[10] = new Integer((Integer)row[10] + ethSwitch.getNumPorts());
                    }
                } else if (((AbstractModelObject)s).isEthObject() && (ethSwitchPK = ((AbstractModelObject)s).getPK()) != null && (fcSwitchPK = allCoexistSwPKs.get(ethSwitchPK)) != null && (fcSwitch = DataCenter.getInstance().findSwitchByPK((WwnKey)fcSwitchPK)) != null) continue;
            }
            this._responseData.addElement(row);
        }
        return this._responseData;
    }

    protected Array getLANSwitchData(MgmtDomainIf mgmtDomain) {
        Object[] sw = mgmtDomain.getEthSwitches();
        if (sw == null) {
            return this._responseData;
        }
        Arrays.sort(sw);
        for (int j = 0; j < sw.length; ++j) {
            Object[] row = new Object[this._headers.length + 2];
            Object s = sw[j];
            this.processRowData(row, (AbstractSwitch)s);
            EthSwitch ethSw = (EthSwitch)s;
            row[2] = ethSw.getPK().toString();
            this._responseData.addElement(row);
        }
        return this._responseData;
    }

    protected Array getFabricSwitchData(MgmtDomainIf mgmtDomain) {
        Object[] sw = null;
        sw = mgmtDomain == null ? San.getInstance().getSwitches() : mgmtDomain.getSwitches();
        if (sw == null) {
            return this._responseData;
        }
        Arrays.sort(sw);
        for (int j = 0; j < sw.length; ++j) {
            Object[] row = new Object[this._headers.length + 2];
            Object s = sw[j];
            this.processRowData(row, (AbstractSwitch)s);
            row[2] = SnmpString.toHexString(((Switch)s).getWwn().getValue());
            this._responseData.addElement(row);
        }
        return this._responseData;
    }

    protected void processRowData(Object[] row, AbstractSwitch sw) {
        boolean isIpAdrOrNameEmpty = false;
        String name = sw.getSysName();
        row[0] = new SnmpString(name == null ? "" : name);
        String ipAddr = sw.getIpAddress();
        Object object = row[1] = ipAddr == null ? "" : ipAddr;
        if (ipAddr == null && !isIpAdrOrNameEmpty) {
            isIpAdrOrNameEmpty = true;
            this._locateSwitchBtn.setVisible(true);
        }
        row[3] = sw.getStatus();
        row[4] = sw.getVendor();
        row[5] = sw.getModel();
        row[6] = sw.getVersion();
        row[9] = sw.getSwitchUpTime();
        row[10] = sw.isFcObject() ? new Integer(sw.getNumFcPorts()) : "n/a";
        row[2] = "";
        row[7] = new SnmpString(sw.getLocation() == null ? "" : sw.getLocation());
        row[8] = new SnmpString(sw.getContact() == null ? "" : sw.getContact(), true);
        row[14] = sw;
        row[12] = sw.isFeatureEnabled(AbstractSwitchBase.Feature.FCOE.flag()) ? "true" : "false";
        row[11] = sw.getVdcId() == -1 ? "" : Integer.valueOf(sw.getVdcId());
    }

    @Override
    public boolean applyChanges() throws Exception {
        int i;
        Array cells = this.getChanged();
        if (cells == null) {
            return false;
        }
        if (!super.applyChanges()) {
            return false;
        }
        ArrayList<Fabric> fabrics = new ArrayList<Fabric>();
        boolean isIpAddrChg = false;
        for (i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            AbstractSwitch sw = (AbstractSwitch)this.getValueAt(cell._row, 14);
            if (cell._col == 1) {
                isIpAddrChg = true;
                ClientController.setIpAddress(sw, InetAddress.getByName(this.getValueAt(cell._row, cell._col).toString()));
                continue;
            }
            SnmpString changedCellVar = (SnmpString)this.getValueAt(cell._row, cell._col);
            String value = changedCellVar.toString();
            switch (cell._col) {
                case 0: {
                    sw.setSysName(value);
                    break;
                }
                case 7: {
                    sw.setSysLocation(value);
                    break;
                }
                case 8: {
                    sw.setSysContact(value);
                }
            }
            if (sw.getFabric() == null || fabrics.contains(sw.getFabric())) continue;
            fabrics.add(sw.getFabric());
        }
        for (i = 0; i < fabrics.size(); ++i) {
            ((Fabric)fabrics.get(i)).firePropertyChangeEvents();
        }
        if (isIpAddrChg) {
            boolean isIpAdrOrNameEmpty = false;
            for (int i2 = 0; i2 < this._responseData.size(); ++i2) {
                Object[] row = (Object[])this._responseData.elementAt(i2);
                if (row[1] != null && !((String)row[1]).equals("")) continue;
                isIpAdrOrNameEmpty = true;
                break;
            }
            this._locateSwitchBtn.setVisible(isIpAdrOrNameEmpty);
        }
        return true;
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return null;
        }
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        for (int i = 0; i < cells.size(); ++i) {
            int[] oid;
            Cell cell = (Cell)cells.elementAt(i);
            AbstractSwitch sw = (AbstractSwitch)this.getValueAt(cell._row, 14);
            if (cell._col == 1) {
                ClientController.setIpAddress(sw, InetAddress.getByName(this.getValueAt(cell._row, cell._col).toString()));
                continue;
            }
            SnmpPeer node = sw.getPeer();
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            if ((oid = this.getMibOid(cell._col)) == null) continue;
            if (cell._col == 8) {
                SnmpString s = (SnmpString)this.getValueAt(cell._row, cell._col);
                pdu.addVar(new SnmpOID(oid, 0), s);
                continue;
            }
            pdu.addVar(new SnmpOID(oid, 0), new SnmpString(this.getValueAt(cell._row, cell._col).toString()));
        }
        return pdus;
    }

    @Override
    public Object getSetValueAt(Object aValue, int row, int col) {
        Object[] data;
        Object target;
        if (col == 8 && (target = (data = (Object[])this.getData().elementAt(row))[col]) instanceof SnmpString) {
            aValue = new SnmpString(aValue.toString(), true);
            return aValue;
        }
        return super.getSetValueAt(aValue, row, col);
    }

    private int[] getMibOid(int col) {
        switch (col) {
            case 0: {
                return MibNode.get("sysName").getOid();
            }
            case 7: {
                return MibNode.get("sysLocation").getOid();
            }
            case 8: {
                return MibNode.get("sysContact").getOid();
            }
        }
        return null;
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        this.mapSelectDevice(table);
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[14];
    }

    public boolean isMDSOrQuail(int index) {
        if (index < 0) {
            return false;
        }
        AbstractSwitch sw = (AbstractSwitch)this.getValueAt(index, 14);
        if (sw != null && !sw.isEthObject()) {
            return ((Switch)sw).isMDSOrQuail();
        }
        return false;
    }

    public boolean isN7K(int index) {
        if (index < 0) {
            return false;
        }
        AbstractSwitch sw = (AbstractSwitch)this.getValueAt(index, 14);
        if (sw != null) {
            return sw.isN7K();
        }
        return false;
    }

    @Override
    public boolean isCellActive(int row, int col) {
        AbstractSwitch sw = (AbstractSwitch)this.getValueAt(row, 14);
        if (col == 1) {
            return !sw.isManageable();
        }
        if (col == 0 || col == 7 || col == 8) {
            return sw.getPeer() != null;
        }
        return super.isCellActive(row, col);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            UIActions.getInstance().locateSwitches(null);
        }
    }
}

