/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.InterfaceIndex;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.vsif.VSifObj;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmCacheUtil;
import com.cisco.dcbu.sm.client.dialogs.SmFcInterfaceTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class SmVFCifGeneralTableModel
extends SmFcInterfaceTableModel
implements MouseListener {
    static final int FC_ADMIN_INDEX = 0;
    static final int FC_OPER_INDEX = 1;
    static final int VSANIF_INDEX = 2;
    static final int IF_ALIAS_INDEX = 4;
    static final int BIND_TYPE_INDEX = 5;
    static final int BIND_IFINDEX_INDEX = 6;
    static final int BIND_MAC_INDEX = 7;
    static final int FCF_PRIORITY_INDEX = 8;
    static final int SERVICE_INDEX = 9;
    static final int IF_ADMINSTATUS_INDEX = 10;
    static final int IF_OPERSTATUS_INDEX = 11;
    static final int IF_FAILURECAUSE_INDEX = 12;
    static final int IF_LASTCHANGE_INDEX = 14;
    static final int[] _ifAliasOid = MibNode.get("ifAlias").getOid();
    static final int[] _ifAdminStatusOid = MibNode.get("ifAdminStatus").getOid();
    static final int[] _ifOperStatusOid = MibNode.get("ifOperStatus").getOid();
    static final int[] _ifLastChangeOid = MibNode.get("ifLastChange").getOid();
    static final int[] _fcIfAdminModeOid = MibNode.get("fcIfAdminMode").getOid();
    static final int[] _bindIfIndexOid = MibNode.get("cfcoeStaticVfcBindIfIndex").getOid();
    static final int[][] _VFCOid = new int[][]{MibNode.get("cfcoeStaticVfcIndex").getOid(), MibNode.get("cfcoeStaticVfcBindType").getOid(), MibNode.get("cfcoeStaticVfcBindIfIndex").getOid(), MibNode.get("cfcoeStaticVfcBindMACAddress").getOid()};
    static final int SPEED_10G = 10000;
    protected HashMap<SnmpPeer, TreeMap<Integer, Integer>> ethPortToSpeedByPeerMap = new HashMap();
    protected HashMap<SnmpPeer, HashMap<Integer, Integer>> vfcBindMap = new HashMap();

    public SmVFCifGeneralTableModel(int ifType) {
        super(ifType);
        BrowserFrame.getTable().addMouseListener(this);
    }

    public SmVFCifGeneralTableModel(int ifType, String bitmap, String tooltip, int insertBefore, String action, ActionListener listener) {
        super(ifType, bitmap, tooltip, insertBefore, action, listener);
        BrowserFrame.getTable().addMouseListener(this);
    }

    @Override
    protected void setSpecialAttr() {
        SmTableModel.SmTableModelCellChecker[] checkers = new SmTableModel.SmTableModelCellChecker[1];
        String mibNameVsanId = "vsanIfVsan";
        String warningMsgVsanId = "Changing the Port VSAN may affect I/O. Continue?";
        checkers[0] = new SmTableModel.SmTableModelCellChecker(this, mibNameVsanId, null, warningMsgVsanId, true);
        this.setCellChecker(checkers);
    }

    @Override
    protected int[] buildGetVBLIndex(SnmpPeer node, int[] index, int mibNodeIndex) {
        int mibNodeIndexWithoutOffset = mibNodeIndex - this._offset;
        if (mibNodeIndexWithoutOffset >= 5 && mibNodeIndexWithoutOffset <= 8) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            return this.getCellGetIndex(sw, mibNodeIndex, index);
        }
        return super.buildGetVBLIndex(node, index, mibNodeIndex);
    }

    @Override
    protected int[] getCellGetIndex(Switch sw, int col, int[] defaultIndex) {
        int mibNodeIndexWithoutOffset = col - this._offset;
        if (mibNodeIndexWithoutOffset >= 5 && mibNodeIndexWithoutOffset <= 8) {
            int vsifIfIndex = defaultIndex[0];
            if (sw.getType(vsifIfIndex) != 30) {
                return new int[]{0};
            }
            return IfIndexUtil.ifIndexToVfcTableIndex(vsifIfIndex, sw);
        }
        return super.getCellGetIndex(sw, col, defaultIndex);
    }

    @Override
    protected SnmpPDU processDeleteRow(SnmpPeer node, SnmpPDU pdu, int rowN) {
        int vsifIfIndex = this.getIndex(rowN)[0];
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        if (sw != null) {
            pdu.addVar(new SnmpOID(this._rowStatus, IfIndexUtil.ifIndexToVfcTableIndex(vsifIfIndex, sw)), new SnmpInt(this._deleteValue));
        }
        return pdu;
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._responseData = new Array();
        if (nodes == null || nodes.length == 0) {
            return this._responseData;
        }
        for (SnmpPeer node : nodes) {
            try {
                this.populateSpeeds(node);
            }
            catch (SnmpException e) {
                DefaultLogger._ExLogger.warn((Object)("Error populating speeds:" + e.getMessage()), (Throwable)e);
            }
        }
        SmCacheUtil.getInstance().clearEntries("cfcoeStaticVfcBindIfIndex");
        return super.getTableVars(nodes);
    }

    @Override
    public Array getTableVars(SmFilter[] invoker, boolean setViewFilter) throws SnmpException {
        SmCacheUtil.getInstance().clearEntries("cfcoeStaticVfcBindIfIndex");
        Array data = super.getTableVars(invoker, setViewFilter);
        for (SmFilter filter : invoker) {
            this.updateEthernetInterfaces(filter.getSnmpPeer());
        }
        return data;
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer peer, SnmpOID index) {
        SnmpInt ifIndex = (SnmpInt)vbl.get(6).getVar();
        int bindIf = ifIndex.getValue();
        if (bindIf > 0) {
            int vfcIndex = index.getValue()[0];
            HashMap<Integer, Integer> bindIfMap = this.vfcBindMap.get(peer);
            if (bindIfMap == null) {
                bindIfMap = new HashMap();
            }
            bindIfMap.put(bindIf, vfcIndex);
            this.vfcBindMap.put(peer, bindIfMap);
        }
        return super.addElement(vbl, peer, index);
    }

    @Override
    protected boolean isEnd(SnmpPeer peer, int[] req, SnmpVarBind vb, int[] index, int reqId) {
        boolean done = super.isEnd(peer, req, vb, index, reqId);
        if (done) {
            this.updateEthernetInterfaces(peer);
        }
        return done;
    }

    private void updateEthernetInterfaces(SnmpPeer peer) {
        String label = "";
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        HashMap<Integer, String> ifLabel = new HashMap<Integer, String>();
        HashMap<Integer, Integer> bindMap = this.vfcBindMap.get(peer);
        HashMap labelMap = SmCacheUtil.getInstance().getMap("EthernetInterfaceLabels");
        HashMap lMap = (HashMap)labelMap.get(peer);
        VarBindList vethVbl = new VarBindList();
        int[] VETH_BINDING_IF_OID = MibNode.get("cvifBindingIfIndex").getOid();
        if (bindMap == null) {
            return;
        }
        for (Map.Entry<Integer, Integer> entry : bindMap.entrySet()) {
            Integer bindIf = entry.getKey();
            Integer vfcIf = entry.getValue();
            if (sw.getType(bindIf) == 28) {
                int vethId = Integer.parseInt(sw.ifIndexToName(bindIf).replace("veth", ""));
                int[] vethIndex = new int[]{vethId, 6};
                vethVbl.add(VETH_BINDING_IF_OID, vethIndex);
                continue;
            }
            label = sw.ifIndexToName(bindIf);
            ifLabel.put(bindIf, label);
            ifLabel.put(vfcIf, label + "->" + sw.ifIndexToName(vfcIf));
            SmCacheUtil.getInstance().addEntry("cfcoeStaticVfcBindIfIndex", peer, new SnmpInt(bindIf).toString());
            SmCacheUtil.getInstance().addEntry("cfcoeStaticVfcBindIfIndex", peer, new SnmpInt(vfcIf).toString());
        }
        if (lMap != null) {
            ifLabel.putAll(lMap);
        }
        labelMap.put(peer, ifLabel);
        SmCacheUtil.getInstance().setMap("EthernetInterfaceLabels", labelMap);
        try {
            new SnmpFetch().get(peer, vethVbl, new SnmpCallbackIf(){

                @Override
                public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
                    SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
                    if (SmVFCifGeneralTableModel.this.checkSnmpCallbackErr(peer, pdu, timedOut)) {
                        DefaultLogger._ExLogger.warn((Object)"Could not get binding ethernet interfaces for vETHs.");
                        return;
                    }
                    String label = "";
                    Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                    HashMap<Integer, String> ifLabel = new HashMap<Integer, String>();
                    HashMap<Integer, Integer> bindMap = SmVFCifGeneralTableModel.this.vfcBindMap.get(peer);
                    HashMap labelMap = SmCacheUtil.getInstance().getMap("EthernetInterfaceLabels");
                    HashMap lMap = (HashMap)labelMap.get(peer);
                    VarBindList respVbl = pdu.getVariables();
                    for (int i = 0; i < respVbl.size(); ++i) {
                        int vethId = respVbl.get(i).getOid().getIndexFromEnd(1);
                        int bindIf = IfIndexUtil.vfcIndexToIfIndex(vethId, 28);
                        int ethPortIfIndex = respVbl.intValue(i);
                        if (ethPortIfIndex == 0) {
                            DefaultLogger._ExLogger.warn((Object)("Invalid binding ethernet interface for vETH: " + sw.ifIndexToName(bindIf)));
                        }
                        label = sw.ifIndexToName(ethPortIfIndex);
                        ifLabel.put(ethPortIfIndex, label);
                        label = label + "->" + sw.ifIndexToName(bindIf);
                        ifLabel.put(bindIf, label);
                        int vfcId = bindMap.get(bindIf);
                        label = label + "->" + sw.ifIndexToName(vfcId);
                        ifLabel.put(vfcId, label);
                        SmCacheUtil.getInstance().addEntry("cfcoeStaticVfcBindIfIndex", peer, new SnmpInt(ethPortIfIndex).toString());
                        SmCacheUtil.getInstance().addEntry("cfcoeStaticVfcBindIfIndex", peer, new SnmpInt(bindIf).toString());
                        SmCacheUtil.getInstance().addEntry("cfcoeStaticVfcBindIfIndex", peer, new SnmpInt(vfcId).toString());
                    }
                    if (lMap != null) {
                        ifLabel.putAll(lMap);
                    }
                    labelMap.put(pdu.getPeer(), ifLabel);
                    SmCacheUtil.getInstance().setMap("EthernetInterfaceLabels", labelMap);
                }
            }, 0);
        }
        catch (SnmpException e) {
            DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void populateSpeeds(SnmpPeer node) throws SnmpException {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        VSifObj lVSifObj = VSifObj.get(node, sw, 7);
        this.ethPortToSpeedByPeerMap.put(node, lVSifObj.getEthPortIfIndexToSpeedMap());
    }

    @Override
    public int[] getTableGetNextIndex(SnmpPeer node, int[] defaultIndex, int col) {
        return this.buildGetVBLIndex(node, defaultIndex, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        SnmpPeer peer = (SnmpPeer)this.getValueAt(row, 0);
        if (peer != null) {
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (sw == null) {
                return false;
            }
            int mibCol = col - this._offset;
            Object o = this.getValueAt(row, 5 + this._offset);
            JnmMibEnum bindType = null;
            if (!(o instanceof JnmMibEnum)) {
                return false;
            }
            bindType = (JnmMibEnum)this.getValueAt(row, 5 + this._offset);
            switch (mibCol) {
                case 9: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return bindType.getValue() == 1;
                }
                case 7: {
                    return bindType.getValue() == 2;
                }
                case 8: {
                    return true;
                }
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public boolean isCellActive(int row, int col) {
        SnmpOID indexOid = (SnmpOID)this.getValueAt(row, 1);
        SnmpPeer peer = (SnmpPeer)this.getValueAt(row, 0);
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw == null) {
            return false;
        }
        int mibCol = col - this._offset;
        switch (mibCol) {
            case 2: {
                Object ifOperMode = this.getValueAt(row, 1 + this._offset);
                return ifOperMode != null && !ifOperMode.toString().equals("TE");
            }
        }
        return super.isCellActive(row, col);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        BrowserFrame.getTable().removeMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public int applyChangesSet(HashMap pdus, SnmpAggregrateIf applyChangesCallback) throws Exception {
        Iterator peersIt = pdus.keySet().iterator();
        Iterator pdusIt = pdus.values().iterator();
        ArrayList<SnmpPeer> peerList = new ArrayList<SnmpPeer>();
        ArrayList<SnmpPDU> pduList = new ArrayList<SnmpPDU>();
        while (pdusIt.hasNext()) {
            SnmpPDU pdu = (SnmpPDU)pdusIt.next();
            int pduSize = pdu.getVariables().size();
            if (pduSize == 0) continue;
            SnmpPeer node = (SnmpPeer)peersIt.next();
            VarBindList vbl = pdu.getVariables();
            if (pduSize > SnmpFetch._Max) {
                int vblCount = 0;
                VarBindList vblNew = new VarBindList();
                pdu = new SnmpPDU(-93, vblNew);
                pdu.setAddress(node.getAddress());
                int i = 0;
                while (i < vbl.size()) {
                    SnmpVarBind vb = vbl.getVb(i);
                    SnmpOID oid = vb.getOid();
                    if (oid.startsWith(_fcIfAdminModeOid) && vblCount > SnmpFetch._Max - 3 || vblCount == SnmpFetch._Max) {
                        peerList.add(node);
                        pduList.add(pdu);
                        vblCount = 0;
                        vblNew = new VarBindList();
                        pdu = new SnmpPDU(-93, vblNew);
                        pdu.setAddress(node.getAddress());
                    }
                    vblNew.add(vb);
                    ++i;
                    ++vblCount;
                }
            }
            peerList.add(node);
            pduList.add(pdu);
        }
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        int successfulSets = aggregrate.set(peerList.toArray(new SnmpPeer[peerList.size()]), pduList.toArray(new SnmpPDU[pduList.size()]), pduList, applyChangesCallback, this._fragPduOnByte);
        return successfulSets;
    }

    @Override
    public void setCellEditor(SnmpKTable table) {
        super.setCellEditor(table);
        if (this._mibNodes != null) {
            for (int i = 0; i < this._mibNodes.length; ++i) {
                TableColumn col;
                TableCellEditor cellEditor;
                if (this._mibNodes[i] == null || !Arrays.equals(this._mibNodes[i].getOid(), _fcIfAdminModeOid) || !((cellEditor = (col = table.getColumnModel().getColumn(i)).getCellEditor()) instanceof SnmpKTable.BoldEditor)) continue;
                ((SnmpKTable.BoldEditor)cellEditor).putClientProperty(SnmpKTable.REFRESH, new AdminComboRefresher());
            }
        }
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        SnmpVar v = vb.getVar();
        int colWithoutOffset = col - this._offset;
        if (colWithoutOffset == 6) {
            try {
                if (v instanceof SnmpNull) {
                    System.out.println(v);
                }
                InterfaceIndex o = new InterfaceIndex((SnmpInt)v, this.getIfIndexIf(row));
                return o;
            }
            catch (SnmpException ex) {
                return null;
            }
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }

    @Override
    public int[] getCellSetIndex(Cell cell) {
        int[] vsifIfIndex = super.getCellSetIndex(cell);
        SnmpPeer peer = this.getRowPeer(cell._row);
        return this.buildGetVBLIndex(peer, vsifIfIndex, cell._col);
    }

    @Override
    protected SnmpVar getChangedCell(int row, int col, MibNode[] mibNodes) throws Exception {
        int colWithoutOffset = col - this._offset;
        if (colWithoutOffset == 6) {
            Object o = this.getValueAt(row, col);
            if (o == null) {
                return new SnmpInt(0);
            }
            if (o instanceof InterfaceIndex) {
                int ifIndex = ((InterfaceIndex)o).getValue();
                if (!this.validateSpeed(this.getRowPeer(row), ifIndex)) {
                    throw new Exception("The Bound Ethernet Interface : <" + o + "> is not running at 10G+.\n" + "Please select a 10G+ Ethernet Interface.");
                }
                return (InterfaceIndex)o;
            }
            throw new Exception("Bad Interface " + o.toString());
        }
        return super.getChangedCell(row, col, mibNodes);
    }

    protected boolean validateSpeed(SnmpPeer node, int ifIndex) {
        TreeMap<Integer, Integer> ethPortToSpeedMap;
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        return sw.getType(ifIndex) == 22 || !sw.getSwitchBase().isN5K() || this.ethPortToSpeedByPeerMap == null || (ethPortToSpeedMap = this.ethPortToSpeedByPeerMap.get(node)) == null || !ethPortToSpeedMap.containsKey(ifIndex) || ethPortToSpeedMap.get(ifIndex) >= 10000;
    }

    @Override
    public Object getSetValueAt(Object aValue, int row, int col) {
        int colWithoutOffset = col - this._offset;
        if (colWithoutOffset == 6) {
            try {
                aValue = new InterfaceIndex(aValue.toString().trim(), this.getIfIndexIf(row), true);
            }
            catch (Exception ex) {
                Util.errorMessage(this.getErrorComponent(), ex);
            }
        } else {
            aValue = super.getSetValueAt(aValue, row, col);
            if (colWithoutOffset == 5) {
                int idx;
                Object[] values = (Object[])this.getData().elementAt(row);
                Object[] changed = (Object[])values[this.getHeaders().length];
                int n = idx = ((MibEnum)aValue).getValue() == 1 ? 7 + this._offset : 6 + this._offset;
                if (changed != null && changed[idx] != null) {
                    values[idx] = changed[idx];
                    changed[idx] = null;
                }
            }
        }
        return aValue;
    }

    @Override
    protected void assignCellValueSameClass(Object aValue, int row, int col, Object[] values) {
        int colWithoutOffset = col - this._offset;
        if (colWithoutOffset == 6 && aValue instanceof InterfaceIndex && ((InterfaceIndex)aValue).getValue() == 0) {
            aValue = null;
        }
        this.markUndo(row, col, aValue);
        values[col] = aValue;
    }

    @Override
    protected void assignCellValue(Object aValue, int row, int col, Object[] values) throws Exception {
        int colWithoutOffset = col - this._offset;
        if (colWithoutOffset == 6) {
            if (aValue instanceof InterfaceIndex) {
                if (((InterfaceIndex)aValue).getValue() == 0) {
                    aValue = null;
                }
                this.markUndo(row, col, aValue);
                values[col] = aValue;
            }
        } else {
            super.assignCellValue(aValue, row, col, values);
        }
    }

    @Override
    protected void repairVb(int[] mibOid, int[] curOid, int[] firstIndex, SnmpVarBind vb) {
        for (int i = 0; i < _VFCOid.length; ++i) {
            if (!SnmpOID.startsWith(curOid, _VFCOid[i])) continue;
            return;
        }
        super.repairVb(mibOid, curOid, firstIndex, vb);
    }

    class AdminComboRefresher
    implements SnmpKTable.Refresher {
        private DefaultComboBoxModel defaultModel;

        AdminComboRefresher() {
        }

        @Override
        public void refresh(Object o, JTable table, int row, int column) {
            if (o instanceof JComboBox) {
                JComboBox adminModeCombo = (JComboBox)o;
                if (this.defaultModel == null) {
                    this.populateComboBoxModels(adminModeCombo);
                }
                adminModeCombo.setModel(this.defaultModel);
            }
        }

        private void populateComboBoxModels(JComboBox comboBox) {
            int count = comboBox.getModel().getSize();
            ArrayList<MibEnum> defaultAdminModeEnums = new ArrayList<MibEnum>();
            for (int i = 0; i < count; ++i) {
                MibEnum mibEnum = (MibEnum)comboBox.getModel().getElementAt(i);
                String label = mibEnum.getLabel();
                if (!label.equals("F") && !label.equals("E") && !label.equals("NP")) continue;
                defaultAdminModeEnums.add(mibEnum);
            }
            this.defaultModel = new DefaultComboBoxModel<MibEnum>(defaultAdminModeEnums.toArray(new MibEnum[defaultAdminModeEnums.size()]));
        }
    }
}

