/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmIpInterfaceTableModel;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmVlanTableModel
extends SmIpInterfaceTableModel {
    static final int VLAN_TYPE = 0;
    static final int VLAN = 1;
    static final int VLANS = 2;
    static final int VLAN2k = 3;
    static final int VLAN3k = 4;
    static final int VLAN4k = 5;
    public static final int STATIC = 1;
    public static final int DYNAMIC = 2;
    public static final int MULTIVLAN = 3;
    static final int[] _vmVlansOid = MibNode.get("vmVlans").getOid();

    public SmVlanTableModel(int ifType, boolean getIPS) {
        super(ifType, getIPS);
    }

    public SmVlanTableModel() {
        this(0, true);
    }

    @Override
    protected boolean isModelTypeSupported(SnmpPeer peer) {
        boolean supported = super.isModelTypeSupported(peer);
        if (supported) {
            if (this._ifType == 3) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                supported = sw.isN5K();
            } else if (this._ifType == 1) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                supported = sw.isN5K() || sw.isN7K() ? !this._getIPS : this._getIPS || sw.isFcoeEnabled();
            }
        }
        return supported;
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        switch (this._ifType) {
            case 3: {
                this._index = 0x1BFFFFFF;
                this._stopIndex = IfIndexUtil.getLastValidIfIndexFor(28) + 1;
                break;
            }
            case 1: {
                if (this._getIPS) break;
                this._responseData = super.getTableVars(nodes);
                return this._responseData;
            }
        }
        return super.getTableVars(nodes);
    }

    @Override
    protected int[] getIndex(SnmpPeer node) {
        if (!this._getIPS && this._ifType == 1) {
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            this._index = IfIndexUtil.getFirstValidIfIndexFor(sw.getActualType(26)) - 1;
        }
        return super.getIndex(node);
    }

    @Override
    protected boolean isEnd(SnmpPeer peer, int[] req, SnmpVarBind vb, int[] index, int reqId) {
        if (!this._getIPS && this._ifType == 1) {
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            return !SnmpOID.startsWith(req, vb.getOid().getValue()) || index[0] > IfIndexUtil.getLastValidIfIndexFor(sw.getActualType(26));
        }
        return super.isEnd(peer, req, vb, index, reqId);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        int vlanType = vbl.intValue(0);
        SnmpVar vlansVar = vbl.getVb(2).getVar();
        if (vlansVar.getType() != 5) {
            if (vlanType == 3) {
                try {
                    SnmpString vlans = (SnmpString)vlansVar;
                    SnmpString vlan2k = (SnmpString)vbl.getVb(3).getVar();
                    SnmpString vlan3k = (SnmpString)vbl.getVb(4).getVar();
                    SnmpString vlan4k = (SnmpString)vbl.getVb(5).getVar();
                    PortInterfaceUtil.getInstance(3).getVlans(vlans, vlan2k, vlan3k, vlan4k);
                }
                catch (ClassCastException ex) {
                    DefaultLogger._DefLogger.error((Object)("Agent does not return the proper number of VarBinds: vlans=" + vbl.getVb(0).getVar() + "vlan2k=" + vbl.getVb(1).getVar()));
                    DefaultLogger._DefLogger.error((Object)("Agent does not return the proper number of VarBinds: vlan3k=" + vbl.getVb(2).getVar() + "vlan4k=" + vbl.getVb(3).getVar()));
                }
            } else {
                byte[] b = new byte[512];
                ((SnmpString)vlansVar).setValue(b);
                int vlan = vbl.intValue(1);
                SnmpString.setBitBase0(((SnmpString)vlansVar).getValue(), vlan - 1);
            }
        }
        return super.addElement(vbl, node, index);
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        if (!this._getIPS && var.equals("vmVlans")) {
            return SmVlanTableModel.getMibVariableFormat("vmVlansNonIPS", vb.getVar(), _MibVariableFormatMethods, _MibVariableFormatClass);
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        SnmpVar changedCellVar = super.processChangedCell(cell, pdu, changedCellOid, index);
        if (changedCellOid.startsWith(_vmVlansOid)) {
            PortInterfaceUtil.getInstance(3).addVlan4k2Pdu(pdu, changedCellOid, changedCellVar, index[0]);
            this._fragPduOnByte = true;
        }
        return changedCellVar;
    }

    @Override
    protected SnmpVar getChangedCell(int row, int col, MibNode[] mibNodes) throws Exception {
        if (col == 4 && !this._getIPS) {
            Object o = this.getValueAt(row, col);
            SnmpBitmap value = new SnmpBitmap((String)o, true);
            return value;
        }
        return super.getChangedCell(row, col, mibNodes);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Switch sw;
        SnmpPeer peer = (SnmpPeer)this.getValueAt(row, 0);
        if (peer != null && (sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress())).isN5K()) {
            return false;
        }
        return super.isCellEditable(row, col);
    }
}

