/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.DomainId;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;

public class SmVsanSwitchTableModel
extends SmTableModel {
    private static final String[] LABELS = new String[]{"Name", "Domain Id", "VSAN WWN", "Principal", "Status", "Model", "Release", "UpTime"};
    private static final int NAME = 0;
    private static final int DMID = 1;
    private static final int WWN = 2;
    private static final int PRINCIPAL = 3;
    private static final int STATUS = 4;
    private static final int MODEL = 5;
    private static final int RELEASE = 6;
    private static final int UPTIME = 7;

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, this._isScalar ? 1 : 2);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._prefixes = prefixes;
        this.setHeaders(LABELS);
        this.setData(new Array());
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        return this.getTableVars(mgmtDomain);
    }

    @Override
    public Array getTableVars(MgmtDomainIf mgmtDomain) throws SnmpException {
        this._responseData = new Array();
        if (mgmtDomain.isSan() || mgmtDomain.isFabric()) {
            return this._responseData;
        }
        Vsan v = mgmtDomain.isVsan() ? (Vsan)mgmtDomain : ((EnforcedZone)mgmtDomain).getVsan();
        Wwn principalWwn = v.getPrincipalVsanWwn();
        Switch[] switches = v.getSwitches();
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                Switch sw = switches[i];
                Object[] row = new Object[LABELS.length + 1];
                row[0] = sw;
                short dId = sw.getDomainId(v.getId());
                row[1] = new DomainId(dId);
                Wwn swWwn = sw.getVsanWwn(v.getId());
                row[2] = swWwn;
                row[3] = principalWwn != null && principalWwn.equals(swWwn) ? "self" : principalWwn;
                row[4] = sw.getStatus();
                row[5] = sw.getModel();
                row[6] = sw.getVersion();
                row[7] = sw.getSwitchUpTime() > 0L ? SnmpTimeticks.formatTimeElapsed(sw.getSwitchUpTime()) : "n/a";
                this._responseData.addElement(row);
            }
        }
        return this._responseData;
    }

    private boolean isPrincipal(Wwn[] list, Wwn sWwn) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].equals(sWwn)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void selectionAction(SnmpKTable table) {
        this.mapSelectDevice(table);
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[0];
    }
}

