/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.VsanUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class SmVsanTableModel
extends SmTableModel
implements SnmpAggregrateIf {
    static final int[] _vsanRowStatusOid = MibNode.get("vsanRowStatus").getOid();
    static final int[] _vsanAdminStateOid = MibNode.get("vsanAdminState").getOid();
    static final int[] _vsanInterOperValueOid = MibNode.get("vsanInterOperValue").getOid();
    static final int[] _vsanInterOperModeOid = MibNode.get("vsanInterOperMode").getOid();
    static final int[] _vsanNameOid = MibNode.get("vsanName").getOid();
    HashMap _vsans2PeersToBeSuspended = new HashMap();
    public static final int NAME_COL = 2;
    public static final int LB_COL = 4;
    public static final int INTEROPERVALUE_COL = 5;
    public static final int ADMIN_COL = 6;
    public static final int FICON_COL = 8;
    public static final int INORDERDELIVERY_COL = 9;
    public static final int RATOV_COL = 10;
    public static final int DSTOV_COL = 11;
    public static final int EDTOV_COL = 12;
    public static final int DROPLATENCY_COL = 13;
    public static final int INTEROPERMODE_COL = 14;
    static final int ADMIN_STATE_SUSPEND = 2;
    public static final int VSAN_TO_SUSPEND = 0;
    public static final int VSAN_TO_DEL = 1;
    public static final int VSAN_TO_CHANGE_TIMER = 2;
    static final int[] _vsanFcTimerRatovOid = MibNode.get("vsanFcTimerRatov").getOid();
    static final int[] _vsanFcTimerDstovOid = MibNode.get("vsanFcTimerDstov").getOid();
    static final int[] _vsanFcTimerEdtovOid = MibNode.get("vsanFcTimerEdtov").getOid();
    static final int[] _vsanFcTimerForceFlagOid = MibNode.get("vsanFcTimerForceFlag").getOid();
    HashMap _vsans2PeersToChangeTimers = new HashMap();
    boolean _delIvr;
    boolean _isFilteredByVsan = false;

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        boolean[] isEditable = this.getEditable();
        isEditable[8] = false;
        MgmtDomainIf mgtDomain = ClientController.getInstance().getSelectedDomain();
        if (mgtDomain.getVsanId() != 0) {
            isEditable[10] = false;
            isEditable[11] = false;
            isEditable[12] = false;
        }
        this.setEditable(isEditable);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        boolean isVer12Above = sw.isVersionGreaterThanEqual("1.2(0)");
        if (!isVer12Above) {
            Boolean operMode = (Boolean)row[14];
            row[5] = this.toCell(this._mibNodes[5], operMode != false ? new SnmpInt(1) : new SnmpInt(0), this._vars[5 - this._offset], this._responseData.size() - 1);
        }
        return row;
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        if (var.startsWith("vsanInterOperValue")) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
            boolean isVer12Above = sw.isVersionGreaterThanEqual("1.2(0)");
            if (!isVer12Above) {
                int mode = vbl.intValue(indexOfVbl + 14 - this._offset);
                vb.setVar(mode == 1 ? new SnmpInt(1) : new SnmpInt(0));
            }
        } else if (var.startsWith("cficonVsanHostControl")) {
            SnmpVar v = vb.getVar();
            int[] oid = vb.getOid().getValue();
            if (v.getType() == 5 || !SnmpOID.startsWith(oid, mibNode.getOid())) {
                return "false";
            }
            int ficonVsan = oid[oid.length - 1];
            int rowVsan = index.getValue()[0];
            if (ficonVsan == rowVsan) {
                return "true";
            }
            oid[oid.length - 1] = rowVsan;
            return "false";
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }

    @Override
    protected SnmpVar getChangedCellVar(int row, int col, SnmpOID changedCellOid, int[] index) throws Exception {
        Object o;
        String name;
        if (changedCellOid.startsWith(_vsanNameOid) && (name = ((SnmpString)(o = this.getValueAt(row, col))).toString()).indexOf(32) != -1) {
            return new SnmpString(name.replace(' ', '_'));
        }
        return super.getChangedCellVar(row, col, changedCellOid, index);
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        SnmpVar changedCellVar = null;
        SnmpPeer node = this.getRowPeer(cell._row);
        if (changedCellOid.startsWith(_vsanFcTimerRatovOid) || changedCellOid.startsWith(_vsanFcTimerDstovOid) || changedCellOid.startsWith(_vsanFcTimerEdtovOid)) {
            changedCellVar = super.getChangedCell(cell._row, cell._col);
            Integer vsanId = new Integer(index[0]);
            Array<SnmpPeer> peers = (Array<SnmpPeer>)this._vsans2PeersToChangeTimers.get(vsanId);
            if (peers == null) {
                peers = new Array<SnmpPeer>();
                this._vsans2PeersToChangeTimers.put(vsanId, peers);
            }
            if (peers.find(node) == -1) {
                peers.addElement(node);
            }
        } else {
            changedCellVar = super.processChangedCell(cell, pdu, changedCellOid, index);
            if (changedCellOid.startsWith(_vsanAdminStateOid)) {
                int adminState = ((SnmpInt)changedCellVar).getValue();
                if (adminState == 2) {
                    Integer vsanId = new Integer(index[0]);
                    Array<SnmpPeer> peers = (Array<SnmpPeer>)this._vsans2PeersToBeSuspended.get(vsanId);
                    if (peers == null) {
                        peers = new Array<SnmpPeer>();
                        this._vsans2PeersToBeSuspended.put(vsanId, peers);
                    }
                    peers.addElement(node);
                }
            } else if (changedCellOid.startsWith(_vsanInterOperValueOid)) {
                Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
                boolean isVer12Above = sw.isVersionGreaterThanEqual("1.2(0)");
                if (!isVer12Above) {
                    VarBindList vbl = pdu.getVariables();
                    int type = ((SnmpInt)vbl.getVb(vbl.size() - 1).getVar()).getValue();
                    vbl.remove(vbl.size() - 1);
                    vbl.add(new SnmpVarBind(new SnmpOID(_vsanInterOperModeOid, index), type == 1 ? new SnmpInt(1) : new SnmpInt(2)));
                }
            } else if (changedCellOid.startsWith(_vsanFcTimerRatovOid) || changedCellOid.startsWith(_vsanFcTimerDstovOid) || changedCellOid.startsWith(_vsanFcTimerEdtovOid)) {
                Integer vsanId = new Integer(index[0]);
                Array<SnmpPeer> peers = (Array<SnmpPeer>)this._vsans2PeersToChangeTimers.get(vsanId);
                if (peers == null) {
                    peers = new Array<SnmpPeer>();
                    this._vsans2PeersToChangeTimers.put(vsanId, peers);
                }
                if (peers.find(node) == -1) {
                    peers.addElement(node);
                }
            }
        }
        return changedCellVar;
    }

    @Override
    public String getInsertTitle(SnmpKTable table) {
        return "Create VSAN" + ClientController.getInstance().getDialogMgmtDomainTitlePostfix();
    }

    @Override
    public boolean applyChangesAction() throws Exception {
        this.checkTimerValue();
        this._vsans2PeersToBeSuspended.clear();
        this._vsans2PeersToChangeTimers.clear();
        return super.applyChangesAction();
    }

    void checkTimerValue() throws Exception {
        int i;
        Array data = this.getData();
        Object[] values = (Object[])data.elementAt(0);
        long raTov = -1L;
        long dsTov = -1L;
        long edTov = -1L;
        for (i = 0; i < data.size(); ++i) {
            values = (Object[])data.elementAt(i);
            if (values[10] instanceof SnmpNull || values[11] instanceof SnmpNull || values[12] instanceof SnmpNull) continue;
            raTov = ((SnmpGauge)values[10]).getValue();
            dsTov = ((SnmpGauge)values[11]).getValue();
            edTov = ((SnmpGauge)values[12]).getValue();
        }
        if (raTov == -1L && dsTov == -1L && edTov == -1L) {
            return;
        }
        for (i = 0; i < data.size(); ++i) {
            values = (Object[])data.elementAt(i);
            if (values[10] instanceof SnmpNull || values[11] instanceof SnmpNull || values[12] instanceof SnmpNull) continue;
            if (((SnmpGauge)values[10]).getValue() != raTov) {
                throw new Exception(this.getWarning(10));
            }
            if (((SnmpGauge)values[11]).getValue() != dsTov) {
                throw new Exception(this.getWarning(11));
            }
            if (((SnmpGauge)values[12]).getValue() == edTov) continue;
            throw new Exception(this.getWarning(12));
        }
    }

    private String getWarning(int col) {
        String name = this.getColumnName(col);
        return name + " must be the same for all switches in this VSAN";
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return null;
        }
        Array data = this.getData();
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        int processingRow = -1;
        byte[] forceFlag = null;
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            int[] index = this.getIndex(cell._row);
            SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
            SnmpVar changedCellVar = this.processChangedCell(cell, pdu, oid, index);
            if (processingRow != cell._row) {
                forceFlag = new byte[1];
                processingRow = cell._row;
                SnmpOID forceFlagOid = new SnmpOID(_vsanFcTimerForceFlagOid, index);
                pdu.addVar(forceFlagOid, new SnmpString(forceFlag));
            }
            if (oid.startsWith(_vsanFcTimerDstovOid) && i + 1 < cells.size()) {
                Object[] values;
                Object[] oldVals;
                long oldEdTov;
                long newDsTov;
                Cell nextcell = (Cell)cells.elementAt(i + 1);
                int[] nextindex = this.getIndex(nextcell._row);
                SnmpOID nextoid = new SnmpOID(this._mibNodes[nextcell._col].getOid(), nextindex);
                SnmpVar nextchangedCellVar = this.getChangedCell(nextcell._row, nextcell._col);
                if (nextcell._row == cell._row && nextoid.startsWith(_vsanFcTimerEdtovOid) && (newDsTov = ((SnmpGauge)changedCellVar).getValue()) < (oldEdTov = ((SnmpGauge)(oldVals = (Object[])(values = (Object[])data.elementAt(cell._row))[this.getHeaders().length])[12]).getValue())) {
                    pdu.addVar(nextoid, nextchangedCellVar);
                    pdu.addVar(oid, changedCellVar);
                    SnmpString.setBitBase0(forceFlag, 1);
                    SnmpString.setBitBase0(forceFlag, 2);
                    ++i;
                    continue;
                }
            }
            pdu.addVar(oid, changedCellVar);
            if (oid.startsWith(_vsanFcTimerRatovOid)) {
                SnmpString.setBitBase0(forceFlag, 0);
                continue;
            }
            if (oid.startsWith(_vsanFcTimerEdtovOid)) {
                SnmpString.setBitBase0(forceFlag, 1);
                continue;
            }
            SnmpString.setBitBase0(forceFlag, 2);
        }
        if (this._vsans2PeersToChangeTimers.size() != 0 ? !SmVsanTableModel.processVsanChange(this._vsans2PeersToChangeTimers, 2) : this._vsans2PeersToBeSuspended.size() != 0 && !SmVsanTableModel.processVsanChange(this._vsans2PeersToBeSuspended, 0)) {
            return null;
        }
        return pdus;
    }

    public static boolean processVsanChange(HashMap vsan2Peers, int action) {
        int nValidVsans = 0;
        StringBuffer strBuf = new StringBuffer();
        for (Integer oVsanId : vsan2Peers.keySet()) {
            int vsanId = oVsanId;
            Array peers = (Array)vsan2Peers.get(oVsanId);
            Vsan v = null;
            if (peers.size() > 0) {
                ClientController.getInstance();
                Switch sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)peers.elementAt(0)).getAddress());
                if (sw != null) {
                    v = sw.getVsan((short)vsanId);
                }
            }
            if (v == null) {
                v = ClientController.getInstance().getFabric().findVsanById(vsanId);
            }
            if (v == null) continue;
            int nIsls = v.getIsls(null).size();
            int nEndPorts = v.getEndPorts(null).size();
            if (nIsls == 0 && nEndPorts == 0) continue;
            ++nValidVsans;
            strBuf.append(VsanUtil.getDefaultVsanName(vsanId) + " is used by ");
            if (nIsls != 0) {
                strBuf.append(nIsls + " ISLs");
            }
            if (nEndPorts != 0) {
                if (nIsls != 0) {
                    strBuf.append(" and ");
                }
                strBuf.append(nEndPorts + " End Devices");
            }
            strBuf.append(" on ");
            for (int i = 0; i < peers.size(); ++i) {
                strBuf.append(peers.elementAt(i) + ",");
            }
            strBuf.setLength(strBuf.length() - 1);
            strBuf.append(".\n");
        }
        boolean delIvr = false;
        ArrayList<Object> ivrVsanList = new ArrayList<Object>();
        if (action == 1) {
            block27: {
                Object[] vsanids = vsan2Peers.keySet().toArray();
                Switch sw = ClientController.getInstance().getFabric().getIvrSeedSwitch();
                if (vsanids != null && vsanids.length > 0 && sw != null && sw.getPeer() != null) {
                    try {
                        VarBindList vbLst = new VarBindList();
                        vbLst.add(MibNode.get("civrTopologyActiveSwitchVsan2k").getOid());
                        vbLst.add(MibNode.get("civrTopologyActiveSwitchVsan4k").getOid());
                        VarBindList vbRes = SnmpFetch.getBulk(sw.getPeer(), vbLst).getVariables();
                        for (int k = 0; k < vbRes.size(); k += 2) {
                            byte[] vsan2K = vbRes.byteValue(k);
                            byte[] vsan4K = vbRes.byteValue(k + 1);
                            for (int i = 0; i < vsanids.length; ++i) {
                                byte[] comparebyte = vsan2K;
                                boolean byteArrayBase0 = true;
                                int compareVsanId = (Integer)vsanids[i];
                                if (compareVsanId > 2047) {
                                    compareVsanId -= 2047;
                                    comparebyte = vsan4K;
                                    byteArrayBase0 = false;
                                }
                                if (comparebyte == null || comparebyte.length <= 0 || comparebyte.length < (compareVsanId + 1) / 8 || !(byteArrayBase0 ? SnmpString.getBitBase0(comparebyte, compareVsanId) : SnmpString.getBit(comparebyte, compareVsanId))) continue;
                                if (!delIvr) {
                                    delIvr = true;
                                }
                                if (ivrVsanList.contains(vsanids[i])) continue;
                                ivrVsanList.add(vsanids[i]);
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!SnmpSession.isTrace()) break block27;
                        DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            if (delIvr) {
                strBuf.append("VSAN ");
                int nIvrVsan = ivrVsanList.size();
                for (int row = 0; row < (nIvrVsan + 7) / 8; ++row) {
                    for (int col = 0; col < 10 && row * 8 + col < ivrVsanList.size(); ++col) {
                        strBuf.append((Integer)ivrVsanList.get(row * 8 + col));
                        strBuf.append(", ");
                    }
                    strBuf.append("\n");
                }
                strBuf.setLength(strBuf.length() - 3);
                strBuf.append(nIvrVsan == 1 ? " is" : " are");
                strBuf.append(" part of the active IVR topology.\n");
                if (nValidVsans != 0) {
                    strBuf.append("\n");
                }
            }
        }
        if (nValidVsans == 0 && !delIvr) {
            return true;
        }
        if (nValidVsans != 0 || delIvr) {
            switch (action) {
                case 0: {
                    strBuf.append("Suspending ");
                    break;
                }
                case 1: {
                    strBuf.append("Deleting ");
                    break;
                }
                case 2: {
                    strBuf.append("Changing timers for ");
                }
            }
            strBuf.append("VSANs may affect data path resulting data loss or fabric segmentation.\n\n");
        }
        strBuf.append("Are you sure?");
        return JOptionPane.showOptionDialog(BrowserFrame.getDataView(), strBuf, "DCNM-SAN", 0, 2, null, new String[]{"Yes", "No"}, "No") == 0;
    }

    private static ArrayList findIvrTopologyVsanIds(Object[] vsanids, Fabric f) {
        ArrayList<Integer> topologyVsans = new ArrayList<Integer>();
        Switch sw = f.getIvrSeedSwitch();
        if (vsanids != null && vsanids.length > 0 && sw.getPeer() != null) {
            try {
                VarBindList vbLst = new VarBindList();
                vbLst.add(MibNode.get("civrTopologyActiveSwitchVsan2k").getOid());
                vbLst.add(MibNode.get("civrTopologyActiveSwitchVsan4k").getOid());
                VarBindList vbRes = SnmpFetch.getBulk(sw.getPeer(), vbLst).getVariables();
                byte[] vsan2K = vbRes.byteValue(0);
                byte[] vsan4K = vbRes.byteValue(1);
                for (int i = 0; i < vsanids.length; ++i) {
                    byte[] comparebyte = vsan2K;
                    int compareVsanId = (Integer)vsanids[i];
                    if (compareVsanId > 2047) {
                        compareVsanId -= 2047;
                        comparebyte = vsan4K;
                    }
                    if (comparebyte == null || comparebyte.length <= (compareVsanId + 1) / 8 || !SnmpString.getBitBase0(comparebyte, compareVsanId)) continue;
                    topologyVsans.add((Integer)vsanids[i]);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return topologyVsans;
    }

    @Override
    public boolean deleteRowsAction(int[] rows) throws Exception {
        HashMap<Integer, Array<SnmpPeer>> vsans2PeersToBeDeleted = new HashMap<Integer, Array<SnmpPeer>>();
        this._delIvr = false;
        for (int i = 0; i < rows.length; ++i) {
            Integer oVsanId;
            Array<SnmpPeer> peers;
            SnmpPeer node = this.getRowPeer(rows[i]);
            String vsanName = this.getValueAt(rows[i], 2).toString();
            if (vsanName.toUpperCase().indexOf("IVR") != -1) {
                this._delIvr = true;
            }
            if ((peers = (Array<SnmpPeer>)vsans2PeersToBeDeleted.get(oVsanId = new Integer(this.getIndex(rows[i])[0]))) == null) {
                peers = new Array<SnmpPeer>();
                vsans2PeersToBeDeleted.put(oVsanId, peers);
            }
            peers.addElement(node);
        }
        if (SmVsanTableModel.processVsanChange(vsans2PeersToBeDeleted, 1) && super.deleteRowsAction(rows)) {
            ClientController.getInstance().getFabric().rediscover();
            return true;
        }
        return false;
    }

    @Override
    public void deleteRows(int[] rows) throws Exception {
        this.deleteRows(rows, this);
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        if (err.length() == 0) {
            SnmpOID firstOid = pdu.getVariables().getVb(0).getOid();
            if (firstOid.startsWith(_vsanRowStatusOid)) {
                this.deleteVsanCallback(pdu);
            } else {
                this.changeVSanCallback(pdu);
            }
        }
    }

    void deleteVsanCallback(SnmpPDU pdu) {
        try {
            ClientController.getInstance().getFabric().rediscover();
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
    }

    void changeVSanCallback(SnmpPDU pdu) {
        try {
            ClientController.getInstance().getFabric().rediscover();
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
        }
    }

    @Override
    public boolean isCellActive(int row, int col) {
        if (col == 2 || col == 4 || col == 5 || col == 6) {
            int vsanId = ((SnmpOID)this.getValueAt(row, 1)).getValue()[0];
            return vsanId != 4094;
        }
        return super.isCellActive(row, col);
    }

    @Override
    protected SnmpVar checkCell(SnmpVar v, MibNode mibNode, String name, int row, int col) throws Exception {
        if (col == 12) {
            long edTov = ((SnmpGauge)v).getValue();
            long dsTov = ((SnmpGauge)this.getValueAt(row, 11)).getValue();
            if (edTov < (long)mibNode.getLo() || edTov > dsTov) {
                throw new Exception(name + " should be in range " + mibNode.getLo() + ".." + dsTov);
            }
            return v;
        }
        if (col == 11) {
            long edTov;
            long dsTov = ((SnmpGauge)v).getValue();
            if (dsTov < (edTov = ((SnmpGauge)this.getValueAt(row, 12)).getValue())) {
                throw new Exception(name + " should be greater than E_D_TOV(" + edTov + ")");
            }
            return v;
        }
        return super.checkCell(v, mibNode, name, row, col);
    }

    @Override
    protected SnmpPeer[] getWrkingPeers() {
        SnmpPeer[] peers = super.getWrkingPeers();
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        if (mgmtDomain.isSan() || mgmtDomain.isFabric()) {
            return peers;
        }
        mgmtDomain = ClientController.getInstance().getFabric();
        if (mgmtDomain == null) {
            return null;
        }
        return mgmtDomain.getSnmpPeers();
    }
}

