/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmVsanTableModel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.util.HashMap;

public class SmVsanTimerTableModel
extends SmTableModel {
    static final int[] _vsanFcTimerRatovOid = MibNode.get("vsanFcTimerRatov").getOid();
    static final int[] _vsanFcTimerDstovOid = MibNode.get("vsanFcTimerDstov").getOid();
    static final int[] _vsanFcTimerEdtovOid = MibNode.get("vsanFcTimerEdtov").getOid();
    static final int[] _vsanFcTimerForceFlagOid = MibNode.get("vsanFcTimerForceFlag").getOid();
    static final int RATOV_COL = 2;
    static final int DSTOV_COL = 3;
    static final int EDTOV_COL = 4;
    HashMap _vsans2PeersToChangeTimers = new HashMap();

    @Override
    public boolean applyChangesAction() throws Exception {
        this._vsans2PeersToChangeTimers.clear();
        return super.applyChangesAction();
    }

    void checkTimerValue() throws Exception {
        Array data = this.getData();
        Object[] values = (Object[])data.elementAt(0);
        long raTov = ((SnmpGauge)values[2]).getValue();
        long dsTov = ((SnmpGauge)values[3]).getValue();
        long edTov = ((SnmpGauge)values[4]).getValue();
        for (int i = 1; i < data.size(); ++i) {
            values = (Object[])data.elementAt(i);
            if (((SnmpGauge)values[2]).getValue() != raTov) {
                throw new Exception(this.getWarning(2));
            }
            if (((SnmpGauge)values[3]).getValue() != dsTov) {
                throw new Exception(this.getWarning(3));
            }
            if (((SnmpGauge)values[4]).getValue() == edTov) continue;
            throw new Exception(this.getWarning(4));
        }
    }

    private String getWarning(int col) {
        String name = this.getColumnName(col);
        return name + " must be the same for all switches in this VSAN";
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        SnmpVar changedCellVar = super.getChangedCell(cell._row, cell._col);
        SnmpPeer node = this.getRowPeer(cell._row);
        Integer vsanId = new Integer(index[0]);
        Array<SnmpPeer> peers = (Array<SnmpPeer>)this._vsans2PeersToChangeTimers.get(vsanId);
        if (peers == null) {
            peers = new Array<SnmpPeer>();
            this._vsans2PeersToChangeTimers.put(vsanId, peers);
        }
        if (peers.find(node) == -1) {
            peers.addElement(node);
        }
        return changedCellVar;
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return null;
        }
        Array data = this.getData();
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        int processingRow = -1;
        byte[] forceFlag = null;
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            int[] index = this.getIndex(cell._row);
            SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
            SnmpVar changedCellVar = this.processChangedCell(cell, pdu, oid, index);
            if (processingRow != cell._row) {
                forceFlag = new byte[1];
                processingRow = cell._row;
                SnmpOID forceFlagOid = new SnmpOID(_vsanFcTimerForceFlagOid, index);
                pdu.addVar(forceFlagOid, new SnmpString(forceFlag));
            }
            if (oid.startsWith(_vsanFcTimerDstovOid) && i + 1 < cells.size()) {
                Object[] values;
                Object[] oldVals;
                long oldEdTov;
                long newDsTov;
                Cell nextcell = (Cell)cells.elementAt(i + 1);
                int[] nextindex = this.getIndex(nextcell._row);
                SnmpOID nextoid = new SnmpOID(this._mibNodes[nextcell._col].getOid(), nextindex);
                SnmpVar nextchangedCellVar = this.getChangedCell(nextcell._row, nextcell._col);
                if (nextcell._row == cell._row && nextoid.startsWith(_vsanFcTimerEdtovOid) && (newDsTov = ((SnmpGauge)changedCellVar).getValue()) < (oldEdTov = ((SnmpGauge)(oldVals = (Object[])(values = (Object[])data.elementAt(cell._row))[this.getHeaders().length])[4]).getValue())) {
                    pdu.addVar(nextoid, nextchangedCellVar);
                    pdu.addVar(oid, changedCellVar);
                    SnmpString.setBitBase0(forceFlag, 1);
                    SnmpString.setBitBase0(forceFlag, 2);
                    ++i;
                    continue;
                }
            }
            pdu.addVar(oid, changedCellVar);
            if (oid.startsWith(_vsanFcTimerRatovOid)) {
                SnmpString.setBitBase0(forceFlag, 0);
                continue;
            }
            if (oid.startsWith(_vsanFcTimerEdtovOid)) {
                SnmpString.setBitBase0(forceFlag, 1);
                continue;
            }
            SnmpString.setBitBase0(forceFlag, 2);
        }
        if (this._vsans2PeersToChangeTimers.size() == 0) {
            return pdus;
        }
        if (SmVsanTableModel.processVsanChange(this._vsans2PeersToChangeTimers, 2)) {
            return pdus;
        }
        return null;
    }

    @Override
    protected SnmpVar checkCell(SnmpVar v, MibNode mibNode, String name, int row, int col) throws Exception {
        if (col == 4) {
            long edTov = ((SnmpGauge)v).getValue();
            long dsTov = ((SnmpGauge)this.getValueAt(row, 3)).getValue();
            if (edTov < (long)mibNode.getLo() || edTov > dsTov) {
                throw new Exception(name + " should be in range " + mibNode.getLo() + ".." + dsTov);
            }
            return v;
        }
        if (col == 3) {
            long edTov;
            long dsTov = ((SnmpGauge)v).getValue();
            if (dsTov < (edTov = ((SnmpGauge)this.getValueAt(row, 4)).getValue())) {
                throw new Exception(name + " should be greater than E_D_TOV(" + edTov + ")");
            }
            return v;
        }
        return super.checkCell(v, mibNode, name, row, col);
    }
}

