/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmVsanIndexBasedTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;

public class SmZonePolicyTableModel
extends SmVsanIndexBasedTableModel
implements ActionListener {
    static final int DB_SOURCE_COL = 9;
    static final int READONLY_COLUMN = 3;
    static final int ENHANCED_ZONE_COLUMN_BEGIN = 4;
    static final int ZONE_ACCESS = 8;
    static final int QOS_PRIORITY = 4;
    static final int PROPAGATION = 7;
    static final int ENHANCED_ZONE_COLUMN_END = 7;
    static final int COMMIT_RESULT = 10;
    static final int SESSION_CONTROL_RESULT_IN_PROGRESS = 3;
    static final int[] _czseSessionControlResult = MibNode.get("czseSessionCntlResult").getOid();
    static final int[] _czseSessionControl = MibNode.get("czseSessionCntl").getOid();
    static final MibEnum[] _czseSessionCntrlResEnum = MibNode.get("czseSessionCntlResult").getEnums();
    protected Timer _statusTimer = new Timer(5000, this);
    private HashMap _peers2RowsId = new HashMap();

    public SmZonePolicyTableModel(int vsanId) {
        super(vsanId);
    }

    public SmZonePolicyTableModel(Vsan vsan) {
        super(vsan);
    }

    @Override
    public boolean isCellActive(int row, int col) {
        SnmpPeer peer = this.getRowPeer(row);
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw.isN5K()) {
            if (col == 3 || col == 8 || col != 7 && col >= 4 && col <= 7) {
                return false;
            }
        } else {
            if (!(col != 3 || sw != null && sw.isVersionGreaterThanEqual("1.2(0)"))) {
                return false;
            }
            if (col >= 4 && col <= 7 || col == 9) {
                if (col == 5) {
                    Boolean ob = (Boolean)this.getValueAt(row, col - 1);
                    return sw != null && sw.isVersionGreaterThanEqual("2.0(0)") && ob != false;
                }
                if (col == 8) {
                    return sw != null && sw.isVersionGreaterThanEqual("3.1(1)");
                }
                return sw != null && sw.isVersionGreaterThanEqual("2.0(0)");
            }
        }
        return super.isCellActive(row, col);
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        int[] oid = changedCellOid.getValue();
        if (cell._col == 9) {
            oid[oid.length - 1] = 0;
        }
        return super.processChangedCell(cell, pdu, changedCellOid, index);
    }

    @Override
    protected VarBindList buildGetTableVarsVbl(SmFilter invoker) {
        VarBindList vbl = super.buildGetTableVarsVbl(invoker);
        if (vbl.size() > 0) {
            SnmpVarBind vb = vbl.getVb(7);
            int[] oid = vb.getOid().getValue();
            oid[oid.length - 1] = 0;
        }
        return vbl;
    }

    @Override
    protected boolean validateVbl(SnmpPeer peer, VarBindList vbl, int state) {
        SnmpVarBind firstVb = vbl.getVb(0);
        if (state == 2) {
            int[] firstOid = firstVb.getOid().getValue();
            int[] firstIndex = new int[firstOid.length - this._mibNodes[this._offset].getOid().length];
            System.arraycopy(firstOid, firstOid.length - firstIndex.length, firstIndex, 0, firstIndex.length);
            for (int i = this._offset + 1; i < this._mibNodes.length; ++i) {
                int[] mibOid = this._mibNodes[i].getOid();
                SnmpVarBind vb = vbl.getVb(i - this._offset);
                int[] curOid = vb.getOid().getValue();
                if (curOid.length < mibOid.length) {
                    vb.setOid(new SnmpOID(mibOid, firstIndex));
                    vb.setVar(new SnmpNull(20));
                    continue;
                }
                int[] curIndex = new int[curOid.length - mibOid.length];
                System.arraycopy(curOid, curOid.length - curIndex.length, curIndex, 0, curIndex.length);
                if (SnmpOID.startsWith(mibOid, curOid) && SnmpOID.startsWith(firstIndex, curIndex)) continue;
                vb.setOid(new SnmpOID(mibOid, firstIndex));
                vb.setVar(new SnmpNull(20));
            }
        } else if (firstVb.getVar().getType() == 5) {
            return false;
        }
        return true;
    }

    @Override
    public boolean applyChanges() throws Exception {
        if (this._peers2RowsId.size() != 0) {
            return false;
        }
        this._peers2RowsId.clear();
        boolean needsPolling = this.isCommitRequired(true);
        boolean b = super.applyChanges();
        if (needsPolling) {
            this._statusTimer.start();
        }
        return b;
    }

    private boolean isEnhancedMode() {
        if (this.getRowCount() > 0) {
            JnmMibEnum modeEnum = (JnmMibEnum)this.getValueAt(0, 11);
            return modeEnum != null && modeEnum.getValue() == 2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSwitches() {
        VarBindList vbl;
        this._state = 1;
        boolean requestSent = false;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        Object object = this._peers2RowsId;
        synchronized (object) {
            for (SnmpPeer peer : this._peers2RowsId.keySet()) {
                vbl = new VarBindList();
                vbl.add(new SnmpVarBind(new SnmpOID(_czseSessionControlResult, (int)this._vsan.getId())));
                peers2Vbl.put(peer, vbl);
            }
        }
        this._numOutstanding.set(0);
        object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpPDU pdu = new SnmpPDU(-96, vbl);
                pdu.setRetries(0);
                try {
                    peer.send(pdu, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._peers2RowsId.size() != 0) {
                this.pollSwitches();
                return;
            }
            this._statusTimer.stop();
            BrowserFrame.getInstance();
            BrowserFrame.getDataView().refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(peer, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            if (((SnmpOID)firstOid).startsWith(this._firstOid)) {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
            VarBindList vbl = pdu.getVariables();
            for (int i = 0; i < vbl.size(); ++i) {
                int sessionResult = vbl.intValue(i);
                SnmpVar sessionResultVar = vbl.getVb(i).getVar();
                int row = (Integer)this._peers2RowsId.get(peer);
                this.setValueAt(sessionResultVar.getType() != 5 ? MibEnum.getLabel(_czseSessionCntrlResEnum, sessionResult) : "n/a", row, 10);
                if (sessionResult == 3) continue;
                HashMap hashMap = this._peers2RowsId;
                synchronized (hashMap) {
                    this._peers2RowsId.remove(peer);
                    continue;
                }
            }
        } else {
            firstOid = this._peers2RowsId;
            synchronized (firstOid) {
                this._peers2RowsId.remove(peer);
            }
        }
        this.fireTableDataChanged();
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
    }

    private boolean isCommitRequired(boolean buildMap) {
        Array changedCells;
        boolean needsCommit = false;
        if (this.isEnhancedMode() && (changedCells = this.getChanged()) != null) {
            for (int i = 0; i < changedCells.size(); ++i) {
                Cell cell = (Cell)changedCells.elementAt(i);
                if (cell._col == 9) continue;
                if (buildMap) {
                    return true;
                }
                SnmpPeer peer = (SnmpPeer)this.getValueAt(cell._row, 0);
                this._peers2RowsId.put(peer, new Integer(cell._row));
                needsCommit = true;
            }
        }
        return needsCommit;
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        HashMap map = super.buildSendPdus();
        if (this.isCommitRequired(false)) {
            for (SnmpPeer peer : map.keySet()) {
                SnmpPDU pdu = (SnmpPDU)map.get(peer);
                VarBindList vbl = pdu.getVariables();
                vbl.add(_czseSessionControl, this._vsan.getId(), (SnmpVar)new SnmpInt(1));
            }
        }
        return map;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
    }

    @Override
    protected int[] buildGetVBLIndex(int[] index, int mibNodeIndex) {
        int[] nArray;
        if (mibNodeIndex == 9 + this._offset - 2) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = index;
        }
        return nArray;
    }
}

