/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.model.San;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class TimerDialog
extends JDialog
implements SnmpCallbackIf,
ActionListener {
    static final String[] _BtnLabels = new String[]{"Apply", "Close"};
    JComponent[] _values;
    String[] _labels;
    JButton[] _buttons;
    JLabel _status;
    String[] _vars;
    protected MibNode[] _mibNodes;
    SnmpPeer[] _peers;
    HashMap _timedoutPeers;
    boolean _vsanOperStateDown = true;
    final String[] _vsanState = new String[]{"vsanOperState"};
    static final int R_A_TOV_DLG = 2;
    static final int D_S_TOV_DLG = 3;
    static final int E_D_TOV_DLG = 4;
    long _edtovSW;
    protected final SyncedInt _numOutstanding = new SyncedInt(0);

    public TimerDialog(JFrame parent, long[] timeoutValues) {
        super((Frame)parent, "Change Timeouts");
        this._peers = San.getInstance().getSnmpPeers();
        this._timedoutPeers = new HashMap();
        this._vars = new String[3];
        this._vars[0] = "fcTimerRatov";
        this._vars[1] = "fcTimerDstov";
        this._vars[2] = "fcTimerEdtov";
        this._mibNodes = new MibNode[3];
        this._labels = new String[5];
        this._labels[2] = "R_A_TOV";
        this._labels[3] = "D_S_TOV";
        this._labels[4] = "E_D_TOV";
        this._edtovSW = timeoutValues[2];
        this._values = new JComponent[this._labels.length];
        this._values[0] = new JLabel("<html>Timeout Values need to be sync'ed <br>across all switches within the fabric</html>");
        this._values[1] = new DialogSeparator();
        for (int i = 0; i < this._vars.length; ++i) {
            this._mibNodes[i] = MibNode.get(this._vars[i]);
            this._values[i + 2] = this.buildComponent(this._vars[i], this._mibNodes[i]);
            ((FieldPanel)this._values[i + 2]).setText(Long.toString(timeoutValues[i]));
        }
        JPanel fields = DialogUtil.buildPanel(DialogUtil.buildLabels(this._labels), this._values);
        JPanel p = new JPanel(new BorderLayout());
        p.add("Center", fields);
        this._status = new JLabel(" ");
        p.add("South", this._status);
        this._buttons = DialogUtil.buildButtons(_BtnLabels, (ActionListener)this);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)p, (AbstractButton[])this._buttons);
        this.setResizable(true);
    }

    JComponent buildComponent(String mibVar, MibNode mibNode) {
        int width = mibNode.getMaxWidth();
        if (mibNode.getHi() != 0) {
            return new FieldPanel(width, mibNode.getLo(), mibNode.getHi(), (String)SnmpTableModel._Units.get(mibVar));
        }
        String units = (String)SnmpTableModel._Units.get(mibVar);
        return new FieldPanel(width, (JComponent)new JLabel(" " + units));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block7: {
            try {
                switch (((AbstractButton)e.getSource()).getText().charAt(0)) {
                    case 'A': {
                        if (!this.applyAction()) {
                            return;
                        }
                    }
                    case 'C': {
                        this.dispose();
                    }
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                if (!SnmpSession.isTrace()) break block7;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean applyAction() throws Exception {
        this.checkComponentValue();
        this._timedoutPeers.clear();
        this._vsanOperStateDown = true;
        this._status.setText("Querying Vsan State Info...");
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < this._peers.length; ++i) {
                SnmpFetch f = new SnmpFetch();
                f.getBulk(this._peers[i], this._vsanState, (SnmpCallbackIf)this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            object = this._numOutstanding;
            synchronized (object) {
                this._numOutstanding.wait(SnmpPeer._Timeout * (SnmpPeer._Retries + 1) + 5000);
            }
        }
        if (!this._vsanOperStateDown) {
            JOptionPane.showMessageDialog(null, "<html>Not all VSANs are down for all switches in the Fabric.<br> Please bring down all VSANs before change the timeout values.</html>", "Error", 0);
            this._status.setText(" ");
            return false;
        }
        this._status.setText("Sending new timeout values...");
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        long dstov = ((FieldPanel)this._values[3]).getInt();
        int edtov = Integer.parseInt(((FieldPanel)this._values[4]).getText());
        for (int i = 0; i < this._peers.length; ++i) {
            SnmpPeer peer = this._peers[i];
            if (this._timedoutPeers.get(peer) != null) continue;
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.setAddress(peer.getAddress());
            pdus.put(peer, pdu);
            pdu.addVar(new SnmpOID(this._mibNodes[0].getOid(), 0), new SnmpGauge(((FieldPanel)this._values[2]).getInt()));
            if (dstov < this._edtovSW) {
                pdu.addVar(new SnmpOID(this._mibNodes[2].getOid(), 0), new SnmpGauge(edtov));
                pdu.addVar(new SnmpOID(this._mibNodes[1].getOid(), 0), new SnmpGauge(dstov));
                continue;
            }
            pdu.addVar(new SnmpOID(this._mibNodes[1].getOid(), 0), new SnmpGauge(dstov));
            pdu.addVar(new SnmpOID(this._mibNodes[2].getOid(), 0), new SnmpGauge(edtov));
        }
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        int successfulSets = aggregrate.set(pdus.keySet().iterator(), pdus.values().iterator(), null);
        if (successfulSets < pdus.size()) {
            String strErr = "Succeeded on " + successfulSets + " of " + pdus.size() + " device(s).  See log for details.";
            this._status.setText(strErr);
            throw new SnmpException(aggregrate.getErrors());
        }
        this._status.setText(" ");
        this._edtovSW = edtov;
        BrowserFrame.getDataView().refresh();
        return true;
    }

    void checkComponentValue() throws Exception {
        for (int i = 2; i < this._values.length - 1; ++i) {
            try {
                long value = ((FieldPanel)this._values[i]).getInt();
                continue;
            }
            catch (NumberFormatException ex) {
                String var = this._labels[i];
                if (ex.getMessage() == null || ex.getMessage().length() <= 0) continue;
                throw new Exception(var + ": " + ex.getMessage());
            }
        }
        int edtov = Integer.parseInt(((FieldPanel)this._values[4]).getText());
        int dstov = Integer.parseInt(((FieldPanel)this._values[3]).getText());
        if (edtov < this._mibNodes[2].getLo() || edtov > dstov) {
            throw new NumberFormatException(this._vars[2] + ' ' + "not in range");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object node;
        if (this._vsanOperStateDown) {
            node = SnmpPeer.findPeer(pdu.getAddress());
            if (!timedOut && pdu.getError() == 0) {
                VarBindList vbl = pdu.getVariables();
                for (int i = 0; i < vbl.size(); ++i) {
                    int vsanOperState = vbl.intValue(i);
                    if (vsanOperState == 2) continue;
                    this._vsanOperStateDown = false;
                    break;
                }
            } else if (timedOut) {
                this._timedoutPeers.put(node, node);
            }
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                node = this._numOutstanding;
                synchronized (node) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
    }
}

