/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.PerspectiveIf;
import com.cisco.dcbu.lib.ui.PerspectiveManager;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmFcIfMultiIndexedTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class TrunkStatusTableModel
extends SmFcIfMultiIndexedTableModel
implements MouseListener {
    static final int FAILURECAUSE_MIB = 0;
    static final int NONE = 2;

    public TrunkStatusTableModel(int ifType, short addVsanId) {
        super(ifType, addVsanId);
        BrowserFrame.getTable().addMouseListener(this);
    }

    @Override
    protected boolean isModelTypeSupported(SnmpPeer peer) {
        boolean supported = super.isModelTypeSupported(peer);
        if (supported && this._ifType == 8) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            supported = sw.getSwitchBase().isFCoEEnabled();
            if (sw.isN5K() && !sw.isVersionGreaterThanEqual("4.0(1a)")) {
                supported = false;
            }
        }
        return supported;
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        if (vbl.intValue(0) == 2) {
            return null;
        }
        return super.addElement(vbl, node, index);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        BrowserFrame.getTable().removeMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof KTable && e.getClickCount() > 1) {
            Array data;
            Object[] row;
            String failureReason;
            Point p = e.getPoint();
            KTable t = (KTable)e.getSource();
            int r = t.rowAtPoint(p);
            int c = t.columnAtPoint(p);
            int modelcol = BrowserFrame.getDataView()._table.convertColumnIndexToModel(c);
            if (modelcol == 0 + this._offset && (failureReason = (String)(row = (Object[])(data = this.getData()).elementAt(r))[modelcol]) != null && MibVariableFormat._FcIfOperStatusReason[23].getLabel().equals(failureReason)) {
                SnmpPeer peer = (SnmpPeer)row[0];
                int ifIndex = ((SnmpOID)row[1]).getValue()[0];
                short vsanId = (short)((SnmpOID)row[1]).getValue()[1];
                Switch sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(peer.getAddress());
                if (!sw.isMDS()) {
                    return;
                }
                Vsan vsan = sw.getVsan(vsanId);
                try {
                    PerspectiveIf view = PerspectiveManager.getInstance().getView();
                    if (view != null && view.isVisible("menu", "Zone Merge")) {
                        UIActions.getInstance().invokeZoneMerge(sw.ifIndexToName(ifIndex), vsan, peer);
                    }
                    UIActions.getInstance().invokeZoneMerge(sw.ifIndexToName(ifIndex), vsan, peer);
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

