/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dmmsewizard.DmmSeWizardBase;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardContainer;
import com.cisco.dcbu.sm.client.dmmsewizard.SwitchCardPeerTableModel;
import com.cisco.dcbu.sm.client.dmmsewizard.WizardInstance;
import com.cisco.dcbu.sm.common.dto.DMMPeerCfg;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ConfigurePeerRoute
extends WizardPanel
implements ActionListener {
    public static final String TABLE_PANEL = new String("Table Panel");
    public static final String TEXT_PANEL = new String("Text Panel");
    public static final String StepTitle = ": Configure Route to Peer.";
    public static final String StepDesc = "This step is optional if the CPP won\u0092t be used for multiple fabric or Vsan jobs.  This will create a route on the first switch to the IP address of the peer CPP through the peer mgmt0 interface and do the reverse on the peer switch (this is necessary for CPP communication if multiple fabric or VSAN jobs are to be created).";
    private DmmSeWizardBase.WizardType _type;
    private int _instanceID;
    private List<SwitchCardContainer> _selectedSwitchCards = new ArrayList<SwitchCardContainer>();
    private JComboBox _selectedSwitchCardBox;
    private JComboBox _peerSwitchCardBox;
    private JCheckBox _multipleFabricsCheckBox;
    private JButton[] _buttons;
    private JScrollPane _scrPanel;
    private SwitchCardPeerTableModel _swPeerTableModel;
    private KTable _swPeerTable;
    private Map<SwitchCardContainer, String> _ipForPeerCreation;
    private CardLayout _cardLayout;
    JTextArea _textPanelTextArea;
    JPanel _mainPanel;

    public ConfigurePeerRoute(DmmSeWizardBase wizard, int stepNumber, DmmSeWizardBase.WizardType type, int instanceID) {
        super("Step " + stepNumber + StepTitle, StepDesc, wizard, wizard.getIcon());
        this._instanceID = instanceID;
        this._type = type;
        this._selectedSwitchCards.clear();
        this._selectedSwitchCards.addAll(wizard.getSelectedSwitchModules());
        this.initialize();
    }

    private void initialize() {
        this._cardLayout = new CardLayout();
        this._mainPanel = new JPanel(this._cardLayout);
        JPanel mainTablePanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEtchedBorder(1));
        JLabel[] labels = DialogUtil.buildLabels(new String[]{"Switch, Module", "Peer Switch, Module"});
        Dimension labelDim = new Dimension(120, 20);
        JPanel compPanel = new JPanel();
        compPanel.setLayout(new BoxLayout(compPanel, 1));
        JPanel row1 = new JPanel(new FlowLayout(0));
        JPanel row2 = new JPanel(new FlowLayout(0));
        JPanel row3 = new JPanel(new FlowLayout(0));
        this._multipleFabricsCheckBox = new JCheckBox("Multiple Fabric Job support.");
        this._multipleFabricsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    ConfigurePeerRoute.this.updateFields(false);
                } else {
                    ConfigurePeerRoute.this.updateFields(true);
                }
            }
        });
        row1.add(this._multipleFabricsCheckBox);
        compPanel.add(row1);
        this._selectedSwitchCardBox = new JComboBox<Object>(this._selectedSwitchCards.toArray());
        this._selectedSwitchCardBox.setPreferredSize(new Dimension(200, 22));
        labels[0].setPreferredSize(labelDim);
        row2.add(labels[0]);
        row2.add(this._selectedSwitchCardBox);
        compPanel.add(row2);
        labels[1].setPreferredSize(labelDim);
        row3.add(labels[1]);
        this._peerSwitchCardBox = new JComboBox<Object>(this._selectedSwitchCards.toArray());
        this._peerSwitchCardBox.setPreferredSize(new Dimension(200, 22));
        row3.add(this._peerSwitchCardBox);
        compPanel.add(row3);
        topPanel.add(compPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        for (JButton nextButton : this._buttons = DialogUtil.buildButtons(new String[][]{{"Add", "A"}, {"Delete", "D"}, {"Delete All", "DA"}}, (ActionListener)this)) {
            buttonPanel.add(nextButton);
        }
        bottomPanel.add((Component)buttonPanel, "North");
        this._swPeerTableModel = new SwitchCardPeerTableModel(new String[]{"Switch,Module", "Peer Switch,Module"});
        this._swPeerTableModel.setEditable(new boolean[]{false, false});
        this._swPeerTable = new KTable(this._swPeerTableModel);
        this._swPeerTable.setSelectionMode(0);
        this._swPeerTable.setAutoResizeMode(4);
        this._swPeerTable.getTableHeader().addMouseListener(new HeaderListener());
        this._swPeerTable.setSortable(true);
        this._scrPanel = new JScrollPane(this._swPeerTable);
        bottomPanel.add((Component)this._scrPanel, "Center");
        mainTablePanel.add((Component)topPanel, "North");
        mainTablePanel.add((Component)bottomPanel, "Center");
        this._mainPanel.add((Component)mainTablePanel, TABLE_PANEL);
        this._mainPanel.add((Component)this.createTextPanel(), TEXT_PANEL);
        this.add((Component)this._mainPanel, "Center");
        this.updateFields(false);
    }

    private JPanel createTextPanel() {
        JPanel skipPanel = new JPanel();
        this._textPanelTextArea = new JTextArea("");
        this._textPanelTextArea.setOpaque(false);
        this._textPanelTextArea.setEditable(false);
        skipPanel.add(this._textPanelTextArea);
        return skipPanel;
    }

    @Override
    public boolean refresh() {
        this.getWizard().getNavigator().getBackBtn().setEnabled(false);
        List<SwitchCardContainer> newlySelectedSwitchCard = ((DmmSeWizardBase)this.getWizard()).getSelectedSwitchModules();
        this._selectedSwitchCards.clear();
        this._selectedSwitchCards.addAll(newlySelectedSwitchCard);
        DefaultComboBoxModel<SwitchCardContainer> selectedModel = new DefaultComboBoxModel<SwitchCardContainer>(this._selectedSwitchCards.toArray(new SwitchCardContainer[this._selectedSwitchCards.size()]));
        this._selectedSwitchCardBox.setModel(selectedModel);
        List<SwitchCardContainer> possiblePeers = ((DmmSeWizardBase)this.getWizard()).getValidPeers();
        possiblePeers.addAll(newlySelectedSwitchCard);
        try {
            this._ipForPeerCreation = this.getVsanOrCppInfo(possiblePeers);
            ArrayList<SwitchCardContainer> validPeers = new ArrayList<SwitchCardContainer>();
            validPeers.addAll(this._ipForPeerCreation.keySet());
            DefaultComboBoxModel<SwitchCardContainer> peerModel = new DefaultComboBoxModel<SwitchCardContainer>(validPeers.toArray(new SwitchCardContainer[validPeers.size()]));
            this._peerSwitchCardBox.setModel(peerModel);
            this._cardLayout.show(this._mainPanel, TABLE_PANEL);
        }
        catch (Exception e) {
            String textMsg = "Encountered an Error while trying to retrieve VSAN IP and CPP data from the switches.\nUnable to continue at this time.\nError received: " + e.getMessage();
            this.getWizard().getNavigator().getNextBtn().setEnabled(false);
            this._textPanelTextArea.setText(textMsg);
            this._cardLayout.show(this._mainPanel, TEXT_PANEL);
            return false;
        }
        return super.refresh();
    }

    private Map<SwitchCardContainer, String> getVsanOrCppInfo(List<SwitchCardContainer> swCards) throws Exception {
        ArrayList<SwitchBase> swBases = new ArrayList<SwitchBase>();
        ArrayList<Card> cards = new ArrayList<Card>();
        for (SwitchCardContainer next : swCards) {
            if (next.getCard().getType() == 41 || next.getCard().getType() == 68) {
                swBases.add(next.getSwitch().getSwitchBase());
                continue;
            }
            cards.add(next.getCard());
        }
        HashMap<SwitchBase, List<String>> vsanInfo = new HashMap<SwitchBase, List<String>>();
        HashMap<Card, List<String>> cppInfo = new HashMap<Card, List<String>>();
        if (!swBases.isEmpty()) {
            vsanInfo.putAll(ClientController.getInstance().getDDMServerRif().getVSanIpAddress(swBases));
        }
        if (!cards.isEmpty()) {
            cppInfo.putAll(ClientController.getInstance().getDDMServerRif().getCppIpAddress(cards));
        }
        HashMap<SwitchCardContainer, String> ipForPeerCreation = new HashMap<SwitchCardContainer, String>();
        for (SwitchCardContainer next : swCards) {
            List ipStrs;
            if (next.getCard().getType() == 41 || next.getCard().getType() == 68) {
                ipStrs = (List)vsanInfo.get(next.getSwitch().getSwitchBase());
                if (ipStrs == null || ipStrs.isEmpty()) continue;
                ipForPeerCreation.put(next, (String)ipStrs.get(0));
                continue;
            }
            ipStrs = (List)cppInfo.get(next.getCard());
            if (ipStrs == null || ipStrs.isEmpty()) continue;
            ipForPeerCreation.put(next, (String)ipStrs.get(0));
        }
        return ipForPeerCreation;
    }

    private byte[] getIP(String ipStr) {
        try {
            int slash = ipStr.indexOf(47);
            SnmpIpAddress snmpIpAddr = slash == -1 ? new SnmpIpAddress(ipStr) : new SnmpIpAddress(ipStr.substring(0, slash));
            byte[] ipAddr = snmpIpAddr.getValue();
            return ipAddr;
        }
        catch (SnmpException se) {
            if (se.getMessage().contains("IPv4MappedIPv6")) {
                // empty if block
            }
            return null;
        }
    }

    private int getMask(String ipStr) throws SnmpException {
        int slash = ipStr.indexOf(47);
        int prefix = 0;
        try {
            if (slash != -1) {
                prefix = Integer.parseInt(ipStr.substring(slash + 1));
            }
            return prefix;
        }
        catch (NumberFormatException ex) {
            throw new SnmpException("bad mask");
        }
    }

    @Override
    public void doNext() {
        if (this._multipleFabricsCheckBox.isSelected()) {
            this.getWizard().getNavigator().getNextBtn().setEnabled(false);
            Array data = this._swPeerTableModel.getData();
            ArrayList<DMMPeerCfg> dmmPeerCfg = new ArrayList<DMMPeerCfg>();
            HashMap<Card, SwitchCardContainer> cardMap = new HashMap<Card, SwitchCardContainer>();
            for (int i = 0; i < data.size(); ++i) {
                Object[] row = (Object[])data.elementAt(i);
                SwitchCardContainer nextSwCard = (SwitchCardContainer)row[SwitchCardPeerTableModel.Column.SWITCH_MODULE.ordinal()];
                SwitchCardContainer nextPeerCard = (SwitchCardContainer)row[SwitchCardPeerTableModel.Column.PEER.ordinal()];
                cardMap.put(nextSwCard.getCard(), nextSwCard);
                cardMap.put(nextPeerCard.getCard(), nextPeerCard);
                String swCardIPStr = this._ipForPeerCreation.get(nextSwCard);
                String peerCardIPStr = this._ipForPeerCreation.get(nextPeerCard);
                byte[] swCardIP = this.getIP(swCardIPStr);
                byte[] peerCardIP = this.getIP(peerCardIPStr);
                int swCardMask = 32;
                int peerCardMask = 32;
                dmmPeerCfg.add(new DMMPeerCfg(nextSwCard.getCard(), swCardIP, swCardMask, nextPeerCard.getCard(), peerCardIP, peerCardMask));
            }
            if (dmmPeerCfg.size() > 0) {
                SetRouteThread setTh = new SetRouteThread(cardMap, dmmPeerCfg, this);
                setTh.start();
            } else {
                int response = JOptionPane.showConfirmDialog(this.getWizard(), "The peer table is empty but you have checked the \"Multiple Fabric Job Support\" checkbox.  \nIf you continue you will not have the ability to use these Modules for multiple fabric jobs.\nContinue?", "Warning: No peers were created.", 2);
                if (response == 2) {
                    this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                    return;
                }
                this.doNextNoChecking();
            }
        } else {
            this.doNextNoChecking();
        }
    }

    protected void doNextNoChecking() {
        if (!((WizardInstance)((Object)this.getWizard())).isDisposed(this._instanceID)) {
            this.getWizard().getNavigator().getNextBtn().setEnabled(false);
            this.setDataValid(false);
            super.doNext();
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("A")) {
            SwitchCardContainer selectedSwitchCard = (SwitchCardContainer)this._selectedSwitchCardBox.getSelectedItem();
            if (selectedSwitchCard == null) {
                Util.errorMessage((Component)this, new Exception("No selected Switch,Module to add"));
                return;
            }
            SwitchCardContainer peerSwitchCard = (SwitchCardContainer)this._peerSwitchCardBox.getSelectedItem();
            try {
                if (selectedSwitchCard.equals(peerSwitchCard)) {
                    throw new Exception("A Switch, Module can not be peered with itself.");
                }
                this._swPeerTableModel.addEntry(selectedSwitchCard, peerSwitchCard);
                return;
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                return;
            }
        }
        if (cmd.equals("DA")) {
            this._swPeerTableModel.clearAll();
            return;
        }
        if (!cmd.equals("D")) return;
        int[] selectedRows = this._swPeerTable.getSelectedRows();
        if (selectedRows != null && selectedRows.length > 0) {
            this._swPeerTableModel.deleteRows(selectedRows);
            return;
        }
        Util.errorMessage((Component)this, "There are no selected rows.");
    }

    private void updateFields(boolean enabled) {
        Array data = this._swPeerTableModel.getData();
        if (!enabled && data != null && data.size() > 0) {
            int response = JOptionPane.showConfirmDialog(this.getWizard(), "There are entries in the peer table that will be removed if you uncheck the \"Multiple Fabric Job Support\".  \nClick OK to continue and these entries will be removed.", "Warning: entries in peer table will be removed.", 2);
            if (response == 2) {
                this._multipleFabricsCheckBox.setSelected(true);
                return;
            }
            this._swPeerTableModel.clearAll();
        }
        this._selectedSwitchCardBox.setEnabled(enabled);
        this._peerSwitchCardBox.setEnabled(enabled);
        for (JButton nextButton : this._buttons) {
            nextButton.setEnabled(enabled);
        }
    }

    class SetRouteThread
    extends Thread {
        List<DMMPeerCfg> _peerCfg;
        ConfigurePeerRoute _callingStep;
        Map<Card, SwitchCardContainer> _cardMap;

        public SetRouteThread(Map<Card, SwitchCardContainer> cardMap, List<DMMPeerCfg> peerCfg, ConfigurePeerRoute callingStep) {
            this._peerCfg = peerCfg;
            this._cardMap = cardMap;
            this._callingStep = callingStep;
        }

        @Override
        public void run() {
            try {
                HashMap<DMMPeerCfg, Exception> failures = ClientController.getInstance().getDDMServerRif().createPeerRoutes(this._peerCfg);
                if (failures.size() == 0) {
                    ConfigurePeerRoute.this.doNextNoChecking();
                } else {
                    Object[] msgAndList = new Object[2];
                    msgAndList[0] = new String("Unable to setup Peer Routes for all cards.\nUnable to continue at this time.\nError(s) received:");
                    String[] strErrors = new String[failures.size()];
                    int index = 0;
                    for (DMMPeerCfg nextPeer : failures.keySet()) {
                        Exception err = failures.get(nextPeer);
                        SwitchCardContainer swCard = this._cardMap.get(nextPeer.getSourceCard());
                        SwitchCardContainer peerSwCard = this._cardMap.get(nextPeer.getPeerCard());
                        StringBuilder errMs = new StringBuilder(swCard + ",Peer:" + peerSwCard + " :");
                        errMs.append(Util.getErrorMessage(err));
                        strErrors[index] = errMs.toString();
                    }
                    JList<String> displayList = new JList<String>(strErrors);
                    JScrollPane scrPan = new JScrollPane(displayList);
                    scrPan.setPreferredSize(new Dimension(650, 100));
                    msgAndList[1] = scrPan;
                    JOptionPane.showMessageDialog(ConfigurePeerRoute.this.getWizard(), msgAndList, "Error :" + ((DmmSeWizardBase)ConfigurePeerRoute.this.getWizard()).getTitle(), 0);
                    ConfigurePeerRoute.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                }
            }
            catch (Exception e) {
                Util.errorMessage((Component)ConfigurePeerRoute.this.getWizard(), "Unable to setup Peer Routes for all cards.\nUnable to continue at this time.\nError received: " + e.getMessage());
                ConfigurePeerRoute.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            }
        }
    }
}

