/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dmmsewizard;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.dmmsewizard.ConfigureCppIPStep;
import com.cisco.dcbu.sm.client.dmmsewizard.ConfigurePeerRoute;
import com.cisco.dcbu.sm.client.dmmsewizard.ConfigureVsanIPStep;
import com.cisco.dcbu.sm.client.dmmsewizard.ConfigureZoneStep;
import com.cisco.dcbu.sm.client.dmmsewizard.DmmSeEnableStep;
import com.cisco.dcbu.sm.client.dmmsewizard.DmmSeSelectModuleStep;
import com.cisco.dcbu.sm.client.dmmsewizard.DmmSeWizardBase;
import com.cisco.dcbu.sm.client.dmmsewizard.EnableSSHStep;
import com.cisco.dcbu.sm.client.dmmsewizard.WizardInstance;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class DmmPreWizard
extends DmmSeWizardBase
implements WizardInstance {
    public static final Logger _Logger = Logger.getLogger(DmmPreWizard.class);
    public static final String Wizard_Title = "DMM Pre-configuration Wizard";
    public static final ImageIcon WIZARD_ICON = Util.loadIcon("icons/data_copy_new.png");
    public static final String Card_Step1 = "Step1";
    public static final String Card_Step2 = "Step2";
    public static final String Card_Step3 = "Step3";
    public static final String Card_Step4 = "Step4";
    public static final String Card_Step5 = "Step5";
    public static final String Card_Step6 = "Step6";
    public static final String Card_Step7 = "Step7";
    private static int _WizardId = 0;
    private static DmmPreWizard _Instance = null;

    protected DmmPreWizard(JFrame parent) {
        super(parent, DmmSeWizardBase.WizardType.DMM_WIZARD, WIZARD_ICON);
    }

    public static synchronized DmmPreWizard createInstance(JFrame parent) throws Exception {
        block8: {
            if (_Instance == null) {
                try {
                    _Instance = new DmmPreWizard(parent);
                }
                catch (Exception e) {
                    if (_Instance != null) {
                        _Instance.dispose();
                        _Instance = null;
                    }
                    break block8;
                }
            }
            int option = JOptionPane.showConfirmDialog(_Instance.getFrame(), _Instance.getTitle() + " is running. \n\nDo you want to dispose the current one and open a new one?", "DMM Pre-configuration Wizard Warning", 2, 0);
            if (option == 0) {
                _Instance.dispose();
                try {
                    _Instance = new DmmPreWizard(parent);
                }
                catch (Exception e) {
                    if (_Instance != null) {
                        _Instance.dispose();
                    }
                    throw e;
                }
            }
        }
        return _Instance;
    }

    @Override
    protected void initialize() {
        ++_WizardId;
        this.setSize(Default_Wizard_Size);
        this.setTitle(Wizard_Title);
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    _Instance.getCurrent().doCancel();
                }
                catch (Exception ex) {
                    _Logger.error((Object)ex.getMessage());
                }
            }
        });
    }

    @Override
    public boolean isDisposed(int instanceId) {
        return _Instance == null || instanceId != _WizardId;
    }

    @Override
    public int getWizardInstanceId() {
        return _WizardId;
    }

    @Override
    public void dispose() {
        _Instance = null;
        super.dispose();
    }

    @Override
    protected void addWizardSteps() {
        int stepNumber = 1;
        DmmSeSelectModuleStep step1 = new DmmSeSelectModuleStep(this, stepNumber++, DmmSeWizardBase.WizardType.DMM_WIZARD, _WizardId);
        step1.setDataValid(false);
        this.addPanel(Card_Step1, step1);
        EnableSSHStep step2 = new EnableSSHStep(this, stepNumber++, _WizardId);
        step2.setDataValid(false);
        this.addPanel(Card_Step2, step2);
        ConfigureVsanIPStep step3 = new ConfigureVsanIPStep(this, stepNumber++, DmmSeWizardBase.WizardType.DMM_WIZARD, _WizardId);
        step3.setDataValid(false);
        this.addPanel(Card_Step3, step3);
        ConfigureCppIPStep step4 = new ConfigureCppIPStep(this, stepNumber++, DmmSeWizardBase.WizardType.DMM_WIZARD, _WizardId);
        step4.setDataValid(false);
        this.addPanel(Card_Step4, step4);
        ConfigurePeerRoute step5 = new ConfigurePeerRoute(this, stepNumber++, DmmSeWizardBase.WizardType.DMM_WIZARD, _WizardId);
        step5.setDataValid(false);
        this.addPanel(Card_Step5, step5);
        ConfigureZoneStep step6 = new ConfigureZoneStep(this, stepNumber++, DmmSeWizardBase.WizardType.DMM_WIZARD, _WizardId);
        step6.setDataValid(false);
        this.addPanel(Card_Step6, step6);
        DmmSeEnableStep step7 = new DmmSeEnableStep(this, stepNumber++, DmmSeWizardBase.WizardType.DMM_WIZARD, _WizardId);
        step7.setDataValid(false);
        this.addPanel(Card_Step7, step7);
        this.first();
        this.setVisible(true);
    }
}

