/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.event;

import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.event.EventLogListenerIf;
import com.cisco.dcbu.sm.client.event.EventLogTable;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class EventLog {
    public static final String[] _Headers = new String[]{"Fabric", "Switch", "Type", "Time", "Severity", "Description"};
    public static final int[] _colWidth = new int[]{90, 90, 90, 120, 130, 300};
    public static final boolean[] _colEditable = new boolean[]{false, false, false, false, false, false};
    public static int FABRIC = 0;
    public static int SWITCH = 1;
    public static int TYPE = 2;
    public static int TIME = 3;
    public static int SEVERITY = 4;
    public static int DESC = 5;
    public static int DATE_OBJ = 7;
    static ArrayList<EventLogListenerIf> _eventListeners = new ArrayList();
    static int _Max = 5000;
    static DateFormat _DateFormat = SnmpTimeticks.getDateFormat();
    static boolean _AudibleAlert;
    static EventLog _Instance;
    Array _events = new Array(10);
    EventLogTable _eventLogTable;

    private EventLog() {
    }

    public static EventLog getInstance() {
        if (_Instance == null) {
            _Instance = new EventLog();
        }
        return _Instance;
    }

    public static void addListener(EventLogListenerIf listener) {
        if (_eventListeners == null) {
            _eventListeners = new ArrayList();
        }
        if (!_eventListeners.contains(listener)) {
            _eventListeners.add(listener);
        }
    }

    public static void removeListener(EventLogListenerIf listener) {
        if (_eventListeners != null) {
            _eventListeners.remove(listener);
        }
    }

    public synchronized void notifyListenersEventAdded(Fabric fab, Switch sw, Object[] cols) {
        if (_eventListeners != null) {
            for (int i = 0; i < _eventListeners.size(); ++i) {
                try {
                    _eventListeners.get(i).addEvent(fab, sw, cols);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void notifyListenersEventRemoved(Fabric fab, Switch sw, Object[] cols) {
        if (_eventListeners != null) {
            for (int i = 0; i < _eventListeners.size(); ++i) {
                try {
                    _eventListeners.get(i).removeEvent(fab, sw, cols);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public static final DateFormat getDateFormat() {
        return _DateFormat;
    }

    public static final void setDateFormat(DateFormat dateFormat) {
        _DateFormat = dateFormat;
    }

    public static String getCurrentTime() {
        return _DateFormat.format(new Date());
    }

    public static final void setAudibleAlert(boolean audible) {
        _AudibleAlert = audible;
    }

    public static final boolean getAudibleAlert() {
        return _AudibleAlert;
    }

    public synchronized void removeEventsFor(FabricPK fabricPk) {
        for (int index = this._events.size() - 1; index >= 0; --index) {
            Object[] nextCols = (Object[])this._events.elementAt(index);
            Fabric nextFab = (Fabric)nextCols[FABRIC];
            if (nextFab != null && fabricPk.equals(nextFab.getPK())) {
                this._events.removeElementAt(index);
            }
            this.notifyListenersEventRemoved((Fabric)nextCols[FABRIC], (Switch)nextCols[SWITCH], nextCols);
        }
        if (this._eventLogTable != null) {
            this._eventLogTable._model.fireTableDataChanged();
        }
    }

    public synchronized void removeEventsFor(WwnKey switchPk) {
        for (int index = this._events.size() - 1; index >= 0; --index) {
            Object[] nextCols = (Object[])this._events.elementAt(index);
            Switch nextSw = (Switch)nextCols[SWITCH];
            if (nextSw != null && nextSw.getSwitchPK().equals(switchPk)) {
                this._events.removeElementAt(index);
            }
            this.notifyListenersEventRemoved((Fabric)nextCols[FABRIC], (Switch)nextCols[SWITCH], nextCols);
        }
        if (this._eventLogTable != null) {
            this._eventLogTable._model.fireTableDataChanged();
        }
    }

    public void logEvent(LogEvent event) {
        Object[] cols = this.constructRow(event);
        this.addEvent(cols);
    }

    private Object[] constructRow(LogEvent event) {
        Object[] cols = new Object[_Headers.length + 2];
        FabricPK fpk = (FabricPK)event.getSource();
        WwnKey switchPk = event.getSwitchPk();
        Fabric fab = null;
        Switch sw = null;
        if (fpk != null) {
            fab = San.getInstance().getFabric(fpk);
        }
        if (switchPk != null) {
            sw = San.getInstance().getSwitchByPK(switchPk);
        }
        Date date = new Date(event.getTimeStamp());
        cols[0] = fab;
        cols[1] = sw;
        cols[2] = event.getType().toString();
        cols[3] = _DateFormat.format(date);
        cols[4] = event.getSeverity().toString();
        cols[5] = event.getDescription();
        cols[7] = date;
        return cols;
    }

    public synchronized void logEvents(List<LogEvent> events) {
        Array<Object[]> eventsToAdd = new Array<Object[]>(events.size());
        for (LogEvent nextEvent : events) {
            Object[] cols = this.constructRow(nextEvent);
            eventsToAdd.addElement(cols);
        }
        this._events = this._events.size() == 0 ? eventsToAdd : this.merge(this._events, eventsToAdd);
    }

    private Array merge(Array existingEvents, Array newEvents) {
        int exIndex = 0;
        int newIndex = 0;
        int k = 0;
        int m = existingEvents.size();
        int n = newEvents.size();
        Array<Object> mergedEvents = new Array<Object>(m + n);
        while (exIndex < m && newIndex < n) {
            Object[] nextNewCols;
            Date nextNewDate;
            Object[] nextExCols = (Object[])existingEvents.elementAt(exIndex);
            Date nextExDate = (Date)nextExCols[DATE_OBJ];
            if (nextExDate.after(nextNewDate = (Date)(nextNewCols = (Object[])newEvents.elementAt(newIndex))[DATE_OBJ])) {
                mergedEvents.insertElementAt(nextExCols, k);
                ++exIndex;
            } else {
                mergedEvents.insertElementAt(nextNewCols, k);
                ++newIndex;
            }
            ++k;
        }
        if (exIndex < m) {
            for (int p = exIndex; p < m; ++p) {
                mergedEvents.insertElementAt(existingEvents.elementAt(p), k);
                ++k;
            }
        } else {
            for (int p = newIndex; p < n; ++p) {
                mergedEvents.insertElementAt(newEvents.elementAt(p), k);
                ++k;
            }
        }
        return mergedEvents;
    }

    private synchronized void addEvent(Object[] col) {
        if (col.length != _Headers.length + 2) {
            return;
        }
        Date newEventDate = (Date)col[DATE_OBJ];
        int row = this._events.size();
        int eventSize = this._events.size();
        for (int index = 0; index < eventSize; ++index) {
            Object[] nextCols = (Object[])this._events.elementAt(index);
            Date nextDate = (Date)nextCols[DATE_OBJ];
            if (!newEventDate.after(nextDate)) continue;
            row = index;
            break;
        }
        this._events.insertElementAt(col, row);
        if (this._eventLogTable != null) {
            this._eventLogTable._model.fireTableRowsInserted(row, row);
        }
        this.notifyListenersEventAdded((Fabric)col[FABRIC], (Switch)col[SWITCH], col);
        if (this._events.size() > _Max) {
            int lastElement = this._events.size() - 1;
            Object[] remCols = (Object[])this._events.elementAt(lastElement);
            this._events.removeElementAt(lastElement);
            if (this._eventLogTable != null) {
                this._eventLogTable._model.fireTableDataChanged();
            }
            this.notifyListenersEventRemoved((Fabric)remCols[FABRIC], (Switch)remCols[SWITCH], remCols);
        }
        if (_AudibleAlert) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public synchronized Array getFilteredEvents(MgmtDomainIf mgmtDomain) {
        Object[] switches = null;
        if (mgmtDomain == null || mgmtDomain.isSan()) {
            return (Array)this._events.clone();
        }
        switches = mgmtDomain.getSwitches();
        if (switches == null) {
            return new Array();
        }
        Arrays.sort(switches);
        List<Object> swList = Arrays.asList(switches);
        Array<Object[]> filteredEvents = new Array<Object[]>();
        int eventSize = this._events.size();
        for (int i = 0; i < eventSize; ++i) {
            Object[] cols = (Object[])this._events.elementAt(i);
            Switch eventSwitch = (Switch)cols[SWITCH];
            if (eventSwitch != null) {
                if (!swList.contains(eventSwitch)) continue;
                filteredEvents.addElement(cols);
                continue;
            }
            if (mgmtDomain.isFabric() && mgmtDomain.getFabric().equals(cols[FABRIC])) {
                filteredEvents.addElement(cols);
                continue;
            }
            if (!mgmtDomain.isSan()) continue;
            filteredEvents.addElement(cols);
        }
        return filteredEvents;
    }

    public synchronized EventLogTable buildTable() {
        if (this._eventLogTable == null) {
            KTableModel _model = new KTableModel();
            _model.setData(this._events);
            _model.setHeaders(_Headers);
            this._eventLogTable = new EventLogTable(_model);
        }
        return this._eventLogTable;
    }

    public synchronized void clear() {
        this._events.clear();
        if (this._eventLogTable != null) {
            this._eventLogTable._model.fireTableDataChanged();
        }
        System.gc();
    }

    public synchronized void remove(int index) {
        this._events.removeElementAt(index);
        if (this._eventLogTable != null) {
            this._eventLogTable._model.fireTableDataChanged();
        }
    }

    public synchronized void remove() {
        boolean changed = false;
        for (int i = this._events.size() - 1; i >= 0; --i) {
            if (this._eventLogTable == null || !this._eventLogTable.isRowSelected(i)) continue;
            this._events.removeElementAt(i);
            changed = true;
        }
        if (changed && this._eventLogTable != null) {
            this._eventLogTable._model.fireTableDataChanged();
        }
    }
}

